# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhcivm import AzureStackHCIVmClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIVmNetworkInterfacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIVmClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_interfaces_get(self, resource_group):
        response = self.client.network_interfaces.get(
            resource_group_name=resource_group.name,
            network_interface_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_interfaces_begin_create_or_update(self, resource_group):
        response = self.client.network_interfaces.begin_create_or_update(
            resource_group_name=resource_group.name,
            network_interface_name="str",
            resource={
                "location": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "createFromLocal": bool,
                    "dnsSettings": {"dnsServers": ["str"]},
                    "ipConfigurations": [
                        {
                            "name": "str",
                            "properties": {
                                "gateway": "str",
                                "prefixLength": "str",
                                "privateIPAddress": "str",
                                "subnet": {"id": "str"},
                            },
                        }
                    ],
                    "macAddress": "str",
                    "networkSecurityGroup": {"id": "str"},
                    "provisioningState": "str",
                    "status": {
                        "errorCode": "str",
                        "errorMessage": "str",
                        "provisioningStatus": {"operationId": "str", "status": "str"},
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_interfaces_begin_update(self, resource_group):
        response = self.client.network_interfaces.begin_update(
            resource_group_name=resource_group.name,
            network_interface_name="str",
            properties={
                "properties": {"dnsSettings": {"dnsServers": ["str"]}, "networkSecurityGroup": {"id": "str"}},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_interfaces_begin_delete(self, resource_group):
        response = self.client.network_interfaces.begin_delete(
            resource_group_name=resource_group.name,
            network_interface_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_interfaces_list_by_resource_group(self, resource_group):
        response = self.client.network_interfaces.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_interfaces_list_all(self, resource_group):
        response = self.client.network_interfaces.list_all()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
