# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric's aggregation type for e.g. (Average, Total)."""

    AVERAGE = "Average"
    TOTAL = "Total"


class CustomizationHostNameType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of host name."""

    USER_DEFINED = "USER_DEFINED"
    PREFIX_BASED = "PREFIX_BASED"
    FIXED = "FIXED"
    VIRTUAL_MACHINE_NAME = "VIRTUAL_MACHINE_NAME"
    CUSTOM_NAME = "CUSTOM_NAME"


class CustomizationIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity type."""

    WINDOWS_TEXT = "WINDOWS_TEXT"
    WINDOWS = "WINDOWS"
    LINUX = "LINUX"


class CustomizationIPAddressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Customization Specification ip type."""

    CUSTOM = "CUSTOM"
    DHCP_IP = "DHCP_IP"
    FIXED_IP = "FIXED_IP"
    USER_DEFINED = "USER_DEFINED"


class CustomizationPolicyPropertiesType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of customization (Linux or Windows)."""

    LINUX = "LINUX"
    WINDOWS = "WINDOWS"


class DiskIndependenceMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Disk's independence mode type."""

    PERSISTENT = "persistent"
    INDEPENDENT_PERSISTENT = "independent_persistent"
    INDEPENDENT_NONPERSISTENT = "independent_nonpersistent"


class GuestOSNICCustomizationAllocation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP address allocation method."""

    STATIC = "static"
    DYNAMIC = "dynamic"


class GuestOSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Guest OS type."""

    LINUX = "linux"
    WINDOWS = "windows"
    OTHER = "other"


class NICType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NIC type."""

    E1000 = "E1000"
    E1000_E = "E1000E"
    PCNET32 = "PCNET32"
    VMXNET = "VMXNET"
    VMXNET2 = "VMXNET2"
    VMXNET3 = "VMXNET3"


class NodeStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Node status, indicates is private cloud set up on this node or not."""

    UNUSED = "unused"
    USED = "used"


class OnboardingStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """indicates whether account onboarded or not in a given region."""

    NOT_ON_BOARDED = "notOnBoarded"
    ON_BOARDED = "onBoarded"
    ON_BOARDING_FAILED = "onBoardingFailed"
    ON_BOARDING = "onBoarding"


class OperationOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The origin of operation."""

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class StopMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """mode indicates a type of stop operation - reboot, suspend, shutdown or power-off."""

    REBOOT = "reboot"
    SUSPEND = "suspend"
    SHUTDOWN = "shutdown"
    POWEROFF = "poweroff"


class UsageCount(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The usages' unit."""

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNT_PER_SECOND = "CountPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"


class VirtualMachineStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of Virtual machine."""

    RUNNING = "running"
    SUSPENDED = "suspended"
    POWEREDOFF = "poweredoff"
    UPDATING = "updating"
    DEALLOCATING = "deallocating"
    DELETING = "deleting"
