# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, AsyncIterator, Callable, IO, Literal, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._blob_containers_operations import (
    build_clear_legal_hold_request,
    build_create_or_update_immutability_policy_request,
    build_create_request,
    build_delete_immutability_policy_request,
    build_delete_request,
    build_extend_immutability_policy_request,
    build_get_immutability_policy_request,
    build_get_request,
    build_lease_request,
    build_list_request,
    build_lock_immutability_policy_request,
    build_object_level_worm_request,
    build_set_legal_hold_request,
    build_update_request,
)
from .._configuration import StorageManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
List = list


class BlobContainersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.storage.aio.StorageManagementClient`'s
        :attr:`blob_containers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: StorageManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        account_name: str,
        maxpagesize: Optional[str] = None,
        filter: Optional[str] = None,
        include: Optional[Union[str, _models.ListContainersInclude]] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.ListContainerItem"]:
        """Lists all containers and does not support a prefix like data plane. Also SRP today does not
        return continuation token.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param maxpagesize: Optional. Specified maximum number of containers that can be included in
         the list. Default value is None.
        :type maxpagesize: str
        :param filter: Optional. When specified, only container names starting with the filter will be
         listed. Default value is None.
        :type filter: str
        :param include: Optional, used to include the properties for soft deleted blob containers.
         "deleted" Default value is None.
        :type include: str or ~azure.mgmt.storage.models.ListContainersInclude
        :return: An iterator like instance of either ListContainerItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.storage.models.ListContainerItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ListContainerItems] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    maxpagesize=maxpagesize,
                    filter=filter,
                    include=include,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ListContainerItems", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: _models.BlobContainer,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties of the blob container to create. Required.
        :type blob_container: ~azure.mgmt.storage.models.BlobContainer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties of the blob container to create. Required.
        :type blob_container: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: Union[_models.BlobContainer, IO[bytes]],
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties of the blob container to create. Is either a BlobContainer
         type or a IO[bytes] type. Required.
        :type blob_container: ~azure.mgmt.storage.models.BlobContainer or IO[bytes]
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BlobContainer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(blob_container, (IOBase, bytes)):
            _content = blob_container
        else:
            _json = self._serialize.body(blob_container, "BlobContainer")

        _request = build_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BlobContainer", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: _models.BlobContainer,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties to update for the blob container. Required.
        :type blob_container: ~azure.mgmt.storage.models.BlobContainer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties to update for the blob container. Required.
        :type blob_container: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: Union[_models.BlobContainer, IO[bytes]],
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties to update for the blob container. Is either a BlobContainer
         type or a IO[bytes] type. Required.
        :type blob_container: ~azure.mgmt.storage.models.BlobContainer or IO[bytes]
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BlobContainer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(blob_container, (IOBase, bytes)):
            _content = blob_container
        else:
            _json = self._serialize.body(blob_container, "BlobContainer")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BlobContainer", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> _models.BlobContainer:
        """Gets properties of a specified container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.BlobContainer] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BlobContainer", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any) -> None:
        """Deletes specified container under its account.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: _models.LegalHold,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container. Required.
        :type legal_hold: ~azure.mgmt.storage.models.LegalHold
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container. Required.
        :type legal_hold: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: Union[_models.LegalHold, IO[bytes]],
        **kwargs: Any
    ) -> _models.LegalHold:
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container. Is either a
         LegalHold type or a IO[bytes] type. Required.
        :type legal_hold: ~azure.mgmt.storage.models.LegalHold or IO[bytes]
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LegalHold] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(legal_hold, (IOBase, bytes)):
            _content = legal_hold
        else:
            _json = self._serialize.body(legal_hold, "LegalHold")

        _request = build_set_legal_hold_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LegalHold", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: _models.LegalHold,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container. Required.
        :type legal_hold: ~azure.mgmt.storage.models.LegalHold
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container. Required.
        :type legal_hold: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: Union[_models.LegalHold, IO[bytes]],
        **kwargs: Any
    ) -> _models.LegalHold:
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container. Is either a
         LegalHold type or a IO[bytes] type. Required.
        :type legal_hold: ~azure.mgmt.storage.models.LegalHold or IO[bytes]
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LegalHold] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(legal_hold, (IOBase, bytes)):
            _content = legal_hold
        else:
            _json = self._serialize.body(legal_hold, "LegalHold")

        _request = build_clear_legal_hold_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LegalHold", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional[_models.ImmutabilityPolicy] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Default value is None.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container. Default value is None.
        :type parameters: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Default value is None.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container. Default value is None.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional[Union[_models.ImmutabilityPolicy, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Default value is None.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container. Is either a ImmutabilityPolicy type or a IO[bytes] type. Default value is None.
        :type parameters: ~azure.mgmt.storage.models.ImmutabilityPolicy or IO[bytes]
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if parameters else None
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if parameters else None
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "ImmutabilityPolicy")
            else:
                _json = None

        _request = build_create_or_update_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            immutability_policy_name=immutability_policy_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Gets the existing immutability policy along with the corresponding ETag in response headers and
        body.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Default value is None.
        :type if_match: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        _request = build_get_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            immutability_policy_name=immutability_policy_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_immutability_policy(
        self, resource_group_name: str, account_name: str, container_name: str, if_match: str, **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Aborts an unlocked immutability policy. The response of delete has
        immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required for this
        operation. Deleting a locked immutability policy is not allowed, the only way is to delete the
        container after deleting all expired blobs inside the policy locked container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Required.
        :type if_match: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        _request = build_delete_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            immutability_policy_name=immutability_policy_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def lock_immutability_policy(
        self, resource_group_name: str, account_name: str, container_name: str, if_match: str, **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Sets the ImmutabilityPolicy to Locked state. The only action allowed on a Locked policy is
        ExtendImmutabilityPolicy action. ETag in If-Match is required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Required.
        :type if_match: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        _request = build_lock_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional[_models.ImmutabilityPolicy] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Required.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container. Default value is None.
        :type parameters: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Required.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container. Default value is None.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional[Union[_models.ImmutabilityPolicy, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update must be
         returned to the server for all update operations. The ETag value must include the leading and
         trailing double quotes as returned by the service. Required.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container. Is either a ImmutabilityPolicy type or a IO[bytes] type. Default value is None.
        :type parameters: ~azure.mgmt.storage.models.ImmutabilityPolicy or IO[bytes]
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if parameters else None
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if parameters else None
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "ImmutabilityPolicy")
            else:
                _json = None

        _request = build_extend_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional[_models.LeaseContainerRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LeaseContainerResponse:
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param parameters: Lease Container request body. Default value is None.
        :type parameters: ~azure.mgmt.storage.models.LeaseContainerRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LeaseContainerResponse or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LeaseContainerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LeaseContainerResponse:
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param parameters: Lease Container request body. Default value is None.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LeaseContainerResponse or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LeaseContainerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional[Union[_models.LeaseContainerRequest, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.LeaseContainerResponse:
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param parameters: Lease Container request body. Is either a LeaseContainerRequest type or a
         IO[bytes] type. Default value is None.
        :type parameters: ~azure.mgmt.storage.models.LeaseContainerRequest or IO[bytes]
        :return: LeaseContainerResponse or the result of cls(response)
        :rtype: ~azure.mgmt.storage.models.LeaseContainerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if parameters else None
        cls: ClsType[_models.LeaseContainerResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if parameters else None
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "LeaseContainerRequest")
            else:
                _json = None

        _request = build_lease_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LeaseContainerResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _object_level_worm_initial(
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_object_level_worm_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_object_level_worm(
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """This operation migrates a blob container from container level WORM to object level immutability
        enabled container. Prerequisites require a container level immutability policy either in locked
        or unlocked state, Account level versioning must be enabled and there should be no Legal hold
        on the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._object_level_worm_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                container_name=container_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore
