# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.compute import ComputeManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-compute
# USAGE
    python gallery_script_version_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="{subscription-id}",
    )

    response = client.gallery_script_versions.begin_create_or_update(
        resource_group_name="myResourceGroup",
        gallery_name="myGalleryName",
        gallery_script_name="myGalleryScriptName",
        gallery_script_version_name="1.0.0",
        gallery_script_version={
            "location": "West US",
            "properties": {
                "publishingProfile": {
                    "endOfLifeDate": "2027-07-01T07:00:00Z",
                    "replicaCount": 2,
                    "source": {
                        "parameters": [
                            {"defaultValue": "westus", "name": "location", "required": True, "type": "String"},
                            {
                                "defaultValue": "default value of parameter",
                                "description": "description of the parameter",
                                "name": "myGalleryScriptParameter1",
                                "required": True,
                                "type": "String",
                            },
                            {
                                "defaultValue": "default value of parameter",
                                "description": "description of the parameter",
                                "name": "myGalleryScriptParameter2",
                                "required": False,
                                "type": "String",
                            },
                            {
                                "defaultValue": "3",
                                "description": "description of the parameter",
                                "maxValue": "5",
                                "minValue": "1",
                                "name": "numberOfUnits",
                                "required": True,
                                "type": "Int",
                            },
                            {
                                "defaultValue": "0.6",
                                "description": "description of the parameter",
                                "maxValue": "2",
                                "minValue": "0.1",
                                "name": "weightOfUnit",
                                "required": True,
                                "type": "Double",
                            },
                            {
                                "defaultValue": "Fruit",
                                "description": "description of the parameter",
                                "enumValues": ["Fruit", "Vegetable", "Greens", "Nuts"],
                                "name": "typeOfProduct",
                                "required": False,
                                "type": "Enum",
                            },
                        ],
                        "scriptLink": "https://mystorageaccount.blob.core.windows.net/mycontainer/myScript.ps1?{sasKey}",
                    },
                    "storageAccountType": "Standard_LRS",
                    "targetRegions": [
                        {
                            "excludeFromLatest": False,
                            "name": "West US",
                            "regionalReplicaCount": 2,
                            "storageAccountType": "Standard_LRS",
                        }
                    ],
                },
                "safetyProfile": {"allowDeletionOfReplicatedLocations": False},
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2025-03-03/examples/galleryScriptExamples/GalleryScriptVersion_Create.json
if __name__ == "__main__":
    main()
