--TEST--
numfmt creation failures
--EXTENSIONS--
intl
--FILE--
<?php

function err($fmt) {
    if(!$fmt) {
        echo var_export(intl_get_error_message(), true)."\n";
    }
}

function print_exception($e) {
    echo "\n", $e::class, ": ", $e->getMessage(), "\n";
}

function crt($t, $l, $s) {
    switch(true) {
        case $t == "O":
            try {
                return new NumberFormatter($l, $s);
            } catch (Throwable $e) {
                print_exception($e);
                return null;
            }
            break;
        case $t == "C":
            try {
                return NumberFormatter::create($l, $s);
            } catch (Throwable $e) {
                print_exception($e);
                return null;
            }
            break;
        case $t == "P":
            try {
                return numfmt_create($l, $s);
            } catch (Throwable $e) {
                print_exception($e);
                return null;
            }
            break;
    }
}

$args = array(
    array(null, null),
    array("whatever", 1234567),
    array(array(), array()),
    array("en", -1),
    array("en_US", NumberFormatter::PATTERN_RULEBASED),
);

try {
    $fmt = new NumberFormatter();
} catch (TypeError $e) {
    print_exception($e);
    $fmt = null;
}
err($fmt);
try {
    $fmt = numfmt_create();
} catch (Throwable $e) {
    print_exception($e);
    $fmt = null;
}
err($fmt);
try {
    $fmt = NumberFormatter::create();
} catch (Throwable $e) {
    print_exception($e);
    $fmt = null;
}
err($fmt);

$fmt = new NumberFormatter('en_US', NumberFormatter::DECIMAL);
try {
    $fmt->__construct('en_US', NumberFormatter::DECIMAL);
} catch (Throwable $e) {
    print_exception($e);
    $fmt = null;
}
err($fmt);

foreach($args as $arg) {
    $fmt = crt("O", $arg[0], $arg[1]);
    err($fmt);
    $fmt = crt("C", $arg[0], $arg[1]);
    err($fmt);
    $fmt = crt("P", $arg[0], $arg[1]);
    err($fmt);
}

?>
--EXPECTF--
ArgumentCountError: NumberFormatter::__construct() expects at least 2 arguments, 0 given
'U_ZERO_ERROR'

ArgumentCountError: numfmt_create() expects at least 2 arguments, 0 given
'U_ZERO_ERROR'

ArgumentCountError: NumberFormatter::create() expects at least 2 arguments, 0 given
'U_ZERO_ERROR'

Error: NumberFormatter object is already constructed
'U_ZERO_ERROR'

Deprecated: NumberFormatter::__construct(): Passing null to parameter #1 ($locale) of type string is deprecated in %s on line %d

Deprecated: NumberFormatter::__construct(): Passing null to parameter #2 ($style) of type int is deprecated in %s on line %d

Deprecated: NumberFormatter::create(): Passing null to parameter #1 ($locale) of type string is deprecated in %s on line %d

Deprecated: NumberFormatter::create(): Passing null to parameter #2 ($style) of type int is deprecated in %s on line %d

Deprecated: numfmt_create(): Passing null to parameter #1 ($locale) of type string is deprecated in %s on line %d

Deprecated: numfmt_create(): Passing null to parameter #2 ($style) of type int is deprecated in %s on line %d

ValueError: NumberFormatter::__construct(): Argument #1 ($locale) "whatever" is invalid
'U_ZERO_ERROR'

ValueError: NumberFormatter::create(): Argument #1 ($locale) "whatever" is invalid
'U_ZERO_ERROR'

ValueError: numfmt_create(): Argument #1 ($locale) "whatever" is invalid
'U_ZERO_ERROR'

TypeError: NumberFormatter::__construct(): Argument #1 ($locale) must be of type string, array given
'U_ZERO_ERROR'

TypeError: NumberFormatter::create(): Argument #1 ($locale) must be of type string, array given
'U_ZERO_ERROR'

TypeError: numfmt_create(): Argument #1 ($locale) must be of type string, array given
'U_ZERO_ERROR'

IntlException: NumberFormatter::__construct(): number formatter creation failed
'NumberFormatter::__construct(): number formatter creation failed: U_UNSUPPORTED_ERROR'
'NumberFormatter::create(): number formatter creation failed: U_UNSUPPORTED_ERROR'
'numfmt_create(): number formatter creation failed: U_UNSUPPORTED_ERROR'

IntlException: NumberFormatter::__construct(): number formatter creation failed
'NumberFormatter::__construct(): number formatter creation failed: U_MEMORY_ALLOCATION_ERROR'
'NumberFormatter::create(): number formatter creation failed: U_MEMORY_ALLOCATION_ERROR'
'numfmt_create(): number formatter creation failed: U_MEMORY_ALLOCATION_ERROR'
