/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpUtf8;
import java.io.DataOutput;
import java.io.IOException;

public final class CpNameAndType
extends CpEntry {
    CpUtf8 name;
    CpUtf8 type;

    CpNameAndType(ConstantPool cpool, int hash, CpUtf8 n, CpUtf8 t) {
        super(cpool, (byte)12, hash);
        this.name = n;
        this.type = t;
    }

    CpNameAndType(ConstantPool cpool) {
        super(cpool, (byte)12, 0);
    }

    public final CpUtf8 getName() {
        return this.name;
    }

    public final CpUtf8 getType() {
        return this.type;
    }

    static final int hashCode(CpUtf8 name, CpUtf8 type) {
        return name.hashCode() ^ type.hashCode();
    }

    public void computeHash() {
        if (this.name.hash == 0) {
            this.name.computeHash();
        }
        if (this.type.hash == 0) {
            this.type.computeHash();
        }
        this.hash = CpNameAndType.hashCode(this.name, this.type);
    }

    void write(DataOutput dstr) throws IOException {
        dstr.writeByte(12);
        dstr.writeShort(this.name.index);
        dstr.writeShort(this.type.index);
    }

    public String toString() {
        return "NameAndType: " + this.name.getIndex() + "," + this.type.getIndex();
    }

    void postClone() {
        super.postClone();
        this.name = (CpUtf8)this.pool.getPoolEntry(this.name.index);
        this.type = (CpUtf8)this.pool.getPoolEntry(this.type.index);
    }
}

