/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <stdio.h>
#include <termios.h>

/* POSIX echo handler  - Alan Cox 1993 */

static struct termios Old;
static short has_been_set=0;

void echo_on(void)
{
	if(has_been_set)
		tcsetattr(0,TCSANOW,&Old);
}

void echo_off(void)
{
	if(!has_been_set)
	{
		if(tcgetattr(0,&Old)!=-1)
			has_been_set=1;
	}
	if(has_been_set)
	{
		struct termios work;
		tcgetattr(0,&work);
		work.c_lflag&=~ICANON;
		work.c_lflag&=~ECHO;
		work.c_cc[VMIN]=1;
		work.c_cc[VTIME]=0;
		tcsetattr(0,TCSANOW,&work);
	}
}
