/* ClockView.h, a simple clock view 
 * Author: Ali T. Ozer, NeXT Developer Support Group
 * Created: May 26, 1989 (for version 0.9)
 * Modified: June 14 and Aug 14, 1989 (for version 1.0)
 * Redesigned for 2.0 by Julie Zelenski, NeXT Developer Support Group
 * Adapted by Mai Nguyen for this mini-example. Basically, only the digital
 * view of the clock is being used.
 *
 * Subclass of view to implement a simple clock. This view is pretty generic 
 * and can probably be added to any program. 
 * You may freely copy, distribute and reuse the code in this example.  
 * NeXT disclaims any warranty of any kind, expressed or implied, as to its 
 * fitness for any particular use.
 */


#import <appkit/View.h>
#import <dpsclient/dpsclient.h>  
#import <objc/typedstream.h> 

@interface ClockView:View
{
  DPSTimedEntry teNum;     	/* The clock timed entry */
  id cacheWindow;		/* Offscreen cache window for clock face */
  float radius; 	 	/* Radius of clock face */
  NXPoint center;		/* Center of clock face */
  BOOL showSeconds;          	/* Show seconds hand on clock */
  BOOL needRedraw;		/* boolean flag to indicate redraw is needed */
  id littleFont,mediumFont, bigFont;	/* fonts used */
  
}

/* INIT/FREE METHODS */
- initFrame:(const NXRect *)frameRect;
- free;


/* PRIVATE METHODS */
- drawFace;
- drawDigital:(struct tm *)time;
- drawSelf:(NXRect *)rects :(int)rectCount;

- startTimedEntry:(BOOL)fireASAP;
- stopTimedEntry;
- sizeTo:(NXCoord)w :(NXCoord)h;



@end
