/****************************************************************************
*                   gif.c
*
*  Gif-format file reader.
*
*  NOTE:  Portions of this module were written by Steve Bennett and are used
*         here with his permission.
*
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/

/*
   The following routines were borrowed freely from FRACTINT, and represent
   a generalized GIF file decoder.  This seems the best, most universal format
   for reading in Bitmapped images.  GIF is a Copyright of Compuserve, Inc.
   Swiped and converted to entirely "C" coded routines by AAC for the most
   in future portability!
*/

#include "frame.h"

static int Bitmap_Line;
static FILE *Bit_File;
unsigned char *decoderline  /*  [2049] */ ;  /* write-line routines use this */

IMAGE_COLOUR *gif_color_map;
int colourmap_size;
int screen_width, screen_height;
int image_width, image_height;
extern int got_second_image, first_image;
extern FILE *df;

void Read_Gif_Image(char *);
void display_plot (int, int, unsigned char );
void new_image();


int out_line (pixels, linelen)
   unsigned char *pixels;
   int linelen;
   {
   int x;
   unsigned char *line;


   for (x = 0; x < linelen; x++) {
          display_plot (x, Bitmap_Line, *pixels);
          pixels++;

      }

   Bitmap_Line++;
   return (0);
   }

#define READ_ERROR -1

int get_byte() /* get byte from file, return the next byte or an error */
   {
   register int byte;

   if ((byte = getc(Bit_File)) != EOF)
      return (byte);
   else {
      fprintf (stderr, "Premature End Of File reading GIF image\n");
      exit (1);
      }
   return (0);  /* Keep the compiler happy */
   }

/* Main GIF file decoder.  */

void Read_Gif_Image(filename)
   char *filename;
   {
   register int i, j, status;
   unsigned finished, planes;
   unsigned char buffer[16];
   int c;

   status = 0;

   if ((Bit_File = fopen(filename, READ_FILE_STRING)) == NULL) {
      fprintf (stderr, "Cannot open GIF file %s\n", filename);
      exit(1);
      }

   /* zero out the full write-line */
   if ((decoderline = (unsigned char *) malloc (2049)) == NULL) {
      fprintf (stderr, "Cannot allocate space for GIF decoder line\n");
      fclose (Bit_File);
      exit (1);
      }

   for (i = 0; i < 2049; i++)
      decoderline[i] = (unsigned char) 0;

   /* Get the screen description */
   for (i = 0; i < 13; i++)
      buffer[i] = (unsigned char)get_byte();

   if (strncmp((char *) buffer,"GIF",3) ||          /* use updated GIF specs */
       buffer[3] < '0' || buffer[3] > '9' ||
       buffer[4] < '0' || buffer[4] > '9' ||
       buffer[5] < 'A' || buffer[5] > 'z' ) {

      fprintf (stderr, "Invalid GIF file format: %s\n", filename);
      fclose(Bit_File);
      exit (1);
      }

   planes = ((unsigned)buffer[10] & 0x0F) + 1;
   colourmap_size = (int)(1 << planes);

   if ((gif_color_map = (IMAGE_COLOUR *)
         malloc (colourmap_size * sizeof (IMAGE_COLOUR))) == NULL) {
      fprintf (stderr, "Cannot allocate GIF Colour Map\n");
      fclose (Bit_File);
      exit (1);
      }

   if ((buffer[10] & 0x80) == 0) {    /* color map (better be!) */
      fprintf (stderr, "Invalid GIF file format: %s\n", filename);
      fclose(Bit_File);
      exit (1);
      }

   for (i = 0; i < colourmap_size ; i++) {
      gif_color_map[i].Red = (unsigned char)get_byte();
      gif_color_map[i].Green = (unsigned char)get_byte();
      gif_color_map[i].Blue = (unsigned char)get_byte();
      gif_color_map[i].Alpha = 0;
      }

      screen_width  = buffer[6] | (buffer[7] << 8);
      screen_height = buffer[8] | (buffer[9] << 8);

      if(first_image)
      {
        display_init(screen_width,screen_height);
        set_color_map(gif_color_map,colourmap_size);
        set_image_1();
      }

 /* Now display one or more GIF objects */
   finished = FALSE;
   while (!finished) {
      c = get_byte();
      switch (c) {
         case ';':                /* End of the GIF dataset */
            finished = TRUE;
            status = 0;
            break;

         case '!':                /* GIF Extension Block */
            get_byte();           /* read (and ignore) the ID */
            while ((i = get_byte()) > 0) /* get data len*/
            for (j = 0; j < i; j++)
                get_byte(); /* flush data */
            break;

         case ',': /* Start of image object. get description */
            new_image();
            for (i = 0; i < 9; i++) {
               if ((j = get_byte()) < 0) {	/* EOF test (?) */
                  status = -1;
                  break;
                  }
	       buffer[i] = (unsigned char) j;
               }

            if (status < 0) {
               finished = TRUE;
               break;
               }

            image_width  = buffer[4] | (buffer[5] << 8);
            image_height = buffer[6] | (buffer[7] << 8);

	    Bitmap_Line = 0;


            status = decoder ((short) image_width); /* decode image */
            if(first_image)
            {
                set_image_2();
                first_image = 0;
            }
            else
            {
                finished = TRUE;
                got_second_image = 1;
            }
            break;
         case 0:
            break;
         default:
            status = -1;
            finished = TRUE;
            break;
         }
      }

   free (decoderline);
   fclose(Bit_File);
   }
