/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: i_bonds.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/

#include <stddef.h>
#include <iostream.h>
#include "oopdb_setup.h"

#ifndef _COREBOND
#define _COREBOND

class Atom;
class Bond;

class IntrBond {
 protected:
  IntrBond();
  IntrBond(Atom *b, Atom *e);
  IntrBond(int, int);
  Atom * d_begin_atom_p;
  Atom * d_end_atom_p;
  Bond * d_next_p;
 public:
  Atom *d_begin_p(){return d_begin_atom_p;}
  Atom *d_end_p(){return d_end_atom_p;}
  Bond *next_bond(){return d_next_p;}
  Bond **next_bond_site(){return &d_next_p;}
  virtual int operator==(IntrBond*);
};

#endif

#ifdef _BOND

class CovalBond;
class HydroBond;
class SaltBridg;
class SSBond;

class IntrCovalBond : public Bond {
 protected:
  IntrCovalBond(){}
  IntrCovalBond(Atom *b, Atom *e) :Bond(b, e) {}
  IntrCovalBond(int i, int j) : Bond(i, j) {}

 public:
  int operator==(IntrBond*);
  CovalBond *next_coval_bond(){return (CovalBond*)next_bond();}
};

class IntrSSBond : public Bond {
 protected:
  IntrSSBond(){}
  IntrSSBond(Atom *b, Atom *e) :Bond(b, e) {}
  IntrSSBond(int i, int j) : Bond(i, j) {}

 public:
  SSBond *next_ss_bond(){return (SSBond*)next_bond();}
};



class IntrHydroBond : public Bond {
 protected:
  IntrHydroBond(){}
  IntrHydroBond(Atom *d, Atom *a) : Bond(d, a) {}
  IntrHydroBond(int i, int j) : Bond(i, j) {}

 public:
  Atom *d_donor_p(){return d_begin_atom_p;}
  Atom *d_acceptor_p() {return d_end_atom_p;}
  HydroBond *next_hydro_bond(){return (HydroBond*)next_bond();}
};


class IntrSaltBridg : public Bond {
 protected:
  IntrSaltBridg(){}
  IntrSaltBridg(Atom *n, Atom *p) : Bond(n, p) {};
  IntrSaltBridg(int i, int j) : Bond(i, j) {};

 public:
  Atom *d_native_p(){return d_begin_atom_p;}
  Atom *d_positive_p(){return d_end_atom_p;}
  SaltBridg *next_salt_bridg(){return (SaltBridg*)next_bond();}
};


#endif







