// $Header$
/*******************************************
	 Pdbfile.h

	 This is the abstrct interface of pdbfile
	 It will import from a PDB file into data structures in memory


	 $Log$

	 $author$


*****************************************************************************/
/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: i_pdbfile.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/


#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include "oopdb_setup.h"
#include "linebuffer.h"
#include "structure.h"


class IntrPdbFile {
 protected:
  IntrPdbFile();
  IntrPdbFile(char * filename);
  ~IntrPdbFile();
  char previous_res_name[5];
  char *d_name;
  char input_buf[83];
  char previous_insert_code;
  Compound * compound_p;
  FILE *d_fd;
  HetMonomer *current_het_r_p;
  int previous_res_no;
  LineBuffer * atom_buf_p;
  LineBuffer * d_buf_p;
  SubEntity *current_subentity_p;

  int get_line_info();
  void re_connect_subentitys();
  void put_in_buffer();
  void assign_all(Compound*);
  
/*
// followings functions are to process structure related infomation in PDB file
// it will built a tree as follows:
//
//                                 p1  --------------->secondary structure 1
//                                /  \              |->secondary structure 2
//                            chain1  chain2        |->secondary structure 3
//                           /  |   \        \      |->secondary structure 4
//                    subentity1  ...  subentity n      |->.....
//                    /   |   \           |   \
//		 atom 1  ....  atom n
*/

  int hetatm();
  int atom();              

  /* attach atoms to proper positions 
     and attach subentitys to proper chains.*/
  
  void build_subentitys();     /* build all primary structure*/
				   /* based on SEQRES information.*/
  void put_in_atom_buffer();
  void attach_atoms();

/*
//	secondary structures are ordered by their beginning subentity.
//	it has 3 possible elements: helix, strand, turn.
//
//	Using SecondaryStrucIter, we may have a view like this:
//	helix1 -> strand1 -> strand2 -> helix2 -> strand3 ->..-> turn1..
//
//      Notice: sheet are presented as a collection of strands, we don't
// 	offer primitives for users to look at sheet level
*/
  int helix(char * buf);
  int sheet(char * buf);
  int turn(char * buf);
  int ssbond(char*);

/*
// following functions are to process text information rows in PDB file
// and load each row as a node in link-list. Each protein will has pointers
// to each link-list.
*/
  int origx();
  int header();
  int obslte();
  int compnd();
  int source();
  int expdta();
  int author();
  int revdat();
  int sprsde();
  int jrnl();
  int remark();
  int conect();
  
 public:
  Compound* import();
};

/* Iterator for PDB: HEADER, AUTHOR, COMPND, SOURCE, JRNL, REMARK,etc..*/

class IntrPdbInfoIter {
 protected:
  IntrPdbInfoIter();
  IntrPdbInfoIter( LineBuffer * line_p);
  LineBuffer * d_buf_p;
 public:
  operator const void * () const;
  char * operator() () const;
  void operator++();
};












