/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: structure.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/


#ifndef _H_STRUCTURE
#define _H_STRUCTURE

#include "oopdb_setup.h"
#include "i_structure.h"

#ifdef _H_COREATOM
#define _H_ATOM

class Atom : public IntrAtom {
};

#endif

#include "i_structure.h"
#ifdef _H_CORESECONDARYSTRUC
#define _H_SECONDARYSTRUC

class SecondaryStruc : public IntrSecondaryStruc {
};

#endif

#include "i_structure.h"
#ifdef _H_COREHELIX
#define _H_HELIX

class Helix : public IntrHelix {
};

#endif

#ifdef _H_CORESTRAND
#define _H_STRAND

class Strand : public IntrStrand {
};

#endif

#ifdef _H_CORETURN
#define _H_TURN

class Turn : public IntrTurn {
};

#endif

#ifdef _H_CORECHAIN
#define _H_CHAIN

class Entity : public IntrEntity {
 public:
  Entity(){}
  Entity(const Entity* ep) : IntrEntity(ep){}
};

#endif

#ifdef _H_COREINFO
#define _H_PDBINFO

class PDB_Info : public IntrInfo {
};

#endif

#include "i_structure.h"

#ifdef _H_CORECOMPOUND
#define _H_COMPOUND

class Compound : public IntrCompound {

 public:
  Compound* self(){return this;}
};

#endif

#endif /* _H_STRUCTURE */















