
(* Yacc parser template (TP Yacc V3.0), V1.2 6-17-91 AG *)

(* global definitions: *)


 (* NFF parser for TKTrace 
    
    Created        : 15/04/93 modified from nff.y from the MTV raytracer
    Last Change    : 15/04/93
    
    Adapted from nff.y from the MTV raytracer by M. VandeWettering 
 *)

 var 
   CurrentSurface : PSurf;
   dummy : integer;
   dummyvec: vec;
   a,b,c,d,e,f,g,h,i,j : Flt;

 procedure yyerror(msg : string);
 begin
   writeln(infilename,': ',yylineno,': ',msg,' at or before ''',yytext,'''.');
   halt; { SHOULD BE RECONSIDERED }
 end;


const VIEWPOINT = 257;
const FROM = 258;
const AT = 259;
const UP = 260;
const ANGLE = 261;
const ASPECT = 262;
const RESOLUTION = 263;
const LIGHT = 264;
const BACKGROUND = 265;
const SURFACE = 266;
const SPHERE = 267;
const PLANE = 268;
const QUADRIC = 269;
const NUM = 270;
const TOKEN = 271;
const BEGIN_BLOCK = 272;
const END_BLOCK = 273;
const ILLEGAL = 274;

type YYSType = record case Integer of
                 1 : ( yyPPrim : PPrim );
                 2 : ( yyflt : flt );
                 3 : ( yyvec : vec );
               end(*YYSType*);

var yylval : YYSType;

function yylex : Integer; forward;

function yyparse : Integer;

var yystate, yysp, yyn : Integer;
    yys : array [1..yymaxdepth] of Integer;
    yyv : array [1..yymaxdepth] of YYSType;
    yyval : YYSType;

procedure yyaction ( yyruleno : Integer );
  (* local definitions: *)
begin
  (* actions: *)
  case yyruleno of
   1 : begin
         yyval := yyv[yysp-1];
       end;
   2 : begin
         yyval := yyv[yysp-1];
       end;
   3 : begin
       end;
   4 : begin
         yyval := yyv[yysp-0];
       end;
   5 : begin
         yyval := yyv[yysp-0];
       end;
   6 : begin
         yyval := yyv[yysp-0];
       end;
   7 : begin
         yyval := yyv[yysp-0];
       end;
   8 : begin
         yyval := yyv[yysp-0];
       end;
   9 : begin
         yyval := yyv[yysp-0];
       end;
  10 : begin
         yyval := yyv[yysp-3];
       end;
  11 : begin
         yyval := yyv[yysp-0];
       end;
  12 : begin
         yyval := yyv[yysp-1];
       end;
  13 : begin
         yyval := yyv[yysp-0];
       end;
  14 : begin
         yyval := yyv[yysp-0];
       end;
  15 : begin
         yyval := yyv[yysp-0];
       end;
  16 : begin
         yyval := yyv[yysp-0];
       end;
  17 : begin
         yyval := yyv[yysp-0];
       end;
  18 : begin
         yyval := yyv[yysp-0];
       end;
  19 : begin
         yyval := yyv[yysp-0];
       end;
  20 : begin
         
         VecCopy(yyv[yysp-0].yyvec,v_from);
         
       end;
  21 : begin
         
         VecCopy(yyv[yysp-0].yyvec,v_at);
         
       end;
  22 : begin
         
         VecCopy(yyv[yysp-0].yyvec,v_up);
         
       end;
  23 : begin
         
         v_angle := yyv[yysp-0].yyflt/360*pi;
         
       end;
  24 : begin
         
         v_aspect := yyv[yysp-0].yyflt;
         
       end;
  25 : begin
         
         If Image^.xres = 0 then
         begin
         Image^.xres := Round(yyv[yysp-1].yyflt); Image^.yres := Round(yyv[yysp-0].yyflt);
         end;
         Image^.FileOpen(OutFileName);
         
       end;
  26 : begin
         
         VecCopy(yyv[yysp-0].yyvec,backgroundcolor);
         
       end;
  27 : begin
         
         LightTree.Add(New(PPointLight,Init(yyv[yysp-2].yyvec,yyv[yysp-1].yyvec)));
         
       end;
  28 : begin
         
         		new(CurrentSurface);
         VecCopy(yyv[yysp-4].yyvec, CurrentSurface^.kdiff);
         VecCopy(yyv[yysp-3].yyvec, CurrentSurface^.kamb);
         VecCopy(yyv[yysp-2].yyvec, CurrentSurface^.kspec);
         CurrentSurface^.shine := yyv[yysp-1].yyflt;
         	
       end;
  29 : begin
         
         Tree.Add(New(PSphere, Init(yyv[yysp-2].yyvec, yyv[yysp-1].yyflt)),CurrentSurface);
         	
       end;
  30 : begin
         
         Tree.Add(New(PPlane, Init(yyv[yysp-2].yyvec, yyv[yysp-1].yyflt)), CurrentSurface);
         
       end;
  31 : begin
         
         a := yyv[yysp-10].yyflt; b := yyv[yysp-9].yyflt;  c := yyv[yysp-8].yyflt;
         d := yyv[yysp-7].yyflt; e := yyv[yysp-6].yyflt;  f := yyv[yysp-5].yyflt;
         g := yyv[yysp-4].yyflt; h := yyv[yysp-3].yyflt; i := yyv[yysp-2].yyflt; j := yyv[yysp-1].yyflt;
         
         Tree.Add(New(PQuadric, Init(a,b,c,d,e,f,g,h,i,j)), CurrentSurface);
         
       end;
  32 : begin
         
         		yyval.yyvec[0] := yyv[yysp-2].yyflt ;
         		yyval.yyvec[1] := yyv[yysp-1].yyflt ;
         		yyval.yyvec[2] := yyv[yysp-0].yyflt ;
         	
       end;
  33 : begin
         
         		yyval.yyvec[0] := yyv[yysp-2].yyflt ;
         		yyval.yyvec[1] := yyv[yysp-1].yyflt ;
         		yyval.yyvec[2] := yyv[yysp-0].yyflt ;
         	
       end;
  34 : begin
         
         yyval.yyflt := yyv[yysp-0].yyflt;
         
         
       end;
  end;
end(*yyaction*);

(* parse table: *)

type YYARec = record
                sym, act : Integer;
              end;
     YYRRec = record
                len, sym : Integer;
              end;

const

yynacts   = 67;
yyngotos  = 71;
yynstates = 81;
yynrules  = 34;

yya : array [1..yynacts] of YYARec = (
{ 0: }
  ( sym: 257; act: 3 ),
{ 1: }
{ 2: }
  ( sym: 0; act: 0 ),
{ 3: }
  ( sym: 272; act: 5 ),
{ 4: }
  ( sym: 264; act: 13 ),
  ( sym: 266; act: 14 ),
  ( sym: 267; act: 15 ),
  ( sym: 268; act: 16 ),
  ( sym: 269; act: 17 ),
  ( sym: 0; act: -1 ),
{ 5: }
  ( sym: 258; act: 27 ),
  ( sym: 259; act: 28 ),
  ( sym: 260; act: 29 ),
  ( sym: 261; act: 30 ),
  ( sym: 262; act: 31 ),
  ( sym: 263; act: 32 ),
  ( sym: 265; act: 33 ),
{ 6: }
{ 7: }
{ 8: }
{ 9: }
{ 10: }
{ 11: }
{ 12: }
{ 13: }
  ( sym: 272; act: 34 ),
{ 14: }
  ( sym: 272; act: 35 ),
{ 15: }
  ( sym: 272; act: 36 ),
{ 16: }
  ( sym: 272; act: 37 ),
{ 17: }
  ( sym: 272; act: 38 ),
{ 18: }
{ 19: }
{ 20: }
{ 21: }
{ 22: }
{ 23: }
{ 24: }
{ 25: }
  ( sym: 258; act: 27 ),
  ( sym: 259; act: 28 ),
  ( sym: 260; act: 29 ),
  ( sym: 261; act: 30 ),
  ( sym: 262; act: 31 ),
  ( sym: 263; act: 32 ),
  ( sym: 265; act: 33 ),
  ( sym: 273; act: -11 ),
{ 26: }
  ( sym: 273; act: 40 ),
{ 27: }
  ( sym: 270; act: 43 ),
{ 28: }
  ( sym: 270; act: 43 ),
{ 29: }
  ( sym: 270; act: 43 ),
{ 30: }
  ( sym: 270; act: 43 ),
{ 31: }
  ( sym: 270; act: 43 ),
{ 32: }
  ( sym: 270; act: 43 ),
{ 33: }
  ( sym: 270; act: 43 ),
{ 34: }
  ( sym: 270; act: 43 ),
{ 35: }
  ( sym: 270; act: 43 ),
{ 36: }
  ( sym: 270; act: 43 ),
{ 37: }
  ( sym: 270; act: 43 ),
{ 38: }
  ( sym: 270; act: 43 ),
{ 39: }
{ 40: }
{ 41: }
  ( sym: 270; act: 43 ),
{ 42: }
{ 43: }
{ 44: }
{ 45: }
{ 46: }
{ 47: }
{ 48: }
  ( sym: 270; act: 43 ),
{ 49: }
  ( sym: 270; act: 43 ),
{ 50: }
{ 51: }
  ( sym: 270; act: 43 ),
{ 52: }
  ( sym: 270; act: 43 ),
{ 53: }
  ( sym: 270; act: 43 ),
{ 54: }
  ( sym: 270; act: 43 ),
{ 55: }
  ( sym: 270; act: 43 ),
{ 56: }
  ( sym: 270; act: 43 ),
{ 57: }
{ 58: }
  ( sym: 270; act: 43 ),
{ 59: }
  ( sym: 273; act: 66 ),
{ 60: }
  ( sym: 270; act: 43 ),
{ 61: }
  ( sym: 273; act: 68 ),
{ 62: }
  ( sym: 273; act: 69 ),
{ 63: }
  ( sym: 270; act: 43 ),
{ 64: }
{ 65: }
{ 66: }
{ 67: }
  ( sym: 270; act: 43 ),
{ 68: }
{ 69: }
{ 70: }
  ( sym: 270; act: 43 ),
{ 71: }
  ( sym: 273; act: 73 ),
{ 72: }
  ( sym: 270; act: 43 ),
{ 73: }
{ 74: }
  ( sym: 270; act: 43 ),
{ 75: }
  ( sym: 270; act: 43 ),
{ 76: }
  ( sym: 270; act: 43 ),
{ 77: }
  ( sym: 270; act: 43 ),
{ 78: }
  ( sym: 270; act: 43 ),
{ 79: }
  ( sym: 273; act: 80 )
{ 80: }
);

yyg : array [1..yyngotos] of YYARec = (
{ 0: }
  ( sym: -10; act: 1 ),
  ( sym: -9; act: 2 ),
{ 1: }
  ( sym: -11; act: 4 ),
{ 2: }
{ 3: }
{ 4: }
  ( sym: -17; act: 6 ),
  ( sym: -16; act: 7 ),
  ( sym: -15; act: 8 ),
  ( sym: -14; act: 9 ),
  ( sym: -13; act: 10 ),
  ( sym: -12; act: 11 ),
  ( sym: -5; act: 12 ),
{ 5: }
  ( sym: -26; act: 18 ),
  ( sym: -25; act: 19 ),
  ( sym: -24; act: 20 ),
  ( sym: -23; act: 21 ),
  ( sym: -22; act: 22 ),
  ( sym: -21; act: 23 ),
  ( sym: -20; act: 24 ),
  ( sym: -19; act: 25 ),
  ( sym: -18; act: 26 ),
{ 6: }
{ 7: }
{ 8: }
{ 9: }
{ 10: }
{ 11: }
{ 12: }
{ 13: }
{ 14: }
{ 15: }
{ 16: }
{ 17: }
{ 18: }
{ 19: }
{ 20: }
{ 21: }
{ 22: }
{ 23: }
{ 24: }
{ 25: }
  ( sym: -26; act: 18 ),
  ( sym: -25; act: 19 ),
  ( sym: -24; act: 20 ),
  ( sym: -23; act: 21 ),
  ( sym: -22; act: 22 ),
  ( sym: -21; act: 23 ),
  ( sym: -20; act: 24 ),
  ( sym: -19; act: 25 ),
  ( sym: -18; act: 39 ),
{ 26: }
{ 27: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 42 ),
{ 28: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 44 ),
{ 29: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 45 ),
{ 30: }
  ( sym: -8; act: 46 ),
{ 31: }
  ( sym: -8; act: 47 ),
{ 32: }
  ( sym: -8; act: 48 ),
{ 33: }
  ( sym: -8; act: 49 ),
  ( sym: -3; act: 50 ),
{ 34: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 51 ),
{ 35: }
  ( sym: -8; act: 49 ),
  ( sym: -3; act: 52 ),
{ 36: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 53 ),
{ 37: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 54 ),
{ 38: }
  ( sym: -8; act: 55 ),
{ 39: }
{ 40: }
{ 41: }
  ( sym: -8; act: 56 ),
{ 42: }
{ 43: }
{ 44: }
{ 45: }
{ 46: }
{ 47: }
{ 48: }
  ( sym: -8; act: 57 ),
{ 49: }
  ( sym: -8; act: 58 ),
{ 50: }
{ 51: }
  ( sym: -8; act: 41 ),
  ( sym: -2; act: 59 ),
{ 52: }
  ( sym: -8; act: 49 ),
  ( sym: -3; act: 60 ),
{ 53: }
  ( sym: -8; act: 61 ),
{ 54: }
  ( sym: -8; act: 62 ),
{ 55: }
  ( sym: -8; act: 63 ),
{ 56: }
  ( sym: -8; act: 64 ),
{ 57: }
{ 58: }
  ( sym: -8; act: 65 ),
{ 59: }
{ 60: }
  ( sym: -8; act: 49 ),
  ( sym: -3; act: 67 ),
{ 61: }
{ 62: }
{ 63: }
  ( sym: -8; act: 70 ),
{ 64: }
{ 65: }
{ 66: }
{ 67: }
  ( sym: -8; act: 71 ),
{ 68: }
{ 69: }
{ 70: }
  ( sym: -8; act: 72 ),
{ 71: }
{ 72: }
  ( sym: -8; act: 74 ),
{ 73: }
{ 74: }
  ( sym: -8; act: 75 ),
{ 75: }
  ( sym: -8; act: 76 ),
{ 76: }
  ( sym: -8; act: 77 ),
{ 77: }
  ( sym: -8; act: 78 ),
{ 78: }
  ( sym: -8; act: 79 )
{ 79: }
{ 80: }
);

yyd : array [0..yynstates-1] of Integer = (
{ 0: } 0,
{ 1: } -3,
{ 2: } 0,
{ 3: } 0,
{ 4: } 0,
{ 5: } 0,
{ 6: } -9,
{ 7: } -8,
{ 8: } -6,
{ 9: } -5,
{ 10: } -4,
{ 11: } -2,
{ 12: } -7,
{ 13: } 0,
{ 14: } 0,
{ 15: } 0,
{ 16: } 0,
{ 17: } 0,
{ 18: } -19,
{ 19: } -18,
{ 20: } -17,
{ 21: } -16,
{ 22: } -15,
{ 23: } -14,
{ 24: } -13,
{ 25: } 0,
{ 26: } 0,
{ 27: } 0,
{ 28: } 0,
{ 29: } 0,
{ 30: } 0,
{ 31: } 0,
{ 32: } 0,
{ 33: } 0,
{ 34: } 0,
{ 35: } 0,
{ 36: } 0,
{ 37: } 0,
{ 38: } 0,
{ 39: } -12,
{ 40: } -10,
{ 41: } 0,
{ 42: } -20,
{ 43: } -34,
{ 44: } -21,
{ 45: } -22,
{ 46: } -23,
{ 47: } -24,
{ 48: } 0,
{ 49: } 0,
{ 50: } -26,
{ 51: } 0,
{ 52: } 0,
{ 53: } 0,
{ 54: } 0,
{ 55: } 0,
{ 56: } 0,
{ 57: } -25,
{ 58: } 0,
{ 59: } 0,
{ 60: } 0,
{ 61: } 0,
{ 62: } 0,
{ 63: } 0,
{ 64: } -33,
{ 65: } -32,
{ 66: } -27,
{ 67: } 0,
{ 68: } -29,
{ 69: } -30,
{ 70: } 0,
{ 71: } 0,
{ 72: } 0,
{ 73: } -28,
{ 74: } 0,
{ 75: } 0,
{ 76: } 0,
{ 77: } 0,
{ 78: } 0,
{ 79: } 0,
{ 80: } -31
);

yyal : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 2,
{ 2: } 2,
{ 3: } 3,
{ 4: } 4,
{ 5: } 10,
{ 6: } 17,
{ 7: } 17,
{ 8: } 17,
{ 9: } 17,
{ 10: } 17,
{ 11: } 17,
{ 12: } 17,
{ 13: } 17,
{ 14: } 18,
{ 15: } 19,
{ 16: } 20,
{ 17: } 21,
{ 18: } 22,
{ 19: } 22,
{ 20: } 22,
{ 21: } 22,
{ 22: } 22,
{ 23: } 22,
{ 24: } 22,
{ 25: } 22,
{ 26: } 30,
{ 27: } 31,
{ 28: } 32,
{ 29: } 33,
{ 30: } 34,
{ 31: } 35,
{ 32: } 36,
{ 33: } 37,
{ 34: } 38,
{ 35: } 39,
{ 36: } 40,
{ 37: } 41,
{ 38: } 42,
{ 39: } 43,
{ 40: } 43,
{ 41: } 43,
{ 42: } 44,
{ 43: } 44,
{ 44: } 44,
{ 45: } 44,
{ 46: } 44,
{ 47: } 44,
{ 48: } 44,
{ 49: } 45,
{ 50: } 46,
{ 51: } 46,
{ 52: } 47,
{ 53: } 48,
{ 54: } 49,
{ 55: } 50,
{ 56: } 51,
{ 57: } 52,
{ 58: } 52,
{ 59: } 53,
{ 60: } 54,
{ 61: } 55,
{ 62: } 56,
{ 63: } 57,
{ 64: } 58,
{ 65: } 58,
{ 66: } 58,
{ 67: } 58,
{ 68: } 59,
{ 69: } 59,
{ 70: } 59,
{ 71: } 60,
{ 72: } 61,
{ 73: } 62,
{ 74: } 62,
{ 75: } 63,
{ 76: } 64,
{ 77: } 65,
{ 78: } 66,
{ 79: } 67,
{ 80: } 68
);

yyah : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 2,
{ 3: } 3,
{ 4: } 9,
{ 5: } 16,
{ 6: } 16,
{ 7: } 16,
{ 8: } 16,
{ 9: } 16,
{ 10: } 16,
{ 11: } 16,
{ 12: } 16,
{ 13: } 17,
{ 14: } 18,
{ 15: } 19,
{ 16: } 20,
{ 17: } 21,
{ 18: } 21,
{ 19: } 21,
{ 20: } 21,
{ 21: } 21,
{ 22: } 21,
{ 23: } 21,
{ 24: } 21,
{ 25: } 29,
{ 26: } 30,
{ 27: } 31,
{ 28: } 32,
{ 29: } 33,
{ 30: } 34,
{ 31: } 35,
{ 32: } 36,
{ 33: } 37,
{ 34: } 38,
{ 35: } 39,
{ 36: } 40,
{ 37: } 41,
{ 38: } 42,
{ 39: } 42,
{ 40: } 42,
{ 41: } 43,
{ 42: } 43,
{ 43: } 43,
{ 44: } 43,
{ 45: } 43,
{ 46: } 43,
{ 47: } 43,
{ 48: } 44,
{ 49: } 45,
{ 50: } 45,
{ 51: } 46,
{ 52: } 47,
{ 53: } 48,
{ 54: } 49,
{ 55: } 50,
{ 56: } 51,
{ 57: } 51,
{ 58: } 52,
{ 59: } 53,
{ 60: } 54,
{ 61: } 55,
{ 62: } 56,
{ 63: } 57,
{ 64: } 57,
{ 65: } 57,
{ 66: } 57,
{ 67: } 58,
{ 68: } 58,
{ 69: } 58,
{ 70: } 59,
{ 71: } 60,
{ 72: } 61,
{ 73: } 61,
{ 74: } 62,
{ 75: } 63,
{ 76: } 64,
{ 77: } 65,
{ 78: } 66,
{ 79: } 67,
{ 80: } 67
);

yygl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 3,
{ 2: } 4,
{ 3: } 4,
{ 4: } 4,
{ 5: } 11,
{ 6: } 20,
{ 7: } 20,
{ 8: } 20,
{ 9: } 20,
{ 10: } 20,
{ 11: } 20,
{ 12: } 20,
{ 13: } 20,
{ 14: } 20,
{ 15: } 20,
{ 16: } 20,
{ 17: } 20,
{ 18: } 20,
{ 19: } 20,
{ 20: } 20,
{ 21: } 20,
{ 22: } 20,
{ 23: } 20,
{ 24: } 20,
{ 25: } 20,
{ 26: } 29,
{ 27: } 29,
{ 28: } 31,
{ 29: } 33,
{ 30: } 35,
{ 31: } 36,
{ 32: } 37,
{ 33: } 38,
{ 34: } 40,
{ 35: } 42,
{ 36: } 44,
{ 37: } 46,
{ 38: } 48,
{ 39: } 49,
{ 40: } 49,
{ 41: } 49,
{ 42: } 50,
{ 43: } 50,
{ 44: } 50,
{ 45: } 50,
{ 46: } 50,
{ 47: } 50,
{ 48: } 50,
{ 49: } 51,
{ 50: } 52,
{ 51: } 52,
{ 52: } 54,
{ 53: } 56,
{ 54: } 57,
{ 55: } 58,
{ 56: } 59,
{ 57: } 60,
{ 58: } 60,
{ 59: } 61,
{ 60: } 61,
{ 61: } 63,
{ 62: } 63,
{ 63: } 63,
{ 64: } 64,
{ 65: } 64,
{ 66: } 64,
{ 67: } 64,
{ 68: } 65,
{ 69: } 65,
{ 70: } 65,
{ 71: } 66,
{ 72: } 66,
{ 73: } 67,
{ 74: } 67,
{ 75: } 68,
{ 76: } 69,
{ 77: } 70,
{ 78: } 71,
{ 79: } 72,
{ 80: } 72
);

yygh : array [0..yynstates-1] of Integer = (
{ 0: } 2,
{ 1: } 3,
{ 2: } 3,
{ 3: } 3,
{ 4: } 10,
{ 5: } 19,
{ 6: } 19,
{ 7: } 19,
{ 8: } 19,
{ 9: } 19,
{ 10: } 19,
{ 11: } 19,
{ 12: } 19,
{ 13: } 19,
{ 14: } 19,
{ 15: } 19,
{ 16: } 19,
{ 17: } 19,
{ 18: } 19,
{ 19: } 19,
{ 20: } 19,
{ 21: } 19,
{ 22: } 19,
{ 23: } 19,
{ 24: } 19,
{ 25: } 28,
{ 26: } 28,
{ 27: } 30,
{ 28: } 32,
{ 29: } 34,
{ 30: } 35,
{ 31: } 36,
{ 32: } 37,
{ 33: } 39,
{ 34: } 41,
{ 35: } 43,
{ 36: } 45,
{ 37: } 47,
{ 38: } 48,
{ 39: } 48,
{ 40: } 48,
{ 41: } 49,
{ 42: } 49,
{ 43: } 49,
{ 44: } 49,
{ 45: } 49,
{ 46: } 49,
{ 47: } 49,
{ 48: } 50,
{ 49: } 51,
{ 50: } 51,
{ 51: } 53,
{ 52: } 55,
{ 53: } 56,
{ 54: } 57,
{ 55: } 58,
{ 56: } 59,
{ 57: } 59,
{ 58: } 60,
{ 59: } 60,
{ 60: } 62,
{ 61: } 62,
{ 62: } 62,
{ 63: } 63,
{ 64: } 63,
{ 65: } 63,
{ 66: } 63,
{ 67: } 64,
{ 68: } 64,
{ 69: } 64,
{ 70: } 65,
{ 71: } 65,
{ 72: } 66,
{ 73: } 66,
{ 74: } 67,
{ 75: } 68,
{ 76: } 69,
{ 77: } 70,
{ 78: } 71,
{ 79: } 71,
{ 80: } 71
);

yyr : array [1..yynrules] of YYRRec = (
{ 1: } ( len: 2; sym: -9 ),
{ 2: } ( len: 2; sym: -11 ),
{ 3: } ( len: 0; sym: -11 ),
{ 4: } ( len: 1; sym: -12 ),
{ 5: } ( len: 1; sym: -12 ),
{ 6: } ( len: 1; sym: -12 ),
{ 7: } ( len: 1; sym: -15 ),
{ 8: } ( len: 1; sym: -15 ),
{ 9: } ( len: 1; sym: -15 ),
{ 10: } ( len: 4; sym: -10 ),
{ 11: } ( len: 1; sym: -18 ),
{ 12: } ( len: 2; sym: -18 ),
{ 13: } ( len: 1; sym: -19 ),
{ 14: } ( len: 1; sym: -19 ),
{ 15: } ( len: 1; sym: -19 ),
{ 16: } ( len: 1; sym: -19 ),
{ 17: } ( len: 1; sym: -19 ),
{ 18: } ( len: 1; sym: -19 ),
{ 19: } ( len: 1; sym: -19 ),
{ 20: } ( len: 2; sym: -20 ),
{ 21: } ( len: 2; sym: -22 ),
{ 22: } ( len: 2; sym: -21 ),
{ 23: } ( len: 2; sym: -23 ),
{ 24: } ( len: 2; sym: -24 ),
{ 25: } ( len: 3; sym: -25 ),
{ 26: } ( len: 2; sym: -26 ),
{ 27: } ( len: 5; sym: -13 ),
{ 28: } ( len: 7; sym: -14 ),
{ 29: } ( len: 5; sym: -5 ),
{ 30: } ( len: 5; sym: -16 ),
{ 31: } ( len: 13; sym: -17 ),
{ 32: } ( len: 3; sym: -3 ),
{ 33: } ( len: 3; sym: -2 ),
{ 34: } ( len: 1; sym: -8 )
);


const _error = 256; (* error token *)

function yyact(state, sym : Integer; var act : Integer) : Boolean;
  (* search action table *)
  var k : Integer;
  begin
    k := yyal[state];
    while (k<=yyah[state]) and (yya[k].sym<>sym) do inc(k);
    if k>yyah[state] then
      yyact := false
    else
      begin
        act := yya[k].act;
        yyact := true;
      end;
  end(*yyact*);

function yygoto(state, sym : Integer; var nstate : Integer) : Boolean;
  (* search goto table *)
  var k : Integer;
  begin
    k := yygl[state];
    while (k<=yygh[state]) and (yyg[k].sym<>sym) do inc(k);
    if k>yygh[state] then
      yygoto := false
    else
      begin
        nstate := yyg[k].act;
        yygoto := true;
      end;
  end(*yygoto*);

label parse, next, error, errlab, shift, reduce, accept, abort;

begin(*yyparse*)

  (* initialize: *)

  yystate := 0; yychar := -1; yynerrs := 0; yyerrflag := 0; yysp := 0;

{$ifdef yydebug}
  yydebug := true;
{$else}
  yydebug := false;
{$endif}

parse:

  (* push state and value: *)

  inc(yysp);
  if yysp>yymaxdepth then
    begin
      yyerror('yyparse stack overflow');
      goto abort;
    end;
  yys[yysp] := yystate; yyv[yysp] := yyval;

next:

  if (yyd[yystate]=0) and (yychar=-1) then
    (* get next symbol *)
    begin
      yychar := yylex; if yychar<0 then yychar := 0;
    end;

  if yydebug then writeln('state ', yystate, ', char ', yychar);

  (* determine parse action: *)

  yyn := yyd[yystate];
  if yyn<>0 then goto reduce; (* simple state *)

  (* no default action; search parse table *)

  if not yyact(yystate, yychar, yyn) then goto error
  else if yyn>0 then                      goto shift
  else if yyn<0 then                      goto reduce
  else                                    goto accept;

error:

  (* error; start error recovery: *)

  if yyerrflag=0 then yyerror('syntax error');

errlab:

  if yyerrflag=0 then inc(yynerrs);     (* new error *)

  if yyerrflag<=2 then                  (* incomplete recovery; try again *)
    begin
      yyerrflag := 3;
      (* uncover a state with shift action on error token *)
      while (yysp>0) and not ( yyact(yys[yysp], _error, yyn) and
                               (yyn>0) ) do
        begin
          if yydebug then
            if yysp>1 then
              writeln('error recovery pops state ', yys[yysp], ', uncovers ',
                      yys[yysp-1])
            else
              writeln('error recovery fails ... abort');
          dec(yysp);
        end;
      if yysp=0 then goto abort; (* parser has fallen from stack; abort *)
      yystate := yyn;            (* simulate shift on error *)
      goto parse;
    end
  else                                  (* no shift yet; discard symbol *)
    begin
      if yydebug then writeln('error recovery discards char ', yychar);
      if yychar=0 then goto abort; (* end of input; abort *)
      yychar := -1; goto next;     (* clear lookahead char and try again *)
    end;

shift:

  (* go to new state, clear lookahead character: *)

  yystate := yyn; yychar := -1; yyval := yylval;
  if yyerrflag>0 then dec(yyerrflag);

  goto parse;

reduce:

  (* execute action, pop rule from stack, and go to next state: *)

  if yydebug then writeln('reduce ', -yyn);

  yyflag := yyfnone; yyaction(-yyn);
  dec(yysp, yyr[-yyn].len);
  if yygoto(yys[yysp], yyr[-yyn].sym, yyn) then yystate := yyn;

  (* handle action calls to yyaccept, yyabort and yyerror: *)

  case yyflag of
    yyfaccept : goto accept;
    yyfabort  : goto abort;
    yyferror  : goto errlab;
  end;

  goto parse;

accept:

  yyparse := 0; exit;

abort:

  yyparse := 1; exit;

end(*yyparse*);


{$I nfflex.pas}

function ReadSceneFile(Fname : PathStr) : boolean;

begin
  assign(yyinput, Fname);
  reset(yyinput);
  if IOResult<>0 then 
  begin
    yyerror('IO Error opening input file');
    halt(1);
  end;
  if yyparse = 1 then 
  begin
    yyerror('Error parsing inputfile');
    halt(1);
  end;
  writeln('Succesfully parsed input file ', FName);
  close(yyinput);
end;