
(* lexical analyzer template (TP Lex V3.0), V1.0 3-2-91 AG *)

(* global definitions: *)

 (* Lexical analyzer for the NFF scene description format. 
    Adapted from tokens.l as included in the MTV-raytracer by M. VandeWettering
 *)

  
 function yywrap : boolean;
 begin
   yywrap := true; (* main program closes files *)
 end;





function yylex : Integer;

procedure yyaction ( yyruleno : Integer );
  (* local definitions: *)
  var
    result : integer;

  (* white space and stuff *)

begin
  (* actions: *)
  case yyruleno of
  1:
       			;
  2:
     			;

  (* keywords with aliases *)

  3,
  4:
         		return(VIEWPOINT);

  5:
    			return(FROM) ;

  6:
  			return(AT);

  7:
  			return(UP);

  8:
     			return(ANGLE);

  9:
      			return(ASPECT);

  10:
          		return(RESOLUTION);

  11,
  12:
                        return(LIGHT);

  13,
  14:
          		return(BACKGROUND);

  15,
  16:
       			return(SURFACE);

  17,
  18:
      			return(SPHERE);

  19,
  20:
                        return(PLANE);

  21,
  22:
                        return(QUADRIC);

  23:
                        return(BEGIN_BLOCK);
  24:
                        return(END_BLOCK);

 (* numbers *)
  25:
                                    begin
                                    val(yytext,yylval.yyflt,result);
                                    if result=0 then
                                       return(NUM)
				    else
 				       return(NUM);
	                          end;
  
 (* tokens *)
  26:
             		return(TOKEN);

  27:
                        returnc(yytext[0]);

  end;
end(*yyaction*);

(* DFA table: *)

type YYTRec = record
                cc : set of Char;
                s  : Integer;
              end;

const

yynmarks   = 131;
yynmatches = 130;
yyntrans   = 208;
yynstates  = 98;

yyk : array [1..yynmarks] of Integer = (
  { 0: }
  { 1: }
  { 2: }
  1,
  { 3: }
  2,
  27,
  { 4: }
  3,
  26,
  27,
  { 5: }
  15,
  26,
  27,
  { 6: }
  26,
  27,
  { 7: }
  26,
  27,
  { 8: }
  26,
  27,
  { 9: }
  11,
  26,
  27,
  { 10: }
  13,
  26,
  27,
  { 11: }
  17,
  26,
  27,
  { 12: }
  19,
  26,
  27,
  { 13: }
  21,
  26,
  27,
  { 14: }
  23,
  27,
  { 15: }
  24,
  27,
  { 16: }
  27,
  { 17: }
  25,
  26,
  27,
  { 18: }
  26,
  27,
  { 19: }
  1,
  27,
  { 20: }
  27,
  { 21: }
  2,
  { 22: }
  { 23: }
  26,
  { 24: }
  26,
  { 25: }
  26,
  { 26: }
  6,
  26,
  { 27: }
  26,
  { 28: }
  26,
  { 29: }
  7,
  26,
  { 30: }
  26,
  { 31: }
  26,
  { 32: }
  26,
  { 33: }
  26,
  { 34: }
  26,
  { 35: }
  26,
  { 36: }
  26,
  { 37: }
  25,
  { 38: }
  25,
  26,
  { 39: }
  { 40: }
  26,
  { 41: }
  26,
  { 42: }
  26,
  { 43: }
  26,
  { 44: }
  26,
  { 45: }
  26,
  { 46: }
  26,
  { 47: }
  26,
  { 48: }
  26,
  { 49: }
  26,
  { 50: }
  26,
  { 51: }
  26,
  { 52: }
  { 53: }
  25,
  { 54: }
  { 55: }
  25,
  26,
  { 56: }
  26,
  { 57: }
  5,
  26,
  { 58: }
  26,
  { 59: }
  26,
  { 60: }
  26,
  { 61: }
  26,
  { 62: }
  26,
  { 63: }
  26,
  { 64: }
  26,
  { 65: }
  26,
  { 66: }
  26,
  { 67: }
  25,
  { 68: }
  26,
  { 69: }
  8,
  26,
  { 70: }
  26,
  { 71: }
  26,
  { 72: }
  12,
  26,
  { 73: }
  26,
  { 74: }
  26,
  { 75: }
  26,
  { 76: }
  20,
  26,
  { 77: }
  26,
  { 78: }
  26,
  { 79: }
  9,
  26,
  { 80: }
  26,
  { 81: }
  26,
  { 82: }
  26,
  { 83: }
  18,
  26,
  { 84: }
  26,
  { 85: }
  26,
  { 86: }
  26,
  { 87: }
  26,
  { 88: }
  16,
  26,
  { 89: }
  22,
  26,
  { 90: }
  26,
  { 91: }
  26,
  { 92: }
  26,
  { 93: }
  4,
  26,
  { 94: }
  26,
  { 95: }
  26,
  { 96: }
  10,
  26,
  { 97: }
  14,
  26
);

yym : array [1..yynmatches] of Integer = (
{ 0: }
{ 1: }
{ 2: }
  1,
{ 3: }
  27,
{ 4: }
  3,
  26,
  27,
{ 5: }
  15,
  26,
  27,
{ 6: }
  26,
  27,
{ 7: }
  26,
  27,
{ 8: }
  26,
  27,
{ 9: }
  11,
  26,
  27,
{ 10: }
  13,
  26,
  27,
{ 11: }
  17,
  26,
  27,
{ 12: }
  19,
  26,
  27,
{ 13: }
  21,
  26,
  27,
{ 14: }
  23,
  27,
{ 15: }
  24,
  27,
{ 16: }
  27,
{ 17: }
  25,
  26,
  27,
{ 18: }
  26,
  27,
{ 19: }
  1,
  27,
{ 20: }
  27,
{ 21: }
{ 22: }
  2,
{ 23: }
  26,
{ 24: }
  26,
{ 25: }
  26,
{ 26: }
  6,
  26,
{ 27: }
  26,
{ 28: }
  26,
{ 29: }
  7,
  26,
{ 30: }
  26,
{ 31: }
  26,
{ 32: }
  26,
{ 33: }
  26,
{ 34: }
  26,
{ 35: }
  26,
{ 36: }
  26,
{ 37: }
  25,
{ 38: }
  25,
  26,
{ 39: }
{ 40: }
  26,
{ 41: }
  26,
{ 42: }
  26,
{ 43: }
  26,
{ 44: }
  26,
{ 45: }
  26,
{ 46: }
  26,
{ 47: }
  26,
{ 48: }
  26,
{ 49: }
  26,
{ 50: }
  26,
{ 51: }
  26,
{ 52: }
{ 53: }
  25,
{ 54: }
{ 55: }
  25,
  26,
{ 56: }
  26,
{ 57: }
  5,
  26,
{ 58: }
  26,
{ 59: }
  26,
{ 60: }
  26,
{ 61: }
  26,
{ 62: }
  26,
{ 63: }
  26,
{ 64: }
  26,
{ 65: }
  26,
{ 66: }
  26,
{ 67: }
  25,
{ 68: }
  26,
{ 69: }
  8,
  26,
{ 70: }
  26,
{ 71: }
  26,
{ 72: }
  12,
  26,
{ 73: }
  26,
{ 74: }
  26,
{ 75: }
  26,
{ 76: }
  20,
  26,
{ 77: }
  26,
{ 78: }
  26,
{ 79: }
  9,
  26,
{ 80: }
  26,
{ 81: }
  26,
{ 82: }
  26,
{ 83: }
  18,
  26,
{ 84: }
  26,
{ 85: }
  26,
{ 86: }
  26,
{ 87: }
  26,
{ 88: }
  16,
  26,
{ 89: }
  22,
  26,
{ 90: }
  26,
{ 91: }
  26,
{ 92: }
  26,
{ 93: }
  4,
  26,
{ 94: }
  26,
{ 95: }
  26,
{ 96: }
  10,
  26,
{ 97: }
  14,
  26
);

yyt : array [1..yyntrans] of YYTrec = (
{ 0: }
  ( cc: [ #1..#8,#11..#31,'!','"','$'..',','.','/',
            ':'..'@','['..'^','`','|','~'..#255 ]; s: 20),
  ( cc: [ #9,' ' ]; s: 19),
  ( cc: [ #10 ]; s: 2),
  ( cc: [ '#' ]; s: 3),
  ( cc: [ '-' ]; s: 16),
  ( cc: [ '0'..'9' ]; s: 17),
  ( cc: [ 'A'..'Z','_','c'..'e','g'..'k','m'..'o','t',
            'w'..'z' ]; s: 18),
  ( cc: [ 'a' ]; s: 6),
  ( cc: [ 'b' ]; s: 10),
  ( cc: [ 'f' ]; s: 5),
  ( cc: [ 'l' ]; s: 9),
  ( cc: [ 'p' ]; s: 12),
  ( cc: [ 'q' ]; s: 13),
  ( cc: [ 'r' ]; s: 8),
  ( cc: [ 's' ]; s: 11),
  ( cc: [ 'u' ]; s: 7),
  ( cc: [ 'v' ]; s: 4),
  ( cc: [ '{' ]; s: 14),
  ( cc: [ '}' ]; s: 15),
{ 1: }
  ( cc: [ #1..#8,#11..#31,'!','"','$'..',','.','/',
            ':'..'@','['..'^','`','|','~'..#255 ]; s: 20),
  ( cc: [ #9,' ' ]; s: 19),
  ( cc: [ #10 ]; s: 2),
  ( cc: [ '#' ]; s: 3),
  ( cc: [ '-' ]; s: 16),
  ( cc: [ '0'..'9' ]; s: 17),
  ( cc: [ 'A'..'Z','_','c'..'e','g'..'k','m'..'o','t',
            'w'..'z' ]; s: 18),
  ( cc: [ 'a' ]; s: 6),
  ( cc: [ 'b' ]; s: 10),
  ( cc: [ 'f' ]; s: 5),
  ( cc: [ 'l' ]; s: 9),
  ( cc: [ 'p' ]; s: 12),
  ( cc: [ 'q' ]; s: 13),
  ( cc: [ 'r' ]; s: 8),
  ( cc: [ 's' ]; s: 11),
  ( cc: [ 'u' ]; s: 7),
  ( cc: [ 'v' ]; s: 4),
  ( cc: [ '{' ]; s: 14),
  ( cc: [ '}' ]; s: 15),
{ 2: }
{ 3: }
  ( cc: [ #1..#9,#11..#255 ]; s: 21),
  ( cc: [ #10 ]; s: 22),
{ 4: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'h','j'..'z' ]; s: 24),
  ( cc: [ 'i' ]; s: 23),
{ 5: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'q','s'..'z' ]; s: 24),
  ( cc: [ 'r' ]; s: 25),
{ 6: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'m','o'..'r','u'..'z' ]; s: 24),
  ( cc: [ 'n' ]; s: 27),
  ( cc: [ 's' ]; s: 28),
  ( cc: [ 't' ]; s: 26),
{ 7: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'o','q'..'z' ]; s: 24),
  ( cc: [ 'p' ]; s: 29),
{ 8: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 30),
{ 9: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'h','j'..'z' ]; s: 24),
  ( cc: [ 'i' ]; s: 31),
{ 10: }
  ( cc: [ '0'..'9','A'..'Z','_','b'..'z' ]; s: 24),
  ( cc: [ 'a' ]; s: 32),
{ 11: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'o','q'..'t','v'..'z' ]; s: 24),
  ( cc: [ 'p' ]; s: 34),
  ( cc: [ 'u' ]; s: 33),
{ 12: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'k','m'..'z' ]; s: 24),
  ( cc: [ 'l' ]; s: 35),
{ 13: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'t','v'..'z' ]; s: 24),
  ( cc: [ 'u' ]; s: 36),
{ 14: }
{ 15: }
{ 16: }
  ( cc: [ '0'..'9' ]; s: 37),
{ 17: }
  ( cc: [ '.' ]; s: 39),
  ( cc: [ '0'..'9' ]; s: 38),
  ( cc: [ 'A'..'D','F'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'E','e' ]; s: 40),
{ 18: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 19: }
{ 20: }
{ 21: }
  ( cc: [ #1..#9,#11..#255 ]; s: 21),
  ( cc: [ #10 ]; s: 22),
{ 22: }
{ 23: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 41),
{ 24: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 25: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'n','p'..'z' ]; s: 24),
  ( cc: [ 'o' ]; s: 42),
{ 26: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 27: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'f','h'..'z' ]; s: 24),
  ( cc: [ 'g' ]; s: 43),
{ 28: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'o','q'..'z' ]; s: 24),
  ( cc: [ 'p' ]; s: 44),
{ 29: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 30: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'r','t'..'z' ]; s: 24),
  ( cc: [ 's' ]; s: 45),
{ 31: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'f','h'..'z' ]; s: 24),
  ( cc: [ 'g' ]; s: 46),
{ 32: }
  ( cc: [ '0'..'9','A'..'Z','_','a','b','d'..'z' ]; s: 24),
  ( cc: [ 'c' ]; s: 47),
{ 33: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'q','s'..'z' ]; s: 24),
  ( cc: [ 'r' ]; s: 48),
{ 34: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'g','i'..'z' ]; s: 24),
  ( cc: [ 'h' ]; s: 49),
{ 35: }
  ( cc: [ '0'..'9','A'..'Z','_','b'..'z' ]; s: 24),
  ( cc: [ 'a' ]; s: 50),
{ 36: }
  ( cc: [ '0'..'9','A'..'Z','_','b'..'z' ]; s: 24),
  ( cc: [ 'a' ]; s: 51),
{ 37: }
  ( cc: [ '.' ]; s: 39),
  ( cc: [ '0'..'9' ]; s: 37),
  ( cc: [ 'E','e' ]; s: 52),
{ 38: }
  ( cc: [ '.' ]; s: 39),
  ( cc: [ '0'..'9' ]; s: 38),
  ( cc: [ 'A'..'D','F'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'E','e' ]; s: 40),
{ 39: }
  ( cc: [ '0'..'9' ]; s: 53),
{ 40: }
  ( cc: [ '+','-' ]; s: 54),
  ( cc: [ '0'..'9' ]; s: 55),
  ( cc: [ 'A'..'Z','_','a'..'z' ]; s: 24),
{ 41: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'v','x'..'z' ]; s: 24),
  ( cc: [ 'w' ]; s: 56),
{ 42: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'l','n'..'z' ]; s: 24),
  ( cc: [ 'm' ]; s: 57),
{ 43: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'k','m'..'z' ]; s: 24),
  ( cc: [ 'l' ]; s: 58),
{ 44: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 59),
{ 45: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'n','p'..'z' ]; s: 24),
  ( cc: [ 'o' ]; s: 60),
{ 46: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'g','i'..'z' ]; s: 24),
  ( cc: [ 'h' ]; s: 61),
{ 47: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'j','l'..'z' ]; s: 24),
  ( cc: [ 'k' ]; s: 62),
{ 48: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'e','g'..'z' ]; s: 24),
  ( cc: [ 'f' ]; s: 63),
{ 49: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 64),
{ 50: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'m','o'..'z' ]; s: 24),
  ( cc: [ 'n' ]; s: 65),
{ 51: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'c','e'..'z' ]; s: 24),
  ( cc: [ 'd' ]; s: 66),
{ 52: }
  ( cc: [ '+','-' ]; s: 54),
  ( cc: [ '0'..'9' ]; s: 67),
{ 53: }
  ( cc: [ '0'..'9' ]; s: 53),
  ( cc: [ 'E','e' ]; s: 52),
{ 54: }
  ( cc: [ '0'..'9' ]; s: 67),
{ 55: }
  ( cc: [ '0'..'9' ]; s: 55),
  ( cc: [ 'A'..'Z','_','a'..'z' ]; s: 24),
{ 56: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'o','q'..'z' ]; s: 24),
  ( cc: [ 'p' ]; s: 68),
{ 57: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 58: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 69),
{ 59: }
  ( cc: [ '0'..'9','A'..'Z','_','a','b','d'..'z' ]; s: 24),
  ( cc: [ 'c' ]; s: 70),
{ 60: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'k','m'..'z' ]; s: 24),
  ( cc: [ 'l' ]; s: 71),
{ 61: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'s','u'..'z' ]; s: 24),
  ( cc: [ 't' ]; s: 72),
{ 62: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'f','h'..'z' ]; s: 24),
  ( cc: [ 'g' ]; s: 73),
{ 63: }
  ( cc: [ '0'..'9','A'..'Z','_','b'..'z' ]; s: 24),
  ( cc: [ 'a' ]; s: 74),
{ 64: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'q','s'..'z' ]; s: 24),
  ( cc: [ 'r' ]; s: 75),
{ 65: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 76),
{ 66: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'q','s'..'z' ]; s: 24),
  ( cc: [ 'r' ]; s: 77),
{ 67: }
  ( cc: [ '0'..'9' ]; s: 67),
{ 68: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'n','p'..'z' ]; s: 24),
  ( cc: [ 'o' ]; s: 78),
{ 69: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 70: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'s','u'..'z' ]; s: 24),
  ( cc: [ 't' ]; s: 79),
{ 71: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'t','v'..'z' ]; s: 24),
  ( cc: [ 'u' ]; s: 80),
{ 72: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 73: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'q','s'..'z' ]; s: 24),
  ( cc: [ 'r' ]; s: 81),
{ 74: }
  ( cc: [ '0'..'9','A'..'Z','_','a','b','d'..'z' ]; s: 24),
  ( cc: [ 'c' ]; s: 82),
{ 75: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 83),
{ 76: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 77: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'h','j'..'z' ]; s: 24),
  ( cc: [ 'i' ]; s: 84),
{ 78: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'h','j'..'z' ]; s: 24),
  ( cc: [ 'i' ]; s: 85),
{ 79: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 80: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'s','u'..'z' ]; s: 24),
  ( cc: [ 't' ]; s: 86),
{ 81: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'n','p'..'z' ]; s: 24),
  ( cc: [ 'o' ]; s: 87),
{ 82: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'d','f'..'z' ]; s: 24),
  ( cc: [ 'e' ]; s: 88),
{ 83: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 84: }
  ( cc: [ '0'..'9','A'..'Z','_','a','b','d'..'z' ]; s: 24),
  ( cc: [ 'c' ]; s: 89),
{ 85: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'m','o'..'z' ]; s: 24),
  ( cc: [ 'n' ]; s: 90),
{ 86: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'h','j'..'z' ]; s: 24),
  ( cc: [ 'i' ]; s: 91),
{ 87: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'t','v'..'z' ]; s: 24),
  ( cc: [ 'u' ]; s: 92),
{ 88: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 89: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 90: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'s','u'..'z' ]; s: 24),
  ( cc: [ 't' ]; s: 93),
{ 91: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'n','p'..'z' ]; s: 24),
  ( cc: [ 'o' ]; s: 94),
{ 92: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'m','o'..'z' ]; s: 24),
  ( cc: [ 'n' ]; s: 95),
{ 93: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 94: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'m','o'..'z' ]; s: 24),
  ( cc: [ 'n' ]; s: 96),
{ 95: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'c','e'..'z' ]; s: 24),
  ( cc: [ 'd' ]; s: 97),
{ 96: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24),
{ 97: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 24)
);

yykl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 1,
{ 3: } 2,
{ 4: } 4,
{ 5: } 7,
{ 6: } 10,
{ 7: } 12,
{ 8: } 14,
{ 9: } 16,
{ 10: } 19,
{ 11: } 22,
{ 12: } 25,
{ 13: } 28,
{ 14: } 31,
{ 15: } 33,
{ 16: } 35,
{ 17: } 36,
{ 18: } 39,
{ 19: } 41,
{ 20: } 43,
{ 21: } 44,
{ 22: } 45,
{ 23: } 45,
{ 24: } 46,
{ 25: } 47,
{ 26: } 48,
{ 27: } 50,
{ 28: } 51,
{ 29: } 52,
{ 30: } 54,
{ 31: } 55,
{ 32: } 56,
{ 33: } 57,
{ 34: } 58,
{ 35: } 59,
{ 36: } 60,
{ 37: } 61,
{ 38: } 62,
{ 39: } 64,
{ 40: } 64,
{ 41: } 65,
{ 42: } 66,
{ 43: } 67,
{ 44: } 68,
{ 45: } 69,
{ 46: } 70,
{ 47: } 71,
{ 48: } 72,
{ 49: } 73,
{ 50: } 74,
{ 51: } 75,
{ 52: } 76,
{ 53: } 76,
{ 54: } 77,
{ 55: } 77,
{ 56: } 79,
{ 57: } 80,
{ 58: } 82,
{ 59: } 83,
{ 60: } 84,
{ 61: } 85,
{ 62: } 86,
{ 63: } 87,
{ 64: } 88,
{ 65: } 89,
{ 66: } 90,
{ 67: } 91,
{ 68: } 92,
{ 69: } 93,
{ 70: } 95,
{ 71: } 96,
{ 72: } 97,
{ 73: } 99,
{ 74: } 100,
{ 75: } 101,
{ 76: } 102,
{ 77: } 104,
{ 78: } 105,
{ 79: } 106,
{ 80: } 108,
{ 81: } 109,
{ 82: } 110,
{ 83: } 111,
{ 84: } 113,
{ 85: } 114,
{ 86: } 115,
{ 87: } 116,
{ 88: } 117,
{ 89: } 119,
{ 90: } 121,
{ 91: } 122,
{ 92: } 123,
{ 93: } 124,
{ 94: } 126,
{ 95: } 127,
{ 96: } 128,
{ 97: } 130
);

yykh : array [0..yynstates-1] of Integer = (
{ 0: } 0,
{ 1: } 0,
{ 2: } 1,
{ 3: } 3,
{ 4: } 6,
{ 5: } 9,
{ 6: } 11,
{ 7: } 13,
{ 8: } 15,
{ 9: } 18,
{ 10: } 21,
{ 11: } 24,
{ 12: } 27,
{ 13: } 30,
{ 14: } 32,
{ 15: } 34,
{ 16: } 35,
{ 17: } 38,
{ 18: } 40,
{ 19: } 42,
{ 20: } 43,
{ 21: } 44,
{ 22: } 44,
{ 23: } 45,
{ 24: } 46,
{ 25: } 47,
{ 26: } 49,
{ 27: } 50,
{ 28: } 51,
{ 29: } 53,
{ 30: } 54,
{ 31: } 55,
{ 32: } 56,
{ 33: } 57,
{ 34: } 58,
{ 35: } 59,
{ 36: } 60,
{ 37: } 61,
{ 38: } 63,
{ 39: } 63,
{ 40: } 64,
{ 41: } 65,
{ 42: } 66,
{ 43: } 67,
{ 44: } 68,
{ 45: } 69,
{ 46: } 70,
{ 47: } 71,
{ 48: } 72,
{ 49: } 73,
{ 50: } 74,
{ 51: } 75,
{ 52: } 75,
{ 53: } 76,
{ 54: } 76,
{ 55: } 78,
{ 56: } 79,
{ 57: } 81,
{ 58: } 82,
{ 59: } 83,
{ 60: } 84,
{ 61: } 85,
{ 62: } 86,
{ 63: } 87,
{ 64: } 88,
{ 65: } 89,
{ 66: } 90,
{ 67: } 91,
{ 68: } 92,
{ 69: } 94,
{ 70: } 95,
{ 71: } 96,
{ 72: } 98,
{ 73: } 99,
{ 74: } 100,
{ 75: } 101,
{ 76: } 103,
{ 77: } 104,
{ 78: } 105,
{ 79: } 107,
{ 80: } 108,
{ 81: } 109,
{ 82: } 110,
{ 83: } 112,
{ 84: } 113,
{ 85: } 114,
{ 86: } 115,
{ 87: } 116,
{ 88: } 118,
{ 89: } 120,
{ 90: } 121,
{ 91: } 122,
{ 92: } 123,
{ 93: } 125,
{ 94: } 126,
{ 95: } 127,
{ 96: } 129,
{ 97: } 131
);

yyml : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 1,
{ 3: } 2,
{ 4: } 3,
{ 5: } 6,
{ 6: } 9,
{ 7: } 11,
{ 8: } 13,
{ 9: } 15,
{ 10: } 18,
{ 11: } 21,
{ 12: } 24,
{ 13: } 27,
{ 14: } 30,
{ 15: } 32,
{ 16: } 34,
{ 17: } 35,
{ 18: } 38,
{ 19: } 40,
{ 20: } 42,
{ 21: } 43,
{ 22: } 43,
{ 23: } 44,
{ 24: } 45,
{ 25: } 46,
{ 26: } 47,
{ 27: } 49,
{ 28: } 50,
{ 29: } 51,
{ 30: } 53,
{ 31: } 54,
{ 32: } 55,
{ 33: } 56,
{ 34: } 57,
{ 35: } 58,
{ 36: } 59,
{ 37: } 60,
{ 38: } 61,
{ 39: } 63,
{ 40: } 63,
{ 41: } 64,
{ 42: } 65,
{ 43: } 66,
{ 44: } 67,
{ 45: } 68,
{ 46: } 69,
{ 47: } 70,
{ 48: } 71,
{ 49: } 72,
{ 50: } 73,
{ 51: } 74,
{ 52: } 75,
{ 53: } 75,
{ 54: } 76,
{ 55: } 76,
{ 56: } 78,
{ 57: } 79,
{ 58: } 81,
{ 59: } 82,
{ 60: } 83,
{ 61: } 84,
{ 62: } 85,
{ 63: } 86,
{ 64: } 87,
{ 65: } 88,
{ 66: } 89,
{ 67: } 90,
{ 68: } 91,
{ 69: } 92,
{ 70: } 94,
{ 71: } 95,
{ 72: } 96,
{ 73: } 98,
{ 74: } 99,
{ 75: } 100,
{ 76: } 101,
{ 77: } 103,
{ 78: } 104,
{ 79: } 105,
{ 80: } 107,
{ 81: } 108,
{ 82: } 109,
{ 83: } 110,
{ 84: } 112,
{ 85: } 113,
{ 86: } 114,
{ 87: } 115,
{ 88: } 116,
{ 89: } 118,
{ 90: } 120,
{ 91: } 121,
{ 92: } 122,
{ 93: } 123,
{ 94: } 125,
{ 95: } 126,
{ 96: } 127,
{ 97: } 129
);

yymh : array [0..yynstates-1] of Integer = (
{ 0: } 0,
{ 1: } 0,
{ 2: } 1,
{ 3: } 2,
{ 4: } 5,
{ 5: } 8,
{ 6: } 10,
{ 7: } 12,
{ 8: } 14,
{ 9: } 17,
{ 10: } 20,
{ 11: } 23,
{ 12: } 26,
{ 13: } 29,
{ 14: } 31,
{ 15: } 33,
{ 16: } 34,
{ 17: } 37,
{ 18: } 39,
{ 19: } 41,
{ 20: } 42,
{ 21: } 42,
{ 22: } 43,
{ 23: } 44,
{ 24: } 45,
{ 25: } 46,
{ 26: } 48,
{ 27: } 49,
{ 28: } 50,
{ 29: } 52,
{ 30: } 53,
{ 31: } 54,
{ 32: } 55,
{ 33: } 56,
{ 34: } 57,
{ 35: } 58,
{ 36: } 59,
{ 37: } 60,
{ 38: } 62,
{ 39: } 62,
{ 40: } 63,
{ 41: } 64,
{ 42: } 65,
{ 43: } 66,
{ 44: } 67,
{ 45: } 68,
{ 46: } 69,
{ 47: } 70,
{ 48: } 71,
{ 49: } 72,
{ 50: } 73,
{ 51: } 74,
{ 52: } 74,
{ 53: } 75,
{ 54: } 75,
{ 55: } 77,
{ 56: } 78,
{ 57: } 80,
{ 58: } 81,
{ 59: } 82,
{ 60: } 83,
{ 61: } 84,
{ 62: } 85,
{ 63: } 86,
{ 64: } 87,
{ 65: } 88,
{ 66: } 89,
{ 67: } 90,
{ 68: } 91,
{ 69: } 93,
{ 70: } 94,
{ 71: } 95,
{ 72: } 97,
{ 73: } 98,
{ 74: } 99,
{ 75: } 100,
{ 76: } 102,
{ 77: } 103,
{ 78: } 104,
{ 79: } 106,
{ 80: } 107,
{ 81: } 108,
{ 82: } 109,
{ 83: } 111,
{ 84: } 112,
{ 85: } 113,
{ 86: } 114,
{ 87: } 115,
{ 88: } 117,
{ 89: } 119,
{ 90: } 120,
{ 91: } 121,
{ 92: } 122,
{ 93: } 124,
{ 94: } 125,
{ 95: } 126,
{ 96: } 128,
{ 97: } 130
);

yytl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 20,
{ 2: } 39,
{ 3: } 39,
{ 4: } 41,
{ 5: } 43,
{ 6: } 45,
{ 7: } 49,
{ 8: } 51,
{ 9: } 53,
{ 10: } 55,
{ 11: } 57,
{ 12: } 60,
{ 13: } 62,
{ 14: } 64,
{ 15: } 64,
{ 16: } 64,
{ 17: } 65,
{ 18: } 69,
{ 19: } 70,
{ 20: } 70,
{ 21: } 70,
{ 22: } 72,
{ 23: } 72,
{ 24: } 74,
{ 25: } 75,
{ 26: } 77,
{ 27: } 78,
{ 28: } 80,
{ 29: } 82,
{ 30: } 83,
{ 31: } 85,
{ 32: } 87,
{ 33: } 89,
{ 34: } 91,
{ 35: } 93,
{ 36: } 95,
{ 37: } 97,
{ 38: } 100,
{ 39: } 104,
{ 40: } 105,
{ 41: } 108,
{ 42: } 110,
{ 43: } 112,
{ 44: } 114,
{ 45: } 116,
{ 46: } 118,
{ 47: } 120,
{ 48: } 122,
{ 49: } 124,
{ 50: } 126,
{ 51: } 128,
{ 52: } 130,
{ 53: } 132,
{ 54: } 134,
{ 55: } 135,
{ 56: } 137,
{ 57: } 139,
{ 58: } 140,
{ 59: } 142,
{ 60: } 144,
{ 61: } 146,
{ 62: } 148,
{ 63: } 150,
{ 64: } 152,
{ 65: } 154,
{ 66: } 156,
{ 67: } 158,
{ 68: } 159,
{ 69: } 161,
{ 70: } 162,
{ 71: } 164,
{ 72: } 166,
{ 73: } 167,
{ 74: } 169,
{ 75: } 171,
{ 76: } 173,
{ 77: } 174,
{ 78: } 176,
{ 79: } 178,
{ 80: } 179,
{ 81: } 181,
{ 82: } 183,
{ 83: } 185,
{ 84: } 186,
{ 85: } 188,
{ 86: } 190,
{ 87: } 192,
{ 88: } 194,
{ 89: } 195,
{ 90: } 196,
{ 91: } 198,
{ 92: } 200,
{ 93: } 202,
{ 94: } 203,
{ 95: } 205,
{ 96: } 207,
{ 97: } 208
);

yyth : array [0..yynstates-1] of Integer = (
{ 0: } 19,
{ 1: } 38,
{ 2: } 38,
{ 3: } 40,
{ 4: } 42,
{ 5: } 44,
{ 6: } 48,
{ 7: } 50,
{ 8: } 52,
{ 9: } 54,
{ 10: } 56,
{ 11: } 59,
{ 12: } 61,
{ 13: } 63,
{ 14: } 63,
{ 15: } 63,
{ 16: } 64,
{ 17: } 68,
{ 18: } 69,
{ 19: } 69,
{ 20: } 69,
{ 21: } 71,
{ 22: } 71,
{ 23: } 73,
{ 24: } 74,
{ 25: } 76,
{ 26: } 77,
{ 27: } 79,
{ 28: } 81,
{ 29: } 82,
{ 30: } 84,
{ 31: } 86,
{ 32: } 88,
{ 33: } 90,
{ 34: } 92,
{ 35: } 94,
{ 36: } 96,
{ 37: } 99,
{ 38: } 103,
{ 39: } 104,
{ 40: } 107,
{ 41: } 109,
{ 42: } 111,
{ 43: } 113,
{ 44: } 115,
{ 45: } 117,
{ 46: } 119,
{ 47: } 121,
{ 48: } 123,
{ 49: } 125,
{ 50: } 127,
{ 51: } 129,
{ 52: } 131,
{ 53: } 133,
{ 54: } 134,
{ 55: } 136,
{ 56: } 138,
{ 57: } 139,
{ 58: } 141,
{ 59: } 143,
{ 60: } 145,
{ 61: } 147,
{ 62: } 149,
{ 63: } 151,
{ 64: } 153,
{ 65: } 155,
{ 66: } 157,
{ 67: } 158,
{ 68: } 160,
{ 69: } 161,
{ 70: } 163,
{ 71: } 165,
{ 72: } 166,
{ 73: } 168,
{ 74: } 170,
{ 75: } 172,
{ 76: } 173,
{ 77: } 175,
{ 78: } 177,
{ 79: } 178,
{ 80: } 180,
{ 81: } 182,
{ 82: } 184,
{ 83: } 185,
{ 84: } 187,
{ 85: } 189,
{ 86: } 191,
{ 87: } 193,
{ 88: } 194,
{ 89: } 195,
{ 90: } 197,
{ 91: } 199,
{ 92: } 201,
{ 93: } 202,
{ 94: } 204,
{ 95: } 206,
{ 96: } 207,
{ 97: } 208
);


var yyn : Integer;

label start, scan, action;

begin

start:

  (* initialize: *)

  yynew;

scan:

  (* mark positions and matches: *)

  for yyn := yykl[yystate] to     yykh[yystate] do yymark(yyk[yyn]);
  for yyn := yymh[yystate] downto yyml[yystate] do yymatch(yym[yyn]);

  if yytl[yystate]>yyth[yystate] then goto action; (* dead state *)

  (* get next character: *)

  yyscan;

  (* determine action: *)

  yyn := yytl[yystate];
  while (yyn<=yyth[yystate]) and not (yyactchar in yyt[yyn].cc) do inc(yyn);
  if yyn>yyth[yystate] then goto action;
    (* no transition on yyactchar in this state *)

  (* switch to new state: *)

  yystate := yyt[yyn].s;

  goto scan;

action:

  (* execute action: *)

  if yyfind(yyrule) then
    begin
      yyaction(yyrule);
      if yyreject then goto action;
    end
  else if not yydefault and yywrap then
    begin
      yyclear;
      return(0);
    end;

  if not yydone then goto start;

  yylex := yyretval;

end(*yylex*);



