unit startup;

{$I init.inc}

{*Unit Startup************************************************************

  Startup and Cleanup procedures

  Author      : Tom Kooij
  Created     : 21/04/93
  Last Change : 22/04/93

 *************************************************************************}

interface

uses
  globals,raytree, lights;

Procedure Initialize;
Procedure Cleanup;

implementation

var
  ExitSave : Pointer;

procedure Initialize;
begin
  New(Image,Init(0,0));
  Tree.Init;
  LightTree.Init;
  writeln('TKTrace raytracer ',versionstr,'. Copyright (C) 1993, Tom Kooij');
  writeln('TKTrace comes with ABSOLUTLY NO WARRANTY, use at your own risk.');
  writeln('TKTrace is free software, and you are welcome to redistribute it');
  writeln('under certain conditions. Please see "license.doc" for details.');
  writeln;
end;

procedure Cleanup;
begin
  LightTree.Done;
  Tree.Done;
  Dispose(Image,Done);
end;

procedure CleanExit; far;
begin
  ExitProc := ExitSave;
  If ErrorAddr<>nil then
  begin
    Writeln('Warning! A Fatal Error Occured!');
    Writeln;
    Writeln('Error code:   ',ExitCode);
    Writeln('Error adress: ',Seg(ErrorAddr),':',Ofs(ErrorAddr));
    Writeln;
    Writeln('Please inform the author!');
    Writeln;
  end;
  ErrorAddr := Nil; { No runtime error msg }
end;

begin
  {$IFDEF NoRuntimeError}
    ExitSave := ExitProc;
    ExitProc := @CleanExit;
  {$ENDIF}
end.

