NAME
	getami - display an RLE image on a Commodore Amiga and optionally
		 save it as an IFF ILBM file.

SYNOPSIS
	getami [-w width] [-h height] [-o IFFfile] [-fdlb3H] [input_file]

DESCRIPTION
	Getami displays an RLE image on a Commodore Amiga. The program tries
	to display the image in the best possible way, using HAM mode and
	overscan when appropriate. Both NTSC and PAL Amigas are catered for.
	In addition, the program allows you to save the displayed picture in
	IFF format, using Christian Weber's iff.library.

	Getami understands the following options:

	-w width  Override the screen width computed by getami. Eg., use
		  -w 640 if getami selects a screen resolution of 320x400
		  (because the picture will fit in it), but what you really
		  want is 640x400.

	-h height Override the screen height computed by getami.

		  Apart from the example mentioned above, these two options
		  are probably obsolete.

	-o file	  Make getami act as an RLE->IFF converter: after rendering the
		  RLE file, getami saves the image in IFF form in the file
		  specified, then exits.

	-f	  Render the image flipped vertically. This option is necessary,
		  because rleflip -v often requires more memory than available
		  on the amiga.

	-d	  This option causes getami to dump the color map it computes
		  into file "cmap".

	-l	  This option causes getami to ignore the color map it
		  computes, and to replace it with the color map stored in file
		  "cmap".

		  These two options must be used if you are using getami to
		  create IFF files to be used as frames for an ANIM file, as
		  all frames have to have the same color map.

	-b	  Render the image in black and white. This allows you to
		  display pictures at full resolution. (To display in color a
		  640x400 picture with more than 16 colors, you need to scale
		  it down to 320x400, not to mention the unavoidable blurriness
		  introduced by Hold And Modify.)

	-3	  Render the image in 4096 colors without using HAM. This is
		  achieved by rendering the image in three screens, one for each
		  of its r,g,b components, then flipping through them in rapid
		  succession. Because of this rapid flipping, the image 
		  flickers. This is especially noticeable in conjunction with
		  interlace. If you are sensitive to screen flicker, please do
		  not use this option.

	-H	  Force rendering of the image in HAM mode. Useful in rendering
		  animation frames, if getami happens to render some of the
		  frames in HAM mode and some in another mode.

MENU OPERATIONS
	You can select the following actions from the menu bar:

	SAVE	Save the rendered picture in an IFF ILBM file. The picture will
		be saved in a file with the extension ".ILBM". Eg., if you are
		rendering a.rle, the picture will be saved in a.ILBM. If the
		picture you are rendering comes from the standard input, you
		will be asked to specify the name of the IFF file. This action
		can also be invoked by pressing right Amiga-S.

	SAVE AS	Same as SAVE, but you are always asked for the name of the
		IFF file. To cancel the save, simply give a null file name.
		This action can also be invoked by pressing right Amiga-A.

		These two operations can only be invoked if you have Christian
		Weber's iff.library in your LIBS: directory. If you save a
		picture which has been rendered with the -3 option, you will
		actually create three files, with extensions ".r", ".g", and
		".b", respectively. You can view this image using the show3
		program.

	QUIT	Exit the program. This action can also be invoked by pressing
		right Amiga-Q, or by clicking on the invisible gadget at the
		top left corner.

AUTHORS
	Eleftherios Koutsofios (ek@ulysses.att.com) wrote the original version
	of this program, including the HAM rendering algorithm.

 	Kriton Kyrimis (kyrimis%theseas@csi.forth.gr) added support for
 	intuition, overscan, saving files, the B&W and 4096 color display
 	modes, and all the minor items selectable through switches.
