/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*************************************************************
*
*  File:   variable.c
*
*  Purpose: allocate storage for global variables of evolver.
*
*/

#include "include.h"

char *VERSION = "Version 1.76  March 19, 1992";

char *areaname;  /* length or area */

int gocount = 0;        /* number of iterations left */ 
#ifdef NeXTapp
int go_display_flag = 1; /* for displaying each change */
#else
int go_display_flag = 0; /* for displaying each change */
#endif

element_id junk; /* for MSC bug */
element_id xx_id;  /* for macro temporary to prevent multiple evaluation */
element_id x1_id,x2_id,x3_id,x4_id,x5_id,x6_id,x7_id,x8_id,x9_id;
element_id xa_id,xb_id,xc_id; /* so nested macros don't tromp each other */

#ifdef TCPP
extern unsigned _stklen = 0x3000;  /* get bigger stack */
#endif

FILE *logfd = NULL;  /* command log file */
FILE *commandfd = NULL;  /* command input file */
char filename[60]; /* command file name */
char datafilename[60];  /* current datafile name */
int datafile_flag;  /* 1 for datafile, 0 for command so expression
			      parser knows what's up */
int const_expr_flag;  /* 1 for const_expr, 0 for command so expression
			      parser knows what's up */
FILE *data_fd;
FILE *outfd = stdout;    /* where normal output is to go */
int estimate_flag;   /* for toggling estimate of energy decrease */
int parens;          /* level of parenthesis nesting */
int autopop_flag;    /* whether to do autopopping */
int autochop_flag;    /* whether to do autochopping */
REAL autochop_size;  /* max edge length for autochop */
int autopop_count;  /* number of edges found */
int autochop_count;  /* number of edges found */
int effective_area_flag; /* use quadratic form for area around vertex */
int old_area_flag;    /* on for using old effective area */
int runge_kutta_flag;  /* whether to use runge-kutta method for motion */
int fixed_volumes;     /* how many bodies have fixed volumes */
double total_time;     /* total scale factor */
double star_fraction;  /* weighting factor for star around vertices */

/* for Dennis DeTurck unit normal motion */
int unit_normal_flag;
double deturck_factor = 1;  /* weight for unit normal */

int int_val;
double real_val;
int tok;    /* current token from yylex */

/* squared curvature as part of energy */
int square_curvature_flag;  /* set if to be counted */
int square_curvature_param;  /* which parameter for modulus */
int kusner_flag;   /* set for edge square curvature */
int sqgauss_flag;  /* for squared gaussian curvature */
double target_length;  /* for string model */
int check_increase_flag;  /* to detect blowups */
int approx_curve_flag;  /* if approximate curvature in effect */

/* homothety target value, set when homothety toggled on */
double homothety_target;

int compcount;  /* integrand components on constraints */
char msg[200];     /* for constructing user messages */
char errmsg[200];  /*  for error() routine */
jmp_buf jumpbuf;   /* for error recovery  */
jmp_buf cmdbuf;   /* for command error recovery  */
int parse_error_flag;  /* set when parser hits error */
int recovery_flag;     /* set while recovering from parsing error */
int parse_errors;    /* for counting errors */
int breakflag;     /* set by user interrupt */
int iterate_flag;  /* so handler knows when iteration in progress */
REAL  (*oldcoord)[MAXCOORD];  /* allocated space for old coordinates */

/* conjugate gradient stuff */
int    conj_grad_flag;  /* whether conjugate gradient in effect */
double cg_oldsum;  /* total grad*grad from previous step */
REAL   (*cg_hvector)[MAXCOORD] = NULL;  /* saved direction vector */
double cg_gamma;   /* direction adjustment factor */

/* graphing flags */
int init_flag; /* whether graphics initialized */
int bdry_showflag = 1;  /* whether to show facets on boundary */
int no_wall_flag;      /* whether to suppress wall facets */
int normflag = 0;
int thickenflag = 0;
int innerflag = 0;
int outerflag = 0;
int colorflag = 0;
int OOGL_flag = 0;
int edgeshow_flag = 1;   /* whether to show edges of facets */
int triple_edgeshow_flag;   /* whether to show triple edges  */
double thickness = 0.0;  /* for thickening */
int bare_edge_count;  
float facet_alpha = 1;  /* global transparency */

IColor iris_colors[16] = {  /* rgba */ {0.0,0.0,0.0,1.},{0.0,0.0,.3,1.},
 {0.0,.3,0.0,1.},{0.0,.3,.3,1.}, {.3,0.0,0.0,1.},{.3,0.0,.3,1.},
 {.3,0.0,.7,1.},{.3,.3,.3,1.},{.7,.7,.7,1.},{.7,.7,1.,1.}, {.7,1.,.7,1.},
 {.7,1.,1.,1.},{1.,.7,.7,1.},{1.,.7,1.,1.},{1.,1.,.7,1.},{1.,1.,1.,1.} };

/* query variables */
int condition_flag;    /* whether query has condition expression */
struct expnode qnode;  /* for query expression */
struct expnode show_expr;  /* for show expression */
int celement;          /* type of element for query */
element_id q_id;
int query_intval;
REAL query_realval;
int set_query_type;
ATTR set_query_attr;
int query_coord;

/* graphing stuff */
char cmapname[100];  /* colormap file name */ 
maprow *colormap; /* rgba colormap, values 0 to 1 */
int fillcolor; /* current polygon fill color */
int box_flag = 0;  /* whether or not to show outline box */
int ridge_color_flag;  /* whether to differently color */
REAL  overall_size;  /* for anybody who wants to know how big */
 
/* vertex for zooming in on; default is first one read in */
int zoom_number = 1;

/* for inner clipping for making zoom pictures */
int inner_clip_flag = 0;   /* don't clip by default */
double inner_clip_rad = 0.0; /* show everything by default */

double simplex_factorial = 1.0;  /* simplex area factor */
double volume_factorial = 1.0;  /* simplex volume factor */
int subsimplex[1<<MAXCOORD][MAXCOORD];  /* for refining simplices */

REAL **identity;  /* handy identity matrix, set up in init_view */
REAL **scratch_mat; /* sdim by sdim temp matrix */

/* graph function pointers */
#if defined(NOPROTO)
void (*graph_start)();
void (*graph_end)();
void (*graph_edge )();  /* called to graph one triangle */
void (*graph_facet)();
void (*display_edge )();
void (*display_facet)();
void (*init_graphics)();
void (*finish_graphics)();
#else
void (*graph_start)(void); 
void (*graph_edge )(struct graphdata *); 
void (*graph_facet)(struct graphdata *,facet_id); 
void (*graph_end)(void);   
void (*display_edge )(struct tsort *);
void (*display_facet)(struct tsort *);
void (*init_graphics)(void);
void (*finish_graphics)(void);
#endif

FILE * savefd;    /* for binary dump of web */

/* general parameters */
REAL **view;  /* transformation matrix */ 
int steps = 1; 
int energy_init;     /* to keep track if we have current config energy */
int movie_init;      /* whether movie routine initialized */

double wulff_vector[MAXWULFF][MAXCOORD];  /* the vector components */
#ifdef NOPROTO
void (*get_wulff)();
#else
void (*get_wulff)(REAL *,REAL *);
#endif

REAL **phase_data;  /* phase boundary energies */
int  phase_flag;    /* if phase boundary data in effect */
char phase_file_name[60];  /* for dump */
int phasemax;  /* number of phases */	

REAL **leftside;  /* volume projection matrix (torus model) */
REAL **rleftside;  /* volume projection matrix (for vol restore) */
REAL **fleftside;  /* volume projection matrix (for forces) */
REAL *rightside;  /* right side of volume gradient constraints */
REAL *pressures; /* multiples of gradients to subtract from force */
REAL *vol_deficit; /* bodyu volume deficits */
REAL *vol_restore; /* volume restoring gradient coefficients */
int no_refine = 0;   /* keyword NOREFINE in data file header sets this
                        to disable initial triangulation of triangular
                        initial faces. */

/* interpolation structures */
int level = 0;  /* refinement level */
REAL extrap_val[MAXLEVEL]; /* energy value at refinement level */


/* model dependent function pointers */
#ifdef NOPROTO
void (*calc_facet_energy)() = facet_energy_l;
void (*calc_facet_forces)()  = facet_force_l;
void (*calc_facet_volume)() = facet_volume_l;
void (*calc_edge_energy)() = edge_energy_l;
void (*calc_edge_forces)()  = edge_force_l;
void (*calc_edge_area)() = edge_area_l;
void (*string_grad)() = string_grad_l;
void (*film_grad)() = film_grad_l;
#else
/* void (*calc_facet_energy)(facet_id) = facet_energy_l;*/
/* void (*calc_facet_forces)(facet_id) = facet_force_l; */
void (*calc_facet_energy)(facet_id) =  facet_energy_l;
void (*calc_facet_forces)(facet_id) = facet_force_l;
void (*calc_facet_volume)(facet_id) = facet_volume_l;
void (*calc_edge_energy)(edge_id) = edge_energy_l;
void (*calc_edge_forces)(edge_id) = edge_force_l;
void (*calc_edge_area)(edge_id) = edge_area_l;
void (*string_grad)(void) = string_grad_l;
void (*film_grad)(void) = film_grad_l;
#endif

/* gaussian integration on [0,1] */
REAL gausspt1[1] = { 0.5 };
REAL gausswt1[1] = { 1.0 };
REAL gausspt2[2] = { 0.211324865405107  , 0.788675134594813 };
REAL gausswt2[2] = { 0.5, 0.5 };
REAL gausspt3[3] = { 0.112701665379258, 0.5, 0.887298334620742 };
REAL gausswt3[3] = { 5.0/18, 8.0/18, 5.0/18 };
REAL *gausspts[MAXGAUSS+1] = { NULL, gausspt1, gausspt2, gausspt3 };
REAL *gausswts[MAXGAUSS+1] = { NULL, gausswt1, gausswt2, gausswt3 };
REAL *gausspt = NULL;  /* default */
REAL *gauss1Dpt;
REAL *gauss1Dwt;

/* gaussian quadrature over triangles */
/* points given in barycentric coordinates */
/* weights total to 1 */

REAL gauss2Dpt1[1][3] = { {1/3.0, 1/3.0, 1/3.0} };
REAL gauss2Dwt1[1]    = { 1.0 };

REAL gauss2Dpt3[3][3] = { {2/3.0, 1/6.0, 1/6.0}, {1/6.0,2/3.0,1/6.0},
			   {1/6.0, 1/6.0, 2/3.0} };
REAL gauss2Dwt3[3]    = { 1.0/3, 1.0/3, 1.0/3 };

/* point indexing for 7-point quadrature:
       |\
       |2\ 
       |   \
       |4 0 5\
       |       \
       |3   6   1\
       ------------


*/

#define ROOT15 3.87298334620742

/* point coordinates */
#define Q1  (9 + 2*ROOT15)/21.0
#define Q2  (9 - 2*ROOT15)/21.0
#define Q3  (6 - ROOT15)/21.0
#define Q4  (6 + ROOT15)/21.0

REAL gauss2Dpt7[7][3] = { {1/3.0, 1/3.0, 1/3.0}, {Q3,Q1,Q3}, {Q3,Q3,Q1},
   {Q1,Q3,Q3}, {Q4,Q2,Q4}, {Q2,Q4,Q4}, {Q4,Q4,Q2}};

/* point weights */
#define W1  270/1200.0
#define W2  (155 - ROOT15)/1200.0
#define W3  (155 + ROOT15)/1200.0

REAL gauss2Dwt7[7] = { W1, W2, W2, W2, W3, W3, W3 };

barytype *gauss2Dpt = gauss2Dpt7;  /* default */
REAL *gauss2Dwt = gauss2Dwt7;  /* default */

/* general dimension gauss integration variables and arrays */
int ctrl_num;  /* number of control points */
int gauss_num; /* number of integration points */
REAL *gausswt;  /* weights of integration points */
REAL **gpoly;   /* interpolation polynomial value at integration point k
		   for polynomial of control point j */
REAL ***gpolypartial; /* partials of interpolation polynomials */

REAL **metric;  /* metric values at a point */
REAL ***metric_partial; /* partial derivatives of metric */
REAL **det_array;   /* tangent vector dot products */
REAL **tang;    /* tangents to surface at point */

/* symmetry group stuff */
#ifdef NOPROTO
void (*sym_wrap)();    /* points to user-defined symmetry function */
void (*sym_form_pullback)();  /* points to user-defined tangent wrapper */
WRAPTYPE (*sym_inverse)(); /* points to user-defined symmetry function */
WRAPTYPE (*sym_compose)(); /* points to user-defined symmetry function */
#else
void (*sym_wrap)(REAL*,REAL*,WRAPTYPE);
void (*sym_form_pullback)(REAL*,REAL*,REAL*,WRAPTYPE);
WRAPTYPE (*sym_inverse)(WRAPTYPE);
WRAPTYPE (*sym_compose)(WRAPTYPE,WRAPTYPE);
#endif

