/******************************************************************************
* Triv_err.c - handler for all triv library fatal errors.		      *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/

#include "triv_loc.h"

typedef struct TrivErrorStruct {
    TrivFatalErrorType ErrorNum;
    char *ErrorDesc;
} TrivErrorStruct;

static TrivErrorStruct ErrMsgs[] =
{
    { TRIV_ERR_DIR_NOT_VALID,	"Dir is not valid" },
    { TRIV_ERR_UNDEF_CRV,	"Undefined curve type" },
    { TRIV_ERR_UNDEF_SRF,	"Undefined surface type" },
    { TRIV_ERR_UNDEF_CRV,	"Undefined curve type" },
    { TRIV_ERR_UNDEF_TRIVAR,	"Undefined trivariate type" },
    { TRIV_ERR_UNDEF_GEOM,	"Undefined geometry type" },
    { TRIV_ERR_RATIONAL_NO_SUPPORT, "Rational function is not supported" },
    { TRIV_ERR_WRONG_ORDER,	"Provided order is wrong" },
    { TRIV_ERR_KNOT_NOT_ORDERED,"Provided knots are not in ascending order" },
    { TRIV_ERR_NUM_KNOT_MISMATCH,"Number of knots does not match" },
    { TRIV_ERR_INDEX_NOT_IN_MESH,"Index is out of mesh range" },
    { TRIV_ERR_POWER_NO_SUPPORT,"Power basis type is not supported" },
    { TRIV_ERR_WRONG_DOMAIN,	"Given parameter is not in domain" },
    { TRIV_ERR_DIR_NOT_CONST_UVW, "Given direction is not U, V or W" },
    { TRIV_ERR_SCALAR_PT_EXPECTED,"A scalar field trivariate is expected." },
    { TRIV_ERR_NO_CLOSED_POLYGON,"Failed to form a closed polygon." },
    { TRIV_ERR_TWO_INTERSECTIONS,"Should have found two intersections only." },
    { TRIV_ERR_NO_MATCH_PAIR,    "Cannot find matching pairs." },
    { TRIV_ERR_2_OR_4_INTERS,    "Only two or four intersections in a face." },
    { TRIV_ERR_FAIL_FIND_PT,	 "Failed to find next point." },

    { TRIV_ERR_UNDEFINE_ERR,	NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this triv library as well as other users. Raised error will  M
* cause an invokation of TrivFatalError function which decides how to handle M
* this error. TrivFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   TrivDescribeError, error handling                                        M
*****************************************************************************/
char *TrivDescribeError(TrivFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
