 /*
  * Khoros: $Id: utils.c,v 1.1 1991/05/10 15:41:33 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: utils.c,v 1.1 1991/05/10 15:41:33 khoros Exp $";
#endif

 /*
  * $Log: utils.c,v $
 * Revision 1.1  1991/05/10  15:41:33  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

/*
	UTILS - Collection of utility routines used in performing
                a raster bilinear fill

	Written: Scott Wilson

*/
#include "remote_gis/lvrast.h"		/* Define line structure */
#include <math.h>

make_line(l,xa,ya,xb,yb,wxa,wya,wxb,wyb,inten1,inten2)
struct line *l;
int xa,ya,xb,yb;
float wxa,wxb,wya,wyb,inten1,inten2;
  {
    /* Build a line segment structure */
    l->x1 = xa;     l->x2 = xb;
    l->y1 = ya;     l->y2 = yb;
    l->wx1 = wxa;   l->wx2 = wxb;
    l->wy1 = wya;   l->wy2 = wyb;
    l->i1 = inten1; l->i2 = inten2;
  }

float
intrp(i,seg)
int i;
struct line *seg;
  {
    /* Interpolate an intensity based ONLY on the x-coordinates
       of the line segment endpoints and the supplied x location. */
    float f;

    if (seg->x2 == seg->x1) return(seg->i1);
    else
      {
        f = seg->i1+(seg->i2-seg->i1)*((float)(i-seg->x1)/
            (float)(seg->x2-seg->x1));
         return(f);
      }
  }

between(y1,y,y2)
float y1,y2;
int y;
  {
    if ((y >= y1 && y <= y2) ||
        (y >= y2 && y <= y1))
      return(1);
    else
      return(0);
  }

minmax(x1,x2,x3,x4,min,max)
float x1,x2,x3,x4,*min,*max;
  {
    float maxx,minn;

    maxx = x1 > x2 ? x1 : x2;    /* Get max */
    maxx = maxx > x3 ? maxx : x3;
    maxx = maxx > x4 ? maxx : x4;

    minn = x1 < x2 ? x1 : x2;    /* Get min */
    minn = minn < x3 ? minn : x3;
    minn = minn < x4 ? minn : x4;

    *min = minn;
    *max = maxx;
  }

