 /*
  * Khoros: $Id: dmpp.h,v 1.3 1992/03/20 23:22:14 dkhoros Exp $
  */

 /*
  * $Log: dmpp.h,v $
 * Revision 1.3  1992/03/20  23:22:14  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dmpp.h
 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>> Date Last Updated: Mon Mar  9 18:53:57 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dmpp_h_
#define _dmpp_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dmpp Argument Structure
*
****************************************************************/

typedef struct _dmpp  {

/*
 *  input data file (xviff file) (Required infile)
 */
char	*i_file;	/* input data file (xviff file) FILENAME */
int	 i_flag;	/* input data file (xviff file) FLAG */

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  type of phase (0-radians, 1-degrees) (Optional logical)
 */
int	 p_logic;	/* type of phase (0-radians, 1-degrees) LOGIC */
int	 p_flag;  	/* type of phase (0-radians, 1-degrees) FLAG */

/*
 *  phase range (0: -pi to pi, 1: - 0 to 2pi) (Optional logical)
 */
int	 mp_logic;	/* phase range (0: -pi to pi, 1: - 0 to 2pi) LOGIC */
int	 mp_flag;  	/* phase range (0: -pi to pi, 1: - 0 to 2pi) FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * type of response desired: (Optional integer toggle - )
 */
int	 m_toggle;		/* type of response desired: INT TOGGLE */
int	 m_flag;		/* type of response desired: FLAG */

/*
 * type of scaling: (Optional integer toggle - )
 */
int	 s_toggle;		/* type of scaling: INT TOGGLE */
int	 s_flag;		/* type of scaling: FLAG */

}  dmpp_struct;

dmpp_struct *dmpp;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(dmpp->i_file); \
    if(image == NULL){ \
        fprintf(stderr,"dmpp: Image could not be read\n"); \
        exit(1); \
    }

#define CHECKTYPE(program, image) \
    if(!(propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
       !(propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
       fprintf(stderr,"dmpp: data storage type must be float or complex.\n"); \
       exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE); \
    proper_dim(program,image,0,TRUE); \
    proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE); \
/* -include_macros_end */

#endif
