#! /bin/csh -f

# 
#  Khoros: $Id: kinstall_csh.csh,v 1.4 1992/03/20 22:35:56 dkhoros Exp $
#

#
# $Log: kinstall_csh.csh,v $
# Revision 1.4  1992/03/20  22:35:56  dkhoros
# VirtualPatch5
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: kinstall_csh                           <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for installing khoros routines
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

#
# ROUTINE NAME:	kinstall_csh
# 
# AUTHORS:	Charlie Gage, Tom Sauer
# 
# DATE:		3/11/91
# 
# DESCRIPTION:	used to install programs into the Khoros environment 
# 
# MODIFICATIONS:
#
# ROUTINES:	kinstall_csh
#		

set noclobber
set nonomatch
onintr cleanup
umask 002


#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 16) then
  echo ""
  echo "Invalid number of arguments detected."
  echo "Please invoke this script from the driver routine." 
  echo ""
  exit 0
endif

# Get the arguments from the driver program
#------------------------------------------------------------
set PROGRAM = $1
set PROGPATH = $2
set CPATH = $3
set HPATH = $4
set LPATH = $5
set LIBHPATH = $6
set MAN1PATH = $7
set MAN3PATH = $8 
set PANEPATH = $9
set HELPPATH = $10
set SUBHELPPATH = $11
set MACH = $12
set TOPSRC = $13
set FORCE = $14
set FPROG = $15
set TOOLBOX = $16

# Summary of variables used in this script:
#------------------------------------------------------------
# Program requires the use of a reserved keyword - "_NULL_"
#  to represent any NULL or empty arguments passed in.
#
# Input Variables to kinstall_csh
#  PROGRAM    -  specifies the name of the program to install
#  PROGPATH   -  specifies the path to the src subdirectory
#  CPATH      -  specifies the path to the C driver file
#  HPATH      -  specifies the path to the include file
#  LPATH      -  specifies the path for the library file (optional)
#  LIBHPATH   -  specifies the path to the library include file (optional)
#  MAN1PATH   -  specifies the path for the man1 file
#  MAN3PATH   -  specifies the path for the man3 file (optional)
#  PANEPATH   -  specifies the path for the .pane file
#  HELPPATH   -  specifies the path to the cantata online manpages
#  SUBHELPPATH -  specifies the path to the Overview.doc file
#  MACH       -  specifies the path to the mach file
#  TOPSRC     -  specifies the top of src as indicated in the *.conf file
#  FORCE      -  specifies whether to override the overwrite prompts
#  FPROG      -  specifies whether to use FORTRAN dependencies
#  TOOLBOX    -  specifies the Toolbox name
#
# Variables used in the script:
#  KHOROS_HOME - environment variable
#  KHOROS_MAIL - users mail environment variable
#
# Optional variables will have "_NULL_" passed in to them if no
#  path is specified.
set LIB_FLG = 0
set MAN3_FLG = 0
set TEMPDIR = /tmp

# Set up environment variables
#----------------------------------------------------
if (! $?KHOROS_HOME) then
   echo ""
   echo "kinstall: Error, need KHOROS_HOME "
   echo "          environment variable set to proceed."
   echo ""
   exit 0
endif

if (! $?KHOROS_MAIL ) then
   echo ""
   echo "kinstall: Error KHOROS_MAIL environment variable is not set"
   echo ""
   exit 0
endif

# Set the PATH for the user
set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

set FULLHOST = `hostname`

# check to see if a toolbox is being used.
#---------------------------------------------------------------

if ($TOOLBOX == "_NULL_") then
   set USE_TOOLBOX = 0
else
   set USE_TOOLBOX = 1
endif


#  Get the proper mach file
#---------------------------------------------------------------
if ($MACH == "_NULL_") then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}) then
       set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-f $KHOROS_HOME/repos/config/src_conf/default_mach) then
	set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "kinstall: The mach_def file does not exist"
	echo " Since you are insatlling in KHOROS_HOME, please"
        echo " create the file $KHOROS_HOME/repos/config/src_conf/default_mach"
        echo " For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        exit 1
    endif
else if (-f $MACH.{$FULLHOST} ) then
        set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH ) then
           echo ""
           echo "kinstall: Error, the mach file '$MACH' for the toolbox"
           echo "specified was not found. Please create the mach file"
           echo "$MACH"
           echo ""
           exit 1
    endif
endif

# source the mach file determined in the chaos above
source $MACH

set NUM_MACHINES = $#KHOROS_MACHINES
set NUM_DIR = $#KHOROS_MACH_DIR
set NUM_SRC = $#KHOROS_SRC_TOP

if ( $NUM_DIR < 1) then
  set SINGLE_SRC = 1
else 
  set SINGLE_SRC = 0
  if ( ($NUM_MACHINES != $NUM_DIR) && ($NUM_MACHINES != $NUM_SRC) || $NUM_DIR < 1) then
      echo ""
      echo "ksrcconf: Error, incorrect number of entries in default_mach file."
      echo " Please check that the number of entries in each field"
      echo " is the same (ie. number of entires must correspond)."
      echo ""
      goto cleanup
  endif
endif

# Determine the relative path to src from the TOPSRC parameter
#  from the *.conf file.  Also check read/write permissions.
#--------------------------------------------------------------
@ count = 1
set iflag = 0

foreach i ( $PROGPATH $CPATH $HPATH $LPATH )
  if ($TOPSRC == "_NULL_") then
     if (-e $LOCAL_SRC_TOP/$i) then
        if (! -r $LOCAL_SRC_TOP/$i || ! -w $LOCAL_SRC_TOP/$i) then
	  echo "Cannot access $LOCAL_SRC_TOP/$i for reading/writing! Exiting..."
	  goto cleanup
	endif
        set iflag = 1
     else
        # Try to get a relative path.
        #  This only works if i has the initial part of the path
        #  in common with LOCAL_SRC_TOP
        set RELPATH = `echo $i | sed -e "s|$LOCAL_SRC_TOP/||"`
        if (-e $LOCAL_SRC_TOP/$RELPATH:h || $RELPATH:h == $RELPATH) then
           if (! -r $LOCAL_SRC_TOP/$RELPATH:h || ! -w $LOCAL_SRC_TOP/$RELPATH:h || $RELPATH:h == $RELPATH) then
	       echo "Cannot access $LOCAL_SRC_TOP/$RELPATH:h for reading/writing! Exiting..."
	       goto cleanup
           endif
           if ($count == 1) then
              set REL_PROGPATH = $RELPATH
           endif
        else
           echo ""
           echo "Invalid path detected in config file:"
	   echo "$MACH"
           echo "The following path was constructed from the LOCAL_SRC_TOP"
           echo " parameter and the relative path between topsrc and the src"
           echo " paths specified in the config file."
           echo " Path:  $LOCAL_SRC_TOP/$RELPATH "
           echo ""
           echo "A complete, valid path must be supplied."
           echo " An example of a configuration file is provided in,"
           echo " $KHOROS_HOME/repos/config/src_conf/TEMPLATE.conf"
           echo ""
           echo "Please check the config file for this toolbox."
           echo ""
           goto cleanup
        endif
     endif
 else
     if ( -e $LOCAL_SRC_TOP/$i ) then
        if (! -r $LOCAL_SRC_TOP/$i || ! -w $LOCAL_SRC_TOP/$i) then
          echo "Cannot access $LOCAL_SRC_TOP/$i for reading/writing! Exiting..."
          goto cleanup
	endif
        set iflag = 1
     else
        if (! -d $TOPSRC) then
           echo ""
           echo "Invalid or incomplete path specified for"
           echo " topsrc parameter in config file."
           echo " Path: $TOPSRC"
           echo ""
           goto cleanup
        endif
        if ($i == $TOPSRC) then
           set RELPATH = ""
        else
           set RELPATH = `echo $i | sed -e "s|$TOPSRC/||"`
        endif
        if (-e $LOCAL_SRC_TOP/$RELPATH:h || $RELPATH:h == $RELPATH) then
          if (( ! -r $LOCAL_SRC_TOP/$RELPATH:h || ! -w $LOCAL_SRC_TOP/$RELPATH:h) && $RELPATH:h != $RELPATH) then
	      echo "Cannot access $LOCAL_SRC_TOP/$RELPATH:h for reading/writing! Exiting..."
	      goto cleanup
	  endif
          if ($count == 1) then
             set REL_PROGPATH = $RELPATH
          endif
        else
          echo ""
          echo "Invalid path detected in config file."
          echo "The following path was constructed from the LOCAL_SRC_TOP"
          echo " parameter and the relative path between topsrc and the src"
          echo " paths specified in the config file."
          echo " Path:  $LOCAL_SRC_TOP/$RELPATH"
          echo ""
          echo "A complete, valid path must be supplied."
          echo " An example of a configuration file is provided in,"
          echo " $KHOROS_HOME/repos/config/src_conf/TEMPLATE.conf"
          echo ""
          echo "Please check config file."
          echo ""
          goto cleanup
        endif
     endif
  endif
@ count++
end

if ($iflag) then
   set PROGPATH = $LOCAL_SRC_TOP/$PROGPATH
   set LPATH = $LOCAL_SRC_TOP/$LPATH
else
   set PROGPATH = $LOCAL_SRC_TOP/$REL_PROGPATH
   set LPATH = $LOCAL_SRC_TOP/$RELPATH
endif

set CATEGORY = $PROGPATH:h
set category = $CATEGORY:t
set subs = ""
set foundfile = 0

# check for read permissions on all files to be installed
#--------------------------------------------------------------
 foreach i (l$PROGRAM.c l$PROGRAM.h l$PROGRAM.f $PROGRAM.1 $PROGRAM.3 \
            $PROGRAM.h $PROGRAM.c $PROGRAM.pane $PROGRAM.prog \
            Makefile Imakefile )
   if (-e $i && ! -r $i ) then
       echo "Cannot access $i for reading! Exiting..."
       goto cleanup
   endif
 end

# check other parameters in config file, and make sure they 
#  are valid paths and are writable directories.
#--------------------------------------------------------------
  foreach i ( $MAN1PATH $MAN3PATH $PANEPATH $HELPPATH $SUBHELPPATH )
     if (-d $i ) then
        if (! -r $i || ! -w $i) then
	   echo ""
	   echo ""
           echo "Kinstall: Cannot access $i for reading/writing! Exiting..."
           echo "Please ensure that all directories in the config"
           echo " file exist, and are writable."
           goto cleanup
        endif
      else
	echo ""
	echo ""
	echo "Kinstall: Cannot access the directory: "
	echo "    $i"
	echo ""
	echo "This directory must exist if you want to continue."
	echo -n "Create the directory? (y/n) [y]: "
	set resp = $<
	if ($resp == 'n' || $resp == 'N') then
	   echo "kinstall: exiting kinstall"
	   goto cleanup
	else
	   \mkdir $i
	endif
      endif
  end


# If FORCE option is set to TRUE, then check to make sure program 
# has been previously installed.
#--------------------------------------------------------------
if (! -e $PANEPATH/$PROGRAM.pane  &&  $FORCE == "TRUE") then
   echo ""
   echo "$PROGRAM has not been previously installed."
   echo "Cannot use FORCE option set to TRUE"
   echo "Please set FORCE option to FALSE (default)."
   echo ""
   goto cleanup
endif

# Print out the paths where the source will be placed and ask user to
# continue with the install
#    

   if (! -d $LPATH) then
      echo "kinstall:"
      echo -n "kinstall: ERROR; kinstall cannot access"
      echo " the directory: $LPATH"
      echo ""
      goto cleanup
   endif

   if (! -d $PROGPATH:h) then
      echo "kinstall:"
      echo -n "kinstall: ERROR; kinstall will NOT create"
      echo " this directory: $PROGPATH:h"
      echo ""
      echo "You must have specified somthing wrong on the command line or"
      echo " the directory $PROGPATH:h does not exist"
      echo ""
      goto cleanup
   endif

    echo ""
    echo "Library source location: $LPATH"
    echo "Driver source location : $PROGPATH"
    echo ""
    echo -n "kinstall: Do you wish to continue (y/n)? "
    set continue_flg = $<
    echo ""

    if ($continue_flg != 'y') goto cleanup


# Check to see if anyone else is installing
#----------------------------------------------
    if ( -e  $TEMPDIR/.kinstall.lock ) then
       echo ""
       echo ""
       echo "kinstall: Someone else is installing a routine right now."
       echo "          Please try again in a few minutes"
       echo ""
       echo "          We can not allow more than one person to install"
       echo "          because of possible conflicts..."
       echo ""
       goto cleanup
    else
       touch $TEMPDIR/.kinstall.lock
    endif

# Check to see that KHOROS_USER was sourced from mach file
#-----------------------------------------------------
if ($KHOROS_USER == "") then
   echo ""
   echo "kinstall: KHOROS_USER environment variable not set."
   echo " Please check your mach file for this variable."
   echo ""
   goto cleanup
endif


# copy library header file and install into $VARCHIVE
#-----------------------------------------------------
    if ( -e l$PROGRAM.h ) then
       echo ""
       echo "Copying library header to $LIBHPATH"
       echo ""
       if ($FORCE) then
          cp l$PROGRAM.h $LIBHPATH/l$PROGRAM.h
       else
          cp -i l$PROGRAM.h $LIBHPATH/l$PROGRAM.h
       endif
       chmod 664 $LIBHPATH/l$PROGRAM.h
    endif

# copy library source files and install into $VARCHIVE
#----------------------------------------------------------------
    echo ""
    echo "Copying library source to $LPATH"
    echo ""
    foreach i (l$PROGRAM.c l$PROGRAM.f)
      if (-e $i) then
         if ($FORCE) then
            \cp $i $LPATH/$i
         else
            \cp -i $i $LPATH/$i
         endif
         set LIB_FLG = 1
         chmod 664 $LPATH/$i
      endif
    end

#  Making symbolic links from library source to srcmachs
# if srcmachs exist
#-------------------------------------------------------- 
if (! $SINGLE_SRC) then 
       echo "" 
       echo "Making library symbolic links" | tee -a /tmp/kinstall.$$
       echo ""

      foreach i (l$PROGRAM.c l$PROGRAM.f)
        if (-e $i) then
            klnfile_csh $LPATH/$i 0 $MACH                # klnfile, make links
        endif
      end
    endif

# Updating the Makefiles for the Library
#---------------------------------------------------
    echo ""
    echo "Updating the Makefile in directory $LPATH" | \
	tee -a /tmp/kinstall.$$
    echo ""

# change directory to the library src and update Makefiles
   pushd $LPATH >& /dev/null

    if (! -e Imakefile) then
         echo "This Library has never been initialized..."
         echo "Please create an Imakefile and Makefile in the directory:"
	 echo "$LPATH."
	 echo "Also, modify the TOOLBOX_LIBRARIES symbol in the TOOLBOX"
         echo "imake defination file:"
	 echo "$TOOLBOX/repos/config/src_conf/$TOOLBOX.def"
	 echo "so that programs will load against this new library"
         goto cleanup
    endif
       
    if ($USE_TOOLBOX) then
       imkmf -toolbox $TOOLBOX | tee -a /tmp/kinstall.$$
    else
       imkmf | tee -a /tmp/kinstall.$$
    endif

    makemake

    if (! $SINGLE_SRC) then
       if ($USE_TOOLBOX) then
          kmakeall -toolbox $TOOLBOX Makefile               # for toolbox
       else
          kmakeall Makefile                                 # for KHOROS_HOME
       endif

       echo "I must wait about one minute to allow the Makefiles to update"
       sleep 60

       echo ""
       echo "Calling kmakeall in directory $LPATH" | \
	   tee -a /tmp/kinstall.$$
       echo ""

       if ($USE_TOOLBOX) then
          kmakeall -toolbox $TOOLBOX install               # for toolbox
       else
          kmakeall install                                 # for KHOROS_HOME
       endif

    else
       echo ""
       echo "Calling make in directory $LPATH" | \
           tee -a /tmp/kinstall.$$
       echo ""

       make install | tee -a /tmp/kinstall.$$
    endif

    popd >& /dev/null

# copy man pages and install into $MAN1PATH & $MAN3PATH
#------------------------------------------------------
    echo ""
    echo "Copying man pages into $MAN1PATH and $MAN3PATH"
    echo ""
    if (-e $PROGRAM.1) then
       if ($FORCE) then
          \cp $PROGRAM.1 $MAN1PATH/$PROGRAM.1
       else
          \cp -i $PROGRAM.1 $MAN1PATH/$PROGRAM.1
       endif
       chmod 664 $MAN1PATH/$PROGRAM.1
	if ($status == 0) then
	    echo ""
	    echo "copying man page $PROGRAM.1 to $MAN1PATH/$PROGRAM.1" | \
	        tee -a /tmp/kinstall.$$
	    echo ""
	endif
    endif
    if (-e l$PROGRAM.3) then
       if ($FORCE) then
          \cp l$PROGRAM.3 $MAN3PATH/l$PROGRAM.3
       else
          \cp -i l$PROGRAM.3 $MAN3PATH/l$PROGRAM.3
       endif
       set MAN3_FLG = 1
       chmod 664 $MAN3PATH/l$PROGRAM.3
	if ($status == 0) then
	    echo ""
	    echo "copying man page l$PROGRAM.3 to $MAN3PATH/l$PROGRAM.3" | \
	        tee -a /tmp/kinstall.$$
	    echo ""
	endif
    endif

# update doc for cantata help page
#-----------------------------------------------------
    if (-e $PROGRAM.1) then
       echo ""
       echo "Updating the cantata help page" | \
             tee -a /tmp/kinstall.$$
       echo ""
      helppage_csh $PROGRAM.1 0 $MACH       # helppage
    endif


# update the $MAN1PATH/../whatis file
#-----------------------------------------------------
    echo ""
    echo "Updating the $MAN1PATH/../whatis file" | \
          tee -a /tmp/kinstall.$$
    echo ""
      
    if ($USE_TOOLBOX) then
       vmanwhatis -toolbox $TOOLBOX        # for a Toolbox
    else
       vmanwhatis                          # for KHOROS_HOME
    endif


# copy cantata pane to repos/cantata/panes
#-----------------------------------------------------
    echo ""
    echo "copying cantata pane to $PANEPATH/$PROGRAM.pane"
    echo "kinstall:"
    if (-e $PROGRAM.pane) then
       if ($FORCE) then
         \cp $PROGRAM.pane $PANEPATH/$PROGRAM.pane
       else
         \cp -i $PROGRAM.pane $PANEPATH/$PROGRAM.pane
       endif
       chmod 664 $PANEPATH/$PROGRAM.pane
    endif

if ($FORCE) then
    goto noedit
endif

# edit the cantata.form file and add the -p line
#-----------------------------------------------------
    echo ""
    echo "Update the cantata.form UI spec" | \
          tee -a /tmp/kinstall.$$
    echo ""
    echo " "
    echo "Enter the -p line for $PROGRAM and the -g line"
    echo "for the subform access to the pane in the subform file."
    echo "I will put you into your editor to edit the file,"
    echo "then I will update the UI specification"
    echo " "
    if ( $?EDITOR ) then
       echo -n "Return to enter $EDITOR...."
       set resp = $<
       pushd $PANEPATH >& /dev/null
       foreach file (*.sub)
         if (-f $file) then
            set subs = ($subs $file)
            set foundfile = 1
         endif
       end
       if (! $foundfile) then
          echo "No cantata.form file was found for $category."
          echo "A template file is being copied to this directory."
          echo "Please edit this file to reflect the subform for"
          echo " this category of routines."
          echo -n "Return to continue...."
          set resp = $<
          \cp $KHOROS_HOME/repos/utils/Template.sub $category.sub
          set subs = $category.sub
       endif
       foreach file ($subs)
          $EDITOR $file
       end
       popd >& /dev/null
    else   
       echo -n "Return to enter vi...."
       set resp = $<
       pushd $PANEPATH >& /dev/null
       foreach file (*.sub)
         if (-f $file) then
            set subs = ($subs $file)
            set foundfile = 1
         endif
       end
       if (! $foundfile) then
          echo "No cantata.form file was found for $category."
          echo "A template file is being copied to this directory."
          echo "Please edit this file to reflect the subform for"
          echo " this category of routines."
          echo -n "Return to continue...."
          set resp = $<
          \cp $KHOROS_HOME/repos/utils/Template.sub $category.sub
          set subs = $category.sub
       endif
       foreach file ($subs)
          vi $file
       end
       popd >& /dev/null
    endif


# edit the cantata doc Overview file and add a description
#-----------------------------------------------------------
    echo ""
    echo "Update the cantata subform Overview documentation file" | \
        tee -a /tmp/kinstall.$$
    echo ""
    echo " "
    echo "Enter the name of the program and a short description of the"
    echo "program in the Subform Overview help page for Cantata"
    echo "This should be added in the same order as the pane was added"
    echo ""
    echo "I will put you into your editor to edit the file,"
    echo "then I will update the UI specification"
    echo " "
    if ( $?EDITOR ) then
       echo -n "Return to enter $EDITOR...."
       set resp = $<
       pushd $SUBHELPPATH >& /dev/null
       if (! -e Overview.doc) then
          echo "No subform documentation file was found for $category."
          echo "A template file is being copied to this directory."
          echo "Please edit this file to reflect the description of"
          echo " routines for this category."
          echo -n "Return to continue...."
          set resp = $<
          \cp $KHOROS_HOME/repos/utils/Template.doc Overview.doc
       endif
         $EDITOR Overview.doc
       formatdoc -type help -i Overview                  # formatdoc
       popd >& /dev/null
    else
       echo -n "Return to enter vi...."
       set resp = $<
       pushd $SUBHELPPATH >& /dev/null
       if (! -e Overview.doc) then
          echo "No subform documentation file was found for $category."
          echo "A template file is being copied to this directory."
          echo "Please edit this file to reflect the description of"
          echo " routines for this category."
          echo -n "Return to continue...."
          set resp = $<
          \cp $KHOROS_HOME/repos/utils/Template.doc Overview.doc
       endif
         vi Overview.doc
       formatdoc -type help -i Overview                  # formatdoc
       popd >& /dev/null
    endif

noedit:

# if the driver src directory does not exist, create it
#------------------------------------------------------
    if (! -e $PROGPATH) then
        if (! -d $PROGPATH) then
            /bin/mkdir $PROGPATH
            /bin/chmod 775 $PROGPATH
	else
	    echo ""
	    echo "ERROR; $PROGPATH is NOT a directory"
	    echo ""
            goto cleanup
	endif
    endif
	
    echo ""
    echo "Copying driver source to $PROGPATH"
    echo ""
    foreach i ($PROGRAM.c $PROGRAM.h $PROGRAM.prog $PROGRAM.conf)
      if (-e $i) then
         if ($FORCE) then
            \cp $i $PROGPATH/$i
         else
            \cp -i $i $PROGPATH/$i
         endif
         chmod 664 $PROGPATH/$i
      endif
    end

    echo ""
    echo "Updating Makefile in directory $CATEGORY" | \
	tee -a /tmp/kinstall.$$
    echo ""


# Change to src directory (CATEGORY) and update Makefiles
#----------------------------------------------
    pushd $CATEGORY >& /dev/null

    if ($USE_TOOLBOX) then
       imkmf -toolbox $TOOLBOX | tee -a /tmp/kinstall.$$
    else
       imkmf | tee -a /tmp/kinstall.$$
    endif

    make Makefile
    if (! $SINGLE_SRC) then
       if ($USE_TOOLBOX) then
          kmakeall -toolbox $TOOLBOX Makefile               # for toolbox
       else
          kmakeall Makefile                                 # for KHOROS_HOME
       endif

       echo  "I must wait about 1 minute for the Makefiles to update"
       echo ""
       sleep 60
    endif
   
    cd $PROGPATH       # cd to location of driver src files

    # create a new ghost.ans file for the current program
    # if one does not exist.
    #------------------------------------------------
    if (! -e ghost.ans) then

       echo "-name $PROGRAM" > ghost.ans
       echo "-config t" >> ghost.ans

       if ($LIB_FLG) then
          echo "-lib t" >> ghost.ans
       else
          echo "-lib f" >> ghost.ans
       endif

       if ($MAN3_FLG) then
          echo "-man3 t" >> ghost.ans
       else
          echo "-man3 f" >> ghost.ans
       endif

       echo "-install t" >> ghost.ans
       echo "-format 1" >> ghost.ans
       echo "-debug f" >> ghost.ans
       echo "-tag t" >> ghost.ans
       echo "-force t" >> ghost.ans

       if ($FPROG) then
          echo "-type fprog" >> ghost.ans
       else
          echo "-type prog" >> ghost.ans
       endif

    endif

    # Call ksrcconf in program directory
    #-----------------------------------
    echo ""
    echo "Configuring Imakefile and Makefile in directory $PROGPATH" | \
	tee -a /tmp/kinstall.$$
    echo ""

    # remove makefiles if they exist
    foreach i (Imakefile Makefile)
       if (-e $i) then
           \rm -f $i
       endif
    end

    if ($FPROG) then
       if ($USE_TOOLBOX) then
          imkmf -toolbox $TOOLBOX -type fprog -name $PROGRAM | tee -a /tmp/kinstall.$$
       else
           imkmf -type fprog -name $PROGRAM | tee -a /tmp/kinstall.$$
       endif
    else
       if ($USE_TOOLBOX) then
          imkmf -toolbox $TOOLBOX -type prog -name $PROGRAM | tee -a /tmp/kinstall.$$
       else
          imkmf -type prog -name $PROGRAM | tee -a /tmp/kinstall.$$
       endif
    endif

    makemake

    if (! $SINGLE_SRC) then
       echo ""
       echo "Calling ksrcconf in directory $PROGPATH" | \
	   tee -a /tmp/kinstall.$$
       echo ""

       ksrcconf_csh $PROGPATH $MACH                             # ksrcconf

       echo ""
       echo "Calling kmakeall in directory $PROGPATH" | \
	   tee -a /tmp/kinstall.$$
       echo ""

       if ($USE_TOOLBOX) then
          kmakeall -toolbox $TOOLBOX install 
       else
          kmakeall install                                 # for KHOROS_HOME
       endif
    else
      echo ""
      echo "Calling make in directory $PROGPATH" | \
           tee -a /tmp/kinstall.$$
      echo ""
      make install | tee -a /tmp/kinstall.$$
    endif

    popd >& /dev/null                   # return to original directory

    echo ""
    echo ""
    echo "<<<<<<<<<<<<<<<<<<<   >>>>>>>>>>>>>>>>>>>"
    echo ""
    echo "Installation of $PROGRAM completed."
    echo ""
    echo "Please read mail to make sure that the"
    echo "Library and Driver were installed correctly"
    echo ""
    echo "<<<<<<<<<<<<<<<<<<<   >>>>>>>>>>>>>>>>>>>"
    echo ""
    echo ""

# mail to $KHOROS_HOME about new routine
#-----------------------------------------------------
    mail -s "kinstall $PROGRAM" $KHOROS_MAIL < /tmp/kinstall.$$
    \rm -f - /tmp/kinstall.$$

# End of kinstall script, finish by executing cleanup.


cleanup:
# cleanup by removing .kinstall.lock file and unsetting variables.
#------------------------------------------------------------------
    if ( -e $TEMPDIR/.kinstall.lock ) then
          /bin/rm -f $TEMPDIR/.kinstall.lock
    endif

unset KHOROS_USER
unset KHOROS_MACHINES
unset KHOROS_MACH_DIR
unset KHOROS_SRC_TOP
unset LOCAL_SRC_TOP

exit 0        # normal exit

