 /*
  * Khoros: $Id: lvgshot.c,v 1.2 1991/12/18 09:24:31 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvgshot.c,v 1.2 1991/12/18 09:24:31 dkhoros Exp $";
#endif

 /*
  * $Log: lvgshot.c,v $
 * Revision 1.2  1991/12/18  09:24:31  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvgshot.c
 >>>>
 >>>>      Program Name: vgshot
 >>>>
 >>>> Date Last Updated: Tue Dec 10 15:22:27 1991 
 >>>>
 >>>>          Routines: lvgshot - the library call for vgshot
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvgshot - library call for vgshot
*
* Purpose:
*    
*    Corrupts an image uniformly with spikes (noise).
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    percent        spikes percentage
*    
*    

* Output:
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Marcelo Teran, Ramiro Jordan
*    
*    

****************************************************************/


/* -library_def */
int
lvgshot(image,percent)
struct xvimage *image;
float percent;
/* -library_def_end */

/* -library_code */
{

    int    length, i;
    int    uniform, *ptr;
    float  urng();
    char   *malloc(), *program;
    unsigned char *cptr;

    program = "lvgshot";

    propertype(program,image,VFF_TYP_1_BYTE,1);       /* check img. type */

    length = image->row_size*image->col_size;
    uniform = (float)length*percent/100.0;

    ptr = (int *)malloc((unsigned int)uniform*sizeof(int));
    if(ptr == NULL) {
        (void) fprintf(stderr,"lvgshot: insufficient memory available\n");
        return(0);
    }

   /* generate the random sequence */
    for (i=0; i<uniform; i++) ptr[i]=length*urng();

   /* corrupt the image */
    cptr = (unsigned char *)image->imagedata;
    for (i=0; i<uniform; i++) cptr[ptr[i]] = 255;

    return(1);
}
/* -library_code_end */
