 /*
  * Khoros: $Id: vhmed.c,v 1.1 1991/05/10 15:48:19 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vhmed.c,v 1.1 1991/05/10 15:48:19 khoros Exp $";
#endif

 /*
  * $Log: vhmed.c,v $
 * Revision 1.1  1991/05/10  15:48:19  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhmed.c
 >>>>
 >>>>      Program Name: vhmed
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform median filtering on an image using  a  histogram  to
 >>>>	find the median.
 >>>>	
 >>>>	
 >>>>            Author: Marcelo Teran, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:29:33 1991
 >>>>
 >>>>          Routines: main- the main program for vhmed
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vhmed.h"


/****************************************************************
 *
 * Routine Name:  main program for vhmed
 *
 *       Input:  
 *       -i  input image filename 
 *       -o  output image filename 
 *       -w  window width argument   (1 < value < 32)
 *       -h  window height argument   (1 < value < 32)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vhmed->i_file);
    if (image == NULL){
        (void)fprintf(stderr,"vhmed: Image could not be read\n");
         exit(1);               /* Quit if bad image */
    }

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvhmed(image,vhmed->w_int,vhmed->h_int)){
        (void) fprintf(stderr, "lvhmed Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vhmed->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vhmed 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vhmed :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform median filtering on an image using  a  histogram  to\n");
	fprintf(stderr, "\tfind the median.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr,"\t-w  window width argument  (integer, 1 to 32)\n");
	fprintf(stderr,"\t-h  window height argument  (integer, 1 to 32)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vhmed\n");
	fprintf(stderr, "\t[-U] Gives the usage for vhmed\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vhmed.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vhmed.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vhmed
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) window width argument \n        {integer, 1 to 32}: "; 
char	*h_pstr = 
	"\nEnter: (h) window height argument \n        {integer, 1 to 32}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vhmed", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vhmed.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vhmed: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vhmed.ans");
		}

	     }

	}

	/*
	 * allocate the vhmed structure
	 */
	vhmed = (vhmed_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vhmed_struct));

	/*
	 * get required arguments for vhmed
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vhmed->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vhmed->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhmed->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vhmed->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vhmed->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhmed->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vhmed->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhmed->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vhmed->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vhmed->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhmed->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(vhmed->w_int),
			3, 1, 32)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhmed->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vhmed->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(vhmed->w_int),
		    3, 1, 32);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhmed->h_flag = vget_int(fid, prompt_flag,
			"-h", h_pstr, &(vhmed->h_int),
			3, 1, 32)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhmed->h_flag))
		{
		    fprintf(stderr, "\t\th is required, please re-enter: \n");
		    vhmed->h_flag = vget_int(fid, prompt_flag,
		    "-h", h_pstr, &(vhmed->h_int),
		    3, 1, 32);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-h' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



