 /*
  * Khoros: $Id: vggauss.h,v 1.2 1991/12/18 09:37:42 dkhoros Exp $
  */

 /*
  * $Log: vggauss.h,v $
 * Revision 1.2  1991/12/18  09:37:42  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vggauss.h
 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>> Date Last Updated: Tue Dec 10 15:19:54 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vggauss_h_
#define _vggauss_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vggauss Argument Structure
*
****************************************************************/

typedef struct _vggauss  {

/*
 *  resulting image (Required outfile)
 */
char	*o_file;	/* resulting image FILENAME */
int	 o_flag;	/* resulting image FLAG */

/*
 *  input file (Optional infile)
 */
char	*i_file;	/* input file FILENAME */
int	 i_flag;	/* input file FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  rows of image (Optional integer)
 */
int	 r_int; 	/* rows of image INT */
int	 r_flag;	/* rows of image FLAG */

/*
 *  columns of image (Optional integer)
 */
int	 c_int; 	/* columns of image INT */
int	 c_flag;	/* columns of image FLAG */

/*
 *  # bands in image (Optional integer)
 */
int	 b_int; 	/* # bands in image INT */
int	 b_flag;	/* # bands in image FLAG */

/*
 *  noise mean value (Optional float)
 */
float	 m_float;	/* noise mean value FLOAT */
int	 m_flag;   	/* noise mean value FLAG */

/*
 *  noise variance (Optional float)
 */
float	 v_float;	/* noise variance FLOAT */
int	 v_flag;   	/* noise variance FLAG */

/*
 * lets user choose data type of image (Optional string toggle - )
 */
char	*t_toggle;		/* lets user choose data type of image STRING TOGGLE */
int	 t_flag;		/* lets user choose data type of image FLAG */

}  vggauss_struct;

vggauss_struct *vggauss;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
image = readimage(vggauss->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "vggauss: Cannot read input image \n");  \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE))){ \
          fprintf(stderr,"%s: data storage type must be float or complex.",program); \
          exit(1); \
    }
#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); 

/* -include_macros_end */

#endif
