 /*
  * Khoros: $Id: vgpwl.h,v 1.3 1992/03/20 23:14:05 dkhoros Exp $
  */

 /*
  * $Log: vgpwl.h,v $
 * Revision 1.3  1992/03/20  23:14:05  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgpwl.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Thu Mar  5 08:28:28 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgpwl_h_
#define _vgpwl_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgpwl Argument Structure
*
****************************************************************/

typedef struct _vgpwl  {

/*
 *  resulting image (Required outfile)
 */
char	*o_file;	/* resulting image FILENAME */
int	 o_flag;	/* resulting image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  number of rows (Optional integer)
 */
int	 r_int; 	/* number of rows INT */
int	 r_flag;	/* number of rows FLAG */

/*
 *  number of columns (Optional integer)
 */
int	 c_int; 	/* number of columns INT */
int	 c_flag;	/* number of columns FLAG */

/*
 *  number of bands (Optional integer)
 */
int	 b_int; 	/* number of bands INT */
int	 b_flag;	/* number of bands FLAG */

/*
 *  sampling frequency (Optional float)
 */
float	 s_float;	/* sampling frequency FLOAT */
int	 s_flag;   	/* sampling frequency FLAG */

/*
 *  signal minimum (Optional float)
 */
float	 l_float;	/* signal minimum FLOAT */
int	 l_flag;   	/* signal minimum FLAG */

/*
 *  signal maximum (Optional float)
 */
float	 m_float;	/* signal maximum FLOAT */
int	 m_flag;   	/* signal maximum FLAG */

/*
 *  signal period in X-direction (Optional float)
 */
float	 xp_float;	/* signal period in X-direction FLOAT */
int	 xp_flag;   	/* signal period in X-direction FLAG */

/*
 *  signal period in Y-direction (Optional float)
 */
float	 yp_float;	/* signal period in Y-direction FLOAT */
int	 yp_flag;   	/* signal period in Y-direction FLAG */

/*
 *  rise time in X-direction (Optional float)
 */
float	 xr_float;	/* rise time in X-direction FLOAT */
int	 xr_flag;   	/* rise time in X-direction FLAG */

/*
 *  rise time in Y-direction  (Optional float)
 */
float	 yr_float;	/* rise time in Y-direction  FLOAT */
int	 yr_flag;   	/* rise time in Y-direction  FLAG */

/*
 *  fall time in X-direction  (Optional float)
 */
float	 xf_float;	/* fall time in X-direction  FLOAT */
int	 xf_flag;   	/* fall time in X-direction  FLAG */

/*
 *  fall time in Y-direction  (Optional float)
 */
float	 yf_float;	/* fall time in Y-direction  FLOAT */
int	 yf_flag;   	/* fall time in Y-direction  FLAG */

/*
 *  pulse width in X-direction  (Optional float)
 */
float	 xw_float;	/* pulse width in X-direction  FLOAT */
int	 xw_flag;   	/* pulse width in X-direction  FLAG */

/*
 *  pulse width in Y-direction  (Optional float)
 */
float	 yw_float;	/* pulse width in Y-direction  FLOAT */
int	 yw_flag;   	/* pulse width in Y-direction  FLAG */

/*
 * lets user choose data type of image (Optional string toggle - )
 */
char	*t_toggle;		/* lets user choose data type of image STRING TOGGLE */
int	 t_flag;		/* lets user choose data type of image FLAG */

}  vgpwl_struct;

vgpwl_struct *vgpwl;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
