 /*
  * Khoros: $Id: info.c,v 1.3 1992/03/20 22:43:13 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: info.c,v 1.3 1992/03/20 22:43:13 dkhoros Exp $";
#endif

 /*
  * $Log: info.c,v $
 * Revision 1.3  1992/03/20  22:43:13  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"

static void workspace_info();

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  workspace.c                           <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvl_workspace_info()		      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_workspace_info
*
*      Purpose:  This routine is used to show miscellaneous
*		 information about a workspace.  The type
*		 of information displayed is the number of
*		 glyph's in the workspace, the different type
*		 of glyphs.
*		 
*
*        Input:  workspace
*
*
*   Written By:  Mark Young
*
*************************************************************/


xvl_workspace_info(workspace)

Workspace *workspace;
{
	FILE	*file;
	char	*filename;
	int	glyphs, control, procedures, comment, command;


	glyphs  =
	control =
	comment =
	command =
	procedures = 0;
	workspace_info(workspace, &glyphs, &control, &procedures, &comment,
			&command);

	filename = xvl_tempnam("info.XXXXX", NULL, NULL);
	if (!(file = fopen(filename,"w")))
	{
	   free(filename);
	   return;
	}

	if (workspace == main_workspace)
	   fprintf(file,"\n\nWorkspace info for Main Cantata Workspace\n\n");
	else if (workspace->parent != NULL)
	   fprintf(file,"\n\nWorkspace info for '%s' Procedure\n\n",
			workspace->parent->label_str);

	fprintf(file,"Currently there are %3d procedures\n", procedures);
	fprintf(file,"Currently there are %3d standard glyphs\n", glyphs);
	fprintf(file,"Currently there are %3d control glyphs\n", control);
	fprintf(file,"Currently there are %3d comment glyphs\n", comment);
	fprintf(file,"Currently there are %3d command glyphs\n", command);
	fclose(file);
	xvl_help(filename, "Cantata Workspace Information", True);
	free(filename);
}

static void workspace_info(workspace, glyphs, control, procedures, comment,
		command)

Workspace *workspace;
int	  *glyphs, *control, *procedures, *comment, *command;
{
	Glyph	  *glyph;
	GlyphList *glyphlist;

	glyphlist = workspace->glyphs;
	while (glyphlist != NULL)
	{
	   glyph = glyphlist->glyph;
	   switch (glyph->type)
	   {
	      case GLYPH:
		   *glyphs += 1;
		   break;

	      case PROCEDURE:
		   *procedures += 1;
		   workspace_info(glyph->val.macro, glyphs, control, procedures,
				comment, command);
		   break;

	      case CONTROL:
		   *control += 1;
		   break;

	      case COMMENT:
		   *comment += 1;
		   break;

	      case COMMAND:
		   *command += 1;
		   break;
	   }
	   glyphlist = glyphlist->next;
	}
}
