 /*
  * Khoros: $Id: init_lines.c,v 1.1 1991/05/10 15:58:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: init_lines.c,v 1.1 1991/05/10 15:58:12 khoros Exp $";
#endif

 /*
  * $Log: init_lines.c,v $
 * Revision 1.1  1991/05/10  15:58:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "composer.h"

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: init_lines.c
 >>>>
 >>>>      Program Name: composer
 >>>> 
 >>>> Date Last Updated: Sat Jul  7 14:41:44 MDT 1990
 >>>>
 >>>>          Routines: init_lines()  initializes UI spec lines
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name:  init_lines()
*       Purpose:  Creates template lines and puts them into a character
*		  array.
*         Input:  none
*        Output:  line_template - a global 2d character array containing template
*		             lines.  Used whenver a new line is needed.
*
*     Called By:  main() in composer.c
*
********************************************************/

int
init_lines()
{
	int	i;
	for (i = 0; i < NUMBER_OF_TYPES; i++) line_template[i] = NULL;

line_template[StartForm] = xvf_strcpy("-F 4.2 1 0 170x7+10+20 +35+1 'CANTATA Visual Programming Environment for the KHOROS System' cantata");

line_template[StartSubForm] = xvf_strcpy("-M 1 1 100x40+10+20 +23+1 'This is a new subform.' subform1");

line_template[HelpSel] = xvf_strcpy("-H 1   13x2+39+13 'NEW HELP' 'documentation for vcommand' KHOROS_HOME/doc/manpages/vcommand.1");

line_template[QuitForm] = xvf_strcpy("-Q 1 0  7x2+11+13  'NEW QUIT'");

line_template[StartPane] = xvf_strcpy("-P 1 1 80x38+22+2 +0+0 'New Pane' new");

line_template[PaneAction] = xvf_strcpy("-a 1 0     20x2+10+1 'NEW ACTION' 'does action' action");

line_template[MutExcl] = xvf_strcpy("-C 1");

line_template[Toggle] = xvf_strcpy("-T 1 0 0 1 0 40x1+2+14 +0+0 1 'New Toggle' 'example' toggle");

line_template[InputFile] =  xvf_strcpy("-I 1 0 0 1 0 1 50x1+2+2 +0+0 'file_name' 'Input Image or File' 'input image or file' i");

line_template[OutputFile] = xvf_strcpy("-O 1 0 0 1 0 1 50x1+2+4 +0+0 'file_name' 'Output Image or File' 'resulting output image or file' o");

line_template[FloatOpt] = xvf_strcpy("-f 1 0 0 1 0 50x1+2+6 +0+0 -100.0 100.0 0.0 'New Float' 'the value of float' f");

line_template[IntegerOpt] = xvf_strcpy( "-i 1 0 0 1 0 50x1+2+8 +0+0 -100 100 0 'New Integer' 'the value of integer' v");

line_template[LogicOpt] = xvf_strcpy( "-l 1 0 0 1 0 50x1+2+10 +0+0 0  'New Logical' 'False' 'True' 'selects one or zero'  logical");

line_template[StringOpt] = xvf_strcpy( "-s 1 0 0 1 0 50x1+2+12 +0+0 'string' 'New String' 'first string' string");

line_template[Routine] = xvf_strcpy( "-R 1 0 1 13x2+1+13 'New Run' 'do operation' vcommand");

line_template[Blank] = xvf_strcpy( "-b +0+1 'A dummy text string for user info.'");
}



/********************************************************
*
*  Routine Name:  init_instructions()
*       Purpose:  Creates instruction lines and puts them into a character
*		  array for use in editing prog_spec.
*         Input:  none
*        Output:  prog_inst - a global 2d character array containing template
*		             lines.  Used whenver a new line is needed.
*
*     Called By:  main() in composer.c
*
********************************************************/

int
init_instructions()
{
	int	i;
	for (i = 0; i < MaxProgSpecSize; i++) prog_inst[i] = NULL;

/************************************
 *   Instruction strings for editing the program specification.
 *************************************/

prog_inst[Authors] = xvf_strcpy("Enter a list of authors on one line [T].");

prog_inst[ShortProgDesc] = xvf_strcpy("A short description of the purpose of the program [T].");

prog_inst[Man1LongDesc] = xvf_strcpy("A detailed description of the program for manual page [N].");

prog_inst[Man1Examples] = xvf_strcpy("Examples of how the program can be used [N].");

prog_inst[Man1Restrictions] = xvf_strcpy("Restrictions, limitations or know bugs in the program [N].");

prog_inst[Man1SeeAlso] = xvf_strcpy("Any other documentation that should be referenced to understand the operation of this program [N].");

prog_inst[UsageAdd] = xvf_strcpy("Additional statements to be printed as part of usage [C].");

prog_inst[IncludeIncludes] = xvf_strcpy("Additional includes for the include file [C].");

prog_inst[IncludeMacros] = xvf_strcpy("Macros for the main include file [C].");

prog_inst[MainVariables] = xvf_strcpy("List of variables to be declared in main() [C].");

prog_inst[LibraryMods] = xvf_strcpy("A short description of modifications made to the library code [N].");

prog_inst[ShortLibDesc] = xvf_strcpy("A short description of the purpose of the library routine [T].");

prog_inst[Man3LongDesc] = xvf_strcpy("A detailed description of the library for the manual page [N].");

prog_inst[Man3Restrictions] = xvf_strcpy("Restrictions, limitations or know bugs of the library routine [N].");

prog_inst[Man3SeeAlso] = xvf_strcpy("Any other documentation that would be a useful reference to understanding the library routine [N].");

prog_inst[IncludeAdd] = xvf_strcpy("Additional defines for the include file [C].");

prog_inst[MainBeforeLib] = xvf_strcpy("Code to appear in main() before lib call(s) [C].");

prog_inst[MainLibCall] = xvf_strcpy("Code used to invoke library call(s) [C].");

prog_inst[MainAfterLib] = xvf_strcpy("Code to appear in main() after library call(s) [C].");

prog_inst[LibraryInput] = xvf_strcpy("A short description of all inputs into the library function [N].");

prog_inst[LibraryOutput] = xvf_strcpy("A short description of all outputs from the library function [N].");

prog_inst[LibraryDef] = xvf_strcpy("The library function definition and declration [T].");

prog_inst[LibraryIncludes] = xvf_strcpy("Any #includes needed for library but not provided from vinclude.h [C].");

prog_inst[LibraryCode] = xvf_strcpy("The actual library function code [C].");

}
