/*
 *	Test FFT routines; cosine transform
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)testcos.cc	2.2	9/26/89
 */


#include "rw/DCosineFFT.h"
#include "rw/Timer.h"

extern Cdecl void exit(int);

static void
printVec(ostream& s, const DoubleVec& x);

main()
{
  // N must be even:
  const unsigned N = 12;
  cout <<"Testing DoubleCosineServer (Double Precision Cosine Server)\n\n";

  double twoN = 2*N;
  DoubleCosineServer 	server;

  // This will make half of a two period cosine wave;
  DoubleVec a2cos(cos(DoubleVec(N+1, 0, 4.0*M_PI/twoN)));
  DoubleVec a2sin(sin(DoubleVec(N-1, 4.0*M_PI/twoN, 4.0*M_PI/twoN)));
  a2cos += 1.0;

  cout <<"**************************************\n";
  cout <<"a2cos (one half of a two period cosine wave, plus 1.0):\n";
  printVec(cout,a2cos);
  cout <<"a2sin (one half of a two period sine wave):\n";
  printVec(cout,a2sin);

  cout <<"**************************************\n";
  cout <<"Checking cosine transform.\n";
  cout <<"\nTransform of a2cos:\n";
  DoubleVec a2cos_transform = server.cosine(a2cos)/twoN;
  printVec(cout, a2cos_transform);

  cout <<"\nChecking Parseval's theorem for cosine transform.\n";
  cout <<"Original variance: "<<variance(expandEven(a2cos))<<NL;

  // expand to full series:
  double var = spectralVariance(expandEven(a2cos_transform));
  cout <<"Spectral variance: "<<var<<NL;

  cout <<"\nChecking Nyquist for cosine transform.\n";
  DoubleVec Nyquist(N+1,1.0);
  Nyquist.slice(1,(N+1)/2,2) = -1.0;
  cout <<"Original sequence:\n";
  printVec(cout, Nyquist);
  cout <<"Its transform:\n";
  DoubleVec Nyquist_transform = server.cosine(Nyquist)/twoN;
  printVec(cout, Nyquist_transform);
  
  cout <<"**************************************\n";
  cout <<"Checking sine transform.\n";
  cout <<"\nTransform of a2sin:\n";
  DoubleVec a2sin_transform = server.sine(a2sin)/twoN;
  printVec(cout, a2sin_transform);

  cout <<"\nChecking Parseval's theorem for sine transform.\n";
  cout <<"Original variance: "<<variance(expandOdd(a2sin))<<NL;

  // expand to full series:
  var = spectralVariance(expandOdd(a2sin_transform));
  cout <<"Spectral variance: "<<var<<NL;
  exit(0);
}

// Use special functions to print vectors, to round the output
// to a fixed point number, so that differences at the machine
// precision won't be seen.

static void
printVec(ostream& s, const DoubleVec& x)
{
  for(int i = 0; i<x.length(); i++){
    if(!(i%5) && i) s<<"\n";
    s << form("%8.5f",x(i)) << " ";
  }
  s<<"\n";
}
