struct INTEGDATA
  {
    REAL *integPointX, *integPointY, *integWeight;
	REAL **shape, **shapeX, **shapeY,
		 **shapeXX, **shapeXY, **shapeYY;
	int noOfIPoints, noOfShapeFunc, symP;
  };
typedef struct INTEGDATA INTEGDATA;

struct PROBLEM
  {
   	char		*name;
	PROC		F;
	REAL		*fVals;
	int		noFVals;
	PROC		CauchyF;
	REAL		*cauVals;
	int		noCauVals;
	PROC		DirichF;
	REAL		*dirVals;
	int		noDirVals;
	PROC		Sol;
	REAL		*solVals;
	int		noSolVals;
	PROC		NumAss;
	int		class;
	int		symP;
	struct PROBLEM	*next;
  };
typedef struct PROBLEM PROBLEM; 

#define BANKIP 1
#define LINIP 2
#define QUADIP 3
#define USERIP 4
#define QUSERIP 5

#define N_STD 0
#define N_LL 1
#define N_LQ 2
#define N_QL 3
#define N_QQ 4
#define N_QUAD 5
#define N_EL 6
#define N_EQ 7

#define SYMMETRIC	1
#define DIAGONAL	2
#define FULL		0

#define P_STIFF 0
#define P_RHS 1
#define P_ALL 2

extern int Assemble();
extern void SetBound();
extern int axMul();
extern int ILUaxMul();
extern void SetBoundZero();
extern int MulD();
extern void pcxMul();
extern void bpxPcxMul();
extern int AssRSide();
extern int assign();
extern void assneg();
extern void lin();
extern void linneg();
extern void sub();
extern REAL scalprod();
extern void StoreVecToField();
extern void SetZeroField();
extern REAL CompRes();
extern REAL CompResExtrapol();
extern int InitNumAss();
extern int NumAss();
extern int eNormInt();
extern int PrStiff();
extern void StdShape();
extern void StdQShape();
extern int CompShapeVals();
extern int UpdateIData();
extern INTEGDATA *NewIData();
extern REAL **ExpMatFull();
extern REAL *ExpVecFull();
extern void Set0MatFull();
extern void Set0VecFull();
extern void PrintMatFull();
extern void PrintVecFull();
extern void Lev0DirectSol();

extern int SelInteg();
extern int TestInteg();
extern int SetInteg();

extern REAL **assA, *assB, **assAG, **assAL, *assBG;
extern INTEGDATA *stdIData, *qStdIData, *lStdIData;
extern userNoIP;
extern int partP, noOfIPoints, noOfShapeFunc,
	   iFrom, iTo, kFrom, kTo, symP, curAss;
extern PROBLEM *actProblem;
extern REAL totalTime, dirTime, estiTime;
extern REAL refTime, assTime, iteTime, numTime;
extern REAL eNormU, eNormUUl;
