/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include "kask.h"
#include "kaskass.h"
#include "kaskcmd.h"

#define SIXTH 0.166666666666666
#define THIRD 0.333333333333333
#define TWOTHIRD 0.666666666666666
#define REZSQRT3 0.577350269
 
/*
    Integration points and weights
*/
static REAL BankIPX[] = { SIXTH, TWOTHIRD, SIXTH };
static REAL BankIPY[] = { SIXTH, SIXTH, TWOTHIRD };
static REAL BankIW[] = { SIXTH, SIXTH, SIXTH };

static REAL linIPX[] = { THIRD };
static REAL linIPY[] = { THIRD };
static REAL linIW[]  = { HALF };

static REAL quadIPX[] = { HALF, HALF, ZERO };
static REAL quadIPY[] = { ZERO, HALF, HALF };
static REAL quadIW[] = { SIXTH, SIXTH, SIXTH };

static REAL userIPX[] = { 3.333333333333333e-01, 4.701420641051151e-01,
						  5.971587178976981e-02, 4.701420641051151e-01,
 						  1.012865073234563e-01, 7.974269853530872e-01,
 						  1.012865073234563e-01 };
static REAL userIPY[] = { 3.333333333333333e-01, 4.701420641051151e-01,
						  4.701420641051151e-01, 5.971587178976981e-02, 
						  1.012865073234563e-01, 1.012865073234563e-01,
						  7.974269853530872e-01 };
static REAL userIW[]  = { 0.1125, 6.619707639425308e-02, 6.619707639425308e-02,
						  6.619707639425308e-02, 6.296959027241358e-02,
						  6.296959027241358e-02, 6.296959027241358e-02 };
int userNoIP = 7;

REAL **assA = nil, *assB = nil, **assAG = nil, **assAL = nil,
	 *assBG = nil;
 
/*
    Values of shape functions
	
        phi[1]=1-x-y; phi[2|=x; phi[3]=y;
		qPhi[1]=phi[1](2phi[1]-1);
		qPhi[2]=phi[2](2phi[2]-1);
		qPhi[3]=phi[3](2phi[3]-1);
		qPhi[4]=4phi[2]phi[3];
		qPhi[5]=4phi[1]phi[3];
		qPhi[6]=4phi[1]phi[2];
		
    at the integration points [Axelsson, Barker p.174, 177]
*/

void StdShape(x,y,no,f,fx,fy,fxx,fxy,fyy)
  REAL x, y, *f, *fx, *fy, *fxx, *fxy, *fyy;
  int no;
  {
    switch (no)
	{
	  case 0:				/* 1-x-y */
	  	*f	 = ONE-x-y;
		*fx	 = -ONE;
		*fy	 = -ONE;
		*fxx = ZERO;
		*fxy = ZERO;
		*fyy = ZERO;
		break;
	  case 1:				/* x */
	    *f	 = x;
		*fx  = ONE;
		*fy  = ZERO;
		*fxx = ZERO;
		*fxy = ZERO;
		*fyy = ZERO;
		break;
	  case 2:				/* y */
	    *f   = y;
		*fx  = ZERO;
		*fy  = ONE;
		*fxx = ZERO;
		*fxy = ZERO;
		*fyy = ZERO;
		break;
	  case 3:				/* 4xy */
	    *f   = FOUR*x*y;
		*fx  = FOUR*y;
		*fy  = FOUR*x;
		*fxx = ZERO;
		*fxy = FOUR;
		*fyy = ZERO;
		break;
	  case 4:				/* 4y(1-x-y) */
	    *f   = FOUR*y*(ONE-x-y);
		*fx  = -FOUR*y;
		*fy  = FOUR*(1-x-TWO*y);
		*fxx = -FOUR;
		*fxy = -FOUR;
		*fyy = -EIGHT;
		break;
	  case 5:				/* 4x(1-x-y) */
	    *f   = FOUR*x*(ONE-x-y);
		*fx  = FOUR*(1-TWO*x-y);
		*fy  = -FOUR*x;
		*fxx = -EIGHT;
		*fxy = -FOUR;
		*fyy = -FOUR;
		break;
	}
	return;
  }

void StdQShape(x,y,no,f,fx,fy,fxx,fxy,fyy)
  REAL x, y, *f, *fx, *fy, *fxx, *fxy, *fyy;
  int no;
  {
    switch (no)
	{
	  case 0:				/* 2(1-x-y)(1/2-x-y) */	
	    *f   = TWO*(ONE-x-y)*(HALF-x-y);
		*fx  = FOUR*(x+y)-THREE;
		*fy  = FOUR*(x+y)-THREE;
		*fxx = FOUR;
		*fxy = FOUR;
		*fyy = FOUR;
		break;
	  case 1:				/* x(2x-1) */
	    *f   = x*(TWO*x-ONE);
		*fx  = FOUR*x-ONE;
		*fy  = ZERO;
		*fxx = FOUR;
		*fxy = ZERO;
		*fyy = ZERO;
		break;
	  case 2:				/* y(2y-1) */
	    *f   = y*(TWO*y-ONE);
		*fx  = ZERO;
		*fy  = FOUR*y-ONE;
		*fxx = ZERO;
		*fxy = ZERO;
		*fyy = FOUR;
		break;
	  case 3:				/* 4xy */
	    *f   = FOUR*x*y;
		*fx  = FOUR*y;
		*fy  = FOUR*x;
		*fxx = ZERO;
		*fxy = FOUR;
		*fyy = ZERO;
		break;
	  case 4:				/* 4y(1-x-y) */
	    *f   = FOUR*y*(ONE-x-y);
		*fx  = -FOUR*y;
		*fy  = FOUR*(1-x-TWO*y);
		*fxx = ZERO;
		*fxy = -FOUR;
		*fyy = -EIGHT;
		break;
	  case 5:				/* 4x(1-x-y) */
	    *f   = FOUR*x*(ONE-x-y);
		*fx  = FOUR*(1-TWO*x-y);
		*fy  = -FOUR*x;
		*fxx = -EIGHT;
		*fxy = -FOUR;
		*fyy = ZERO;
		break;
	}
	return;
  }

int CompShapeVals(iData,ShapeF)
  INTEGDATA *iData;
  VOIDPROC ShapeF;
  {
    int noIP = iData->noOfIPoints, noSF = iData->noOfShapeFunc;
	int i, k;
	long lng;
	REAL **buffer, *buf;
	if (assAG==nil) assAG = ExpMatFull(assAG, 0, 6, false);
	if (assBG==nil) assBG = ExpVecFull(assBG, 0, 6);
	if (assAL==nil) assAL = ExpMatFull(assAL, 0, 6, false);
	assA = assAG;
	assB = assBG;

	lng = 6*((noIP*noSF)*sizeof(REAL)+noSF*sizeof(REAL*));

	buffer = (REAL**) ZIBAlloc(lng);
	if (buffer==nil)
	  {
	    ZIBStdOut("Assemble: not enough memory (CompShapeVals)\n");
		return false;
	  }

	iData->shape   = buffer; buffer += noSF;
	iData->shapeX  = buffer; buffer += noSF;
	iData->shapeY  = buffer; buffer += noSF;
	iData->shapeXX = buffer; buffer += noSF;
	iData->shapeXY = buffer; buffer += noSF;
	iData->shapeYY = buffer; buf = (REAL*)(buffer+noSF);
	for (k = 0; k<noSF; k++)
	  {
	    (iData->shape)[k]   = buf; buf += noIP;
	    (iData->shapeX)[k]  = buf; buf += noIP;
	    (iData->shapeY)[k]  = buf; buf += noIP;
	    (iData->shapeXX)[k] = buf; buf += noIP;
	    (iData->shapeXY)[k] = buf; buf += noIP;
	    (iData->shapeYY)[k] = buf; buf += noIP;
		for (i = 0; i<noIP; i++)
		    (*ShapeF)((iData->integPointX)[i],
		              (iData->integPointY)[i],
					  k,
					  &((iData->shape)[k][i]),
					  &((iData->shapeX)[k][i]),
					  &((iData->shapeY)[k][i]),
					  &((iData->shapeXX)[k][i]),
					  &((iData->shapeXY)[k][i]),
					  &((iData->shapeYY)[k][i])
					 );
	  }
	return true;
  }

int UpdateIData(iData, iFormula, SF, ShapeF, symP)
  INTEGDATA *iData;
  int iFormula, SF, symP;
  VOIDPROC ShapeF;
  {
	switch (iFormula)
	{
	  case BANKIP:
		iData->integPointX = BankIPX;
		iData->integPointY = BankIPY;
		iData->integWeight = BankIW;
		iData->noOfIPoints = 3;
		break;
	  case LINIP:
		iData->integPointX = linIPX;
		iData->integPointY = linIPY;
		iData->integWeight = linIW;
		iData->noOfIPoints = 1;
		break;
	  case QUADIP:
		iData->integPointX = quadIPX;
		iData->integPointY = quadIPY;
		iData->integWeight = quadIW;
		iData->noOfIPoints = 3;
		break;
	  case USERIP:
		iData->integPointX = userIPX;
		iData->integPointY = userIPY;
		iData->integWeight = userIW;
		iData->noOfIPoints = 7;
		break;
	  default:
	    sprintf(globBuf, "Assemble: integration formula %d not known\n",
				iFormula);
		ZIBStdOut(globBuf);
		ZIBFree((PTR)iData);
		return false;
	}
	iData->symP = symP;
	iData->noOfShapeFunc = SF;
	CompShapeVals(iData, ShapeF);
	return true;
  }

INTEGDATA *NewIData(iFormula, SF, ShapeF, symP)
  int iFormula, SF, symP;
  VOIDPROC ShapeF;
  {
    INTEGDATA *iData;

	iData = (INTEGDATA*)ZIBAlloc((long)sizeof(INTEGDATA));
	if (iData==nil)
	  { ZIBStdOut("Assemble: not enough memory (NewIData)\n"); return nil; }

	UpdateIData(iData, iFormula, SF, ShapeF, symP);
	return iData;
  }
