#############################################################################
##
#A  Matrix Group and G-module library                   Derek Holt
#A                                                      Charles Leedham-Green
#A                                                      Eamonn O'Brien
#A                                                      Sarah Rees 
##
#A  @(#)$Id$
##
#Y  Copyright 1994 -- School of Mathematical Sciences, ANU   
##
#H  $Log$
##
#dualmod.g
#
###############################################################################
##
#F  DualGMod( module ) . . . . . dual of a G-module
##
## Dual computes the dual of the module m1. This is done simply by
## transposing and inverting the matrices
DualGMod := function( module )
    local i, mats, dmats, dmodule, F; 

   F := FieldFlag(module);
   mats := MatricesFlag(module);
   dmats := [];
   for i in [1..Length(mats)] do
     dmats[i] := TransposedMat(mats[i]^-1);
   od;
   dmodule := GModule(dmats,F);

   return dmodule;
end;
