#############################################################################
##
#A  Matrix Group and G-module library                   Derek Holt
#A                                                      Charles Leedham-Green
#A                                                      Eamonn O'Brien
#A                                                      Sarah Rees 
##
#A  @(#)$Id$
##
#Y  Copyright 1994 -- School of Mathematical Sciences, ANU   
##
#H  $Log$
##
#############################################################################
##
#F RandomElMatGp(matrices) . . Find a random element of the matrix group
##
RandomElMatGp := function( matrices )
    local len,M,i,j,ngens;
    ngens := Length(matrices);
    len := Random([5..10]);
    M := matrices[Random([1..ngens])];
    for i in [1..len] do 
      j := Random([1..ngens]);
      M := M*matrices[j];
    od;
    return M;
end;

#########################Y####################################################
##
#F RandomConj(matrices,smatrices) . . .
##
## Returns a random conjugate of a random element of smatrices by a random
## element of the group generated by matrices.
## Won't work if smatrices is empty.
RandomConj := function(matrices,smatrices )
   local X,M;
  
   M := smatrices[Random([1..Length(smatrices)])];
   X := RandomElMatGp(matrices);
   return X^-1*M*X;
end;

#########################Y####################################################
##
#F AddRandomConj(matrices,smatrices) . . .
##
## Adds a random conjugate of a random element of smatrices by a random
## element of the group generated by matrices to the list smatrices.
## Won't work if smatrices is empty.
AddRandomConj := function(matrices,smatrices )
   local X,M;

   M := smatrices[Random([1..Length(smatrices)])];
   X := RandomElMatGp(matrices);
   Add(smatrices,X^-1*M*X);
end;

#########################Y####################################################
##
#F AddRandomTranslatingConj(matrices,smatrices,W,F) . . .
##
## Adds a random conjugate of a random element of smatrices by a random
## element of the group generated by matrices to the list smatrices, that doesn't fix
## the subspace W.
## Won't work if smatrices is empty.
AddRandomTranslatingConj := function(matrices,smatrices,W,F )
   local dimW,g;

  dimW := Length(W);
  repeat g := RandomConj(matrices,smatrices);
  until Length(Base(RowSpace(Concatenation(W,W*g),F)))>dimW;
  Add(smatrices,g);
end;

#############################################################################
##
#F Commutators(matrices) . . .
##
Commutators := function(matrices)
   local matrices,S,i,j,k,l,one,g,ident; 

   S := [];
   k := Length(matrices);
   one := Field(Flat(matrices)).one;
   ident := IdentityMat(Length(matrices[1]),one);
   for i in [1..k] do
     for j in [i+1..k] do
       g := Comm(matrices[i],matrices[j]);
       if g <> ident then 
         Add(S,g); 
       fi;
     od;
   od;
   return Set(S);
end;
