/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)rshd.c	5.12 (Berkeley) 9/12/88";
#endif /* not lint */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


/*
 * remote shell server:
 *	remuser\0
 *	locuser\0
 *	command\0
 *	data
 */
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/time.h>

#include <netinet/in.h>

#include <arpa/inet.h>

#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <netdb.h>
#include <syslog.h>

#include "gssapi_defs.h"

#define TOKEN_MAJIC_NUMBER_BYTE0    1
#define TOKEN_MAJIC_NUMBER_BYTE1    1

char userfullname[GSS_C_MAX_PRINTABLE_NAME];
char userlocalname[GSS_C_MAX_PRINTABLE_NAME];
gss_cred_id_t gss_delegated_cred_handle;
gss_ctx_id_t     context_handle;

int	errno;
char	*index(), *rindex(), *strncat();
/*VARARGS1*/
int	error();

/*ARGSUSED*/
main(argc, argv)
	int argc;
	char **argv;
{
#if defined(BSD) && BSD >= 43
	struct linger linger;
#endif
	int on = 1, fromlen;
	struct sockaddr_in from;

#ifdef LOG_ODELAY /* 4.2 syslog */
	openlog("rsh", LOG_PID | LOG_ODELAY, LOG_DAEMON);
#endif /* 4.2 syslog */
	fromlen = sizeof (from);
	if (getpeername(0, (struct sockaddr *)&from, &fromlen) < 0) {
		fprintf(stderr, "%s: ", argv[0]);
		perror("getpeername");
		_exit(1);
	}
	if (setsockopt(0, SOL_SOCKET, SO_KEEPALIVE, (char *)&on,
	    sizeof (on)) < 0)
		syslog(LOG_WARNING, "setsockopt (SO_KEEPALIVE): %m");
#if defined(BSD) && BSD >= 43
	linger.l_onoff = 1;
	linger.l_linger = 60;			/* XXX */
	if (setsockopt(0, SOL_SOCKET, SO_LINGER, (char *)&linger,
	    sizeof (linger)) < 0)
		syslog(LOG_WARNING, "setsockopt (SO_LINGER): %m");
#endif
	doit(dup(0), &from);
}

char	username[20] = "USER=";
char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	*envinit[] =
	    {homedir, shell, "PATH=:/usr/ucb:/bin:/usr/bin", username, 0};
extern char	**environ;

doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	char cmdbuf[NCARGS+1], *cp;
	char locuser[16], remuser[16];
	struct passwd *pwd;
	int s;
	struct hostent *hp;
	char *hostname;
	short port;
	int pv[2], pid, cc, xcc, c;
	long ready, readfrom;
	char buf[BUFSIZ], sig;
	int one = 1;
	int tokenlen, j, i;
	unsigned char  token[GSS_C_MAX_TOKEN];
	char targ_printable[GSS_C_MAX_PRINTABLE_NAME];
	unsigned char  tokenheader[4], send_tokenheader[4];
	char           lhostname[GSS_C_MAX_PRINTABLE_NAME];
	char myhost[40], fromhost[40];
/*
 * GSS API support
 */
	gss_OID_set   actual_mechs;
	gss_OID       actual_mech_type;
	int           major_status, status, msg_ctx = 0, new_status;
	int           ret_flags = 0, lifetime_rec;
	gss_cred_id_t gss_cred_handle;
	gss_buffer_desc  output_token, input_token, input_name_buffer;
	gss_buffer_desc  status_string;
	gss_name_t    desired_targname, src_name;
	gss_channel_bindings   input_chan_bindings;

	(void) signal(SIGINT, SIG_DFL);
	(void) signal(SIGQUIT, SIG_DFL);
	(void) signal(SIGTERM, SIG_DFL);
#ifdef DEBUG
	{ int t = open("/dev/tty", 2);
	  if (t >= 0) {
		ioctl(t, TIOCNOTTY, (char *)0);
		(void) close(t);
	  }
	}
#endif
	fromp->sin_port = ntohs((u_short)fromp->sin_port);
	if (fromp->sin_family != AF_INET) {
		syslog(LOG_ERR, "malformed from address\n");
		exit(1);
	}
	if (fromp->sin_port < IPPORT_RESERVED) {
		syslog(LOG_NOTICE, "connection from bad port, (%d < %d)", fromp->sin_port, IPPORT_RESERVED);
		exit(1);
	}
	(void) alarm(60);
	port = 0;
	for (;;) {
		char c;
		if ((cc = read(f, &c, 1)) != 1) {
			if (cc < 0)
				syslog(LOG_NOTICE, "read: %m");
			shutdown(f, 1+1);
			exit(1);
		}
		if (c == 0)
			break;
		port = port * 10 + c - '0';
	}
	(void) alarm(0);
	if (port != 0) {
		int lport = IPPORT_RESERVED - 1;
		s = rresvport(&lport);
		if (s < 0) {
			syslog(LOG_ERR, "can't get stderr port: %m");
			exit(1);
		}
		if (port < IPPORT_RESERVED) {
			syslog(LOG_ERR, "2nd port not reserved\n");
			exit(1);
		}
		fromp->sin_port = htons((u_short)port);
		if (connect(s, (struct sockaddr *)fromp, sizeof (*fromp)) < 0) {
			exit(1);
		}
	}

	dup2(f, 0);
	dup2(f, 1);
	dup2(f, 2);

	hp = gethostbyaddr((char *)&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);

	bzero(fromhost, sizeof(fromhost));
	if (hp) {
	  strcpy(fromhost, hp->h_name);
	} else {
	  strcpy(fromhost, inet_ntoa(fromp->sin_addr));
	}

	gethostname(lhostname, sizeof(lhostname));

	strcpy(targ_printable, "SERVICE:rcmd@");
	strcat(targ_printable, lhostname);

	input_name_buffer.length = strlen(targ_printable);
	input_name_buffer.value = targ_printable;

	major_status = gss_import_name(&status,
				       &input_name_buffer,
				       GSS_C_NULL_OID,
				       &desired_targname);

	if (major_status != GSS_S_COMPLETE) {
	  xcc = write(0, "AuthentError", 12);
	  if (xcc <= 0)

	  gss_display_status(&new_status,
			     status,
			     GSS_C_MECH_CODE,
			     GSS_C_NULL_OID,
			     &msg_ctx,
			     &status_string);
	  fprintf(stderr, "%s - ", status_string.value);
	  return(0);
	}

	major_status = gss_acquire_cred(&status,
					desired_targname,
					0,
					GSS_C_NULL_OID_SET,
					GSS_C_ACCEPT,
					&gss_cred_handle,
					&actual_mechs,
					&lifetime_rec);

	major_status = gss_release_name(&status, desired_targname);

	if (major_status != GSS_S_COMPLETE) {
	  xcc = write(0, "AuthentError", 12);
	  if (xcc <= 0)

	  gss_display_status(&new_status,
			     status,
			     GSS_C_MECH_CODE,
			     GSS_C_NULL_OID,
			     &msg_ctx,
			     &status_string);
	  fprintf(stderr, "%s - ", status_string.value);
	  return(0);
	}

	if (pwd != NULL) seteuid(pwd->pw_uid);

	{
	  char *address;
	  int  from_addr=0, to_addr=0;
	  struct hostent *my_hp, *from_hp;
	  struct sockaddr_in sin, sin2;

	  from_hp=gethostbyname(fromhost);
	  if (from_hp != 0) {
#ifdef sun
	    bcopy(from_hp->h_addr, (caddr_t)&sin.sin_addr, from_hp->h_length);
#else
	    bcopy(from_hp->h_addr_list[0],
		  (caddr_t)&sin.sin_addr, from_hp->h_length);
#endif
#ifdef ultrix
	    from_addr = sin.sin_addr.S_un.S_addr;
#else
	    from_addr = sin.sin_addr.s_addr;
#endif
	  } else {
	    from_addr = inet_addr(hostname);
	  }
	  from_addr = htonl(from_addr);
	  gethostname(myhost, sizeof(myhost));
	  my_hp=gethostbyname(myhost);
	  if (my_hp != 0) {
#ifdef sun
	    bcopy(my_hp->h_addr, (caddr_t)&sin2.sin_addr, my_hp->h_length);
#else
	    bcopy(my_hp->h_addr_list[0],
		  (caddr_t)&sin2.sin_addr, my_hp->h_length);
#endif
#ifdef ultrix
	    to_addr = sin2.sin_addr.S_un.S_addr;
#else
	    to_addr = sin2.sin_addr.s_addr;
#endif
	    to_addr = htonl(to_addr);
	  }

	  input_chan_bindings = (gss_channel_bindings)
	    malloc(sizeof(gss_channel_bindings_desc));

	  input_chan_bindings->initiator_addrtype = GSS_C_AF_INET;
	  input_chan_bindings->initiator_address.length = 4;
	  address = (char *) malloc(4);
	  input_chan_bindings->initiator_address.value = (char *) address;
	  address[0] = ((from_addr & 0xff000000) >> 24);
	  address[1] = ((from_addr & 0xff0000) >> 16);
	  address[2] = ((from_addr & 0xff00) >> 8);
	  address[3] = (from_addr & 0xff);
	  input_chan_bindings->acceptor_addrtype = GSS_C_AF_INET;
	  input_chan_bindings->acceptor_address.length = 4;
	  address = (char *) malloc(4);
	  input_chan_bindings->acceptor_address.value = (char *) address;
	  address[0] = ((to_addr & 0xff000000) >> 24);
	  address[1] = ((to_addr & 0xff0000) >> 16);
	  address[2] = ((to_addr & 0xff00) >> 8);
	  address[3] = (to_addr & 0xff);
	  input_chan_bindings->application_data.length = 0;
	}

	if ((j=local_net_read(0, tokenheader, 4)) != 4) {
	  for (i=0;i<j;i++) {
	  }
	  exit(0);
	}
	if ((tokenheader[0] != TOKEN_MAJIC_NUMBER_BYTE0) &&
	    (tokenheader[1] != TOKEN_MAJIC_NUMBER_BYTE1)) {
	  exit(0);
	}
	tokenlen = tokenheader[2] * 256 + tokenheader[3];

	if (tokenlen > sizeof(token)) {
	  exit(0);
	}

	j = local_net_read(0, token, tokenlen);
	if (j != tokenlen)
	  syslog(LOG_INFO,"%d = read(0, token, %d)",j, tokenlen);

	input_token.length = tokenlen;
	input_token.value = (char *) token;

	major_status = gss_accept_sec_context(&status,
					      &context_handle,
					      gss_cred_handle,
					      &input_token,
					      input_chan_bindings,
					      &src_name,
					      &actual_mech_type,
					      &output_token,
					      &ret_flags,
					      &lifetime_rec,
					      &gss_delegated_cred_handle);

	if ((major_status != GSS_S_COMPLETE) &&
            (major_status != GSS_S_CONTINUE_NEEDED)) {
          syslog(LOG_INFO, "got error on accept - %d", status);
          gss_display_status(&new_status,
                             status,
                             GSS_C_MECH_CODE,
                             GSS_C_NULL_OID,
                             &msg_ctx,
                             &status_string);
	  fprintf(stderr, "%s - ", status_string.value);
          return(-1);
        }

	
	if (output_token.length != 0) {
	  send_tokenheader[0] = TOKEN_MAJIC_NUMBER_BYTE0;
	  send_tokenheader[1] = TOKEN_MAJIC_NUMBER_BYTE1;
	  send_tokenheader[2] = ((output_token.length & 0xff00) >> 8);
	  send_tokenheader[3] = (output_token.length & 0xff);

	  xcc = write(0, (char *) send_tokenheader, 4);
	  if (xcc != 4)
	    syslog(LOG_INFO, "write(0, send_tokenheader, 4): %m");

	  xcc = write(0, (char *) output_token.value, output_token.length);
	  if (xcc <= 0)
	    syslog(LOG_INFO, "write(0, resp, %d): %m",output_token.length);
	}

	while (major_status == GSS_S_CONTINUE_NEEDED) {
	  j = local_net_read(0, tokenheader, 4);
	  if (j != 4)
	    syslog(LOG_INFO,"%d = read(0, token, 4)", j);

	  if ((tokenheader[0] != TOKEN_MAJIC_NUMBER_BYTE0) || (tokenheader[1] != TOKEN_MAJIC_NUMBER_BYTE1)) {
	    exit(0);
	  }
	  tokenlen = tokenheader[2] * 256 + (unsigned char) tokenheader[3];

	  if (tokenlen > sizeof(token)) {
	    syslog(LOG_INFO, "token is too large, size is %d, buffer size is %d", tokenlen, sizeof(token));
	    exit(0);
	  }

	  j = local_net_read(0, token, tokenlen);
	  if (j != tokenlen)
	    syslog(LOG_INFO,"%d = read(0, token, %d)",j, tokenlen);


	  input_token.length = tokenlen;
	  input_token.value = (char *) token;

	  major_status = gss_accept_sec_context(&status,
						&context_handle,
						gss_cred_handle,
						&input_token,
						input_chan_bindings,
						&src_name,
						&actual_mech_type,
						&output_token,
						&ret_flags,
						&lifetime_rec,
						&gss_delegated_cred_handle);

	  if ((major_status != GSS_S_COMPLETE) &&
	      (major_status != GSS_S_CONTINUE_NEEDED)) {
	    syslog(LOG_INFO, "got error on subsequent accept - %d", status);
	    gss_display_status(&new_status,
			       status,
			       GSS_C_MECH_CODE,
			       GSS_C_NULL_OID,
			       &msg_ctx,
			       &status_string);
	    fprintf(stderr, "%s - ", status_string.value);
	    return(-1);
	  }

	  if (output_token.length != 0) {

	    send_tokenheader[0] = TOKEN_MAJIC_NUMBER_BYTE0;
	    send_tokenheader[1] = TOKEN_MAJIC_NUMBER_BYTE1;
	    send_tokenheader[2] = ((output_token.length & 0xff00) >> 8);
	    send_tokenheader[3] = (output_token.length & 0xff);

	    xcc = write(0, (char *) send_tokenheader, 4);
	    if (xcc != 4)
	      syslog(LOG_INFO, "%d = write(0, send_tokenheader, 4): %m", xcc);

	    xcc = write(0, (char *) output_token.value, output_token.length);
	    if (xcc <= 0)
	      syslog(LOG_INFO, "%d = write(0, resp, %d): %m", xcc, output_token.length);

	    if (xcc < 0) {
	      syslog(LOG_INFO, "error in write(0, ...)");
	      return(-1);
	    }
	  }
	}

	getstr(remuser, sizeof(remuser), "remuser");
	getstr(locuser, sizeof(locuser), "locuser");
	getstr(cmdbuf, sizeof(cmdbuf), "command");
	c = 0;
	write(0, &c, 1);

	setpwent();
	pwd = getpwnam(locuser);
	if (pwd == NULL) {
	  syslog(LOG_INFO,"passwd entry for '%s' is NULL",locuser);
	}
	endpwent();

	if (pwd == NULL) {
	  fprintf(stderr, "SPX : user account '%s' doesn't exist -  ", locuser);
	  return(-1);
	}
	if (getuid()) {
	        syslog(LOG_INFO,"getuid() is 0, so return nouser");
		return(0);
	}

#ifdef SPX_CHALLENGE
	/*
	 * if trying to login to root account, then we need to verify response
	 * proving that the user is interactive.
	 *
	 */
	if (strcmp(locuser, "root")==0) {
	  j = local_net_read(0, tokenheader, 4);
	  if (j != 4)
	    syslog(LOG_INFO,"%d = read(0, token, 4)",j);

	  if ((tokenheader[0] != TOKEN_MAJIC_NUMBER_BYTE0) || (tokenheader[1] != TOKEN_MAJIC_NUMBER_BYTE1)) {
	    exit(0);
	  }
	  tokenlen = tokenheader[2] * 256 + tokenheader[3];
	  if (tokenlen > sizeof(token)) {
	     syslog(LOG_INFO, "token too large, %d/%d",tokenlen,sizeof(token));
	    exit(0);
	  }

	  j = local_net_read(0, token, tokenlen);
	  if (j != tokenlen)
	    syslog(LOG_INFO,"%d = read(0, token, %d)",j, tokenlen);
	  major_status = spx_verify_response(&status,
					     context_handle,
					     gss_cred_handle,
					     token,
					     tokenlen);
	  if (major_status != GSS_S_COMPLETE) {
	    gss_display_status(&new_status,
			       status,
			       GSS_C_MECH_CODE,
			       GSS_C_NULL_OID,
			       &msg_ctx,
			       &status_string);
	    fprintf(stderr, "%s - ", status_string.value);
	    return(0);
	  }
	}
#endif  /* SPX_CHALLENGE */

	{
	  gss_buffer_desc  fullname_buffer, luser_buffer, acl_file_buffer;
	  gss_OID          fullname_type;
	  char             acl_file[160];

	  major_status = gss_display_name(&status,
					  src_name,
					  &fullname_buffer,
					  &fullname_type);

	  luser_buffer.value = locuser;
	  luser_buffer.length = strlen(locuser);

	  strcpy(acl_file, pwd->pw_dir);
	  strcat(acl_file, "/.sphinx");
	  acl_file_buffer.value = acl_file;
	  acl_file_buffer.length = strlen(acl_file);

	  major_status = gss__check_acl(&status,
					&fullname_buffer,
					&acl_file_buffer);
	  seteuid(0);

	  if (major_status != GSS_S_COMPLETE) {
	    if (strcmp(locuser, "root")==0)
	      syslog(LOG_INFO, "root authorization denied - '%s'", src_name);
	    fprintf(stderr, "SPX : authorization denied to user account '%s' - ", locuser);
	    exit(-1);
	  } else {
	    strcpy(userfullname, src_name);
	    strcpy(userlocalname, remuser);
	  }
	  major_status = gss_release_buffer(&status, &fullname_buffer);
	}

	if (chdir(pwd->pw_dir) < 0) {
	  (void) chdir("/");
	  syslog(LOG_INFO, "No remote directory '%s' for '%s'", pwd->pw_dir, pwd->pw_name);
	}


	if (pwd->pw_uid && !access("/etc/nologin", F_OK)) {
		error("Logins currently disabled.\n");
		exit(1);
	}

	if (port) {
		if (pipe(pv) < 0) {
			error("Can't make pipe.\n");
			exit(1);
		}
		pid = fork();
		if (pid == -1)  {
			error("Try again.\n");
			exit(1);
		}
		if (pid) {
			(void) close(0); (void) close(1); (void) close(2);
			(void) close(f); (void) close(pv[1]);
			readfrom = (1L<<s) | (1L<<pv[0]);
			ioctl(pv[0], FIONBIO, (char *)&one);
			/* should set s nbio! */
			do {
				ready = readfrom;
				if (select(16, &ready, (fd_set *)0,
				    (fd_set *)0, (struct timeval *)0) < 0)
					break;
				if (ready & (1L<<s)) {
					if (read(s, &sig, 1) <= 0)
						readfrom &= ~(1L<<s);
					else
						killpg(pid, sig);
				}
				if (ready & (1L<<pv[0])) {
					errno = 0;
					cc = read(pv[0], buf, sizeof (buf));
					if (cc <= 0) {
						shutdown(s, 1+1);
						readfrom &= ~(1L<<pv[0]);
					} else {
						(void) write(s, buf, cc);
					}
				}
			} while (readfrom);
			exit(0);
		}
		setpgrp(0, getpid());

		(void) close(s); (void) close(pv[0]);
		dup2(pv[1], 2);

		(void) close(pv[1]);
	}
	if (*pwd->pw_shell == '\0')
		pwd->pw_shell = "/bin/sh";

	(void) close(f);

#ifdef sun
	(void) setgid(pwd->pw_gid);
#else
	(void) setgid((gid_t)pwd->pw_gid);
#endif
	initgroups(pwd->pw_name, pwd->pw_gid);
#ifdef sun
	(void) setuid(pwd->pw_uid);
#else
	(void) setuid((uid_t)pwd->pw_uid);
#endif
	environ = envinit;
	if (ret_flags & GSS_C_DELEG_FLAG) {
	  major_status = gss__stash_default_cred(&status,
						 gss_delegated_cred_handle);
	  if (major_status != GSS_S_COMPLETE)
	    syslog(LOG_INFO, "unable to stash delegated credentials");
	}

	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, pwd->pw_shell, sizeof(shell)-7);
	strncat(username, pwd->pw_name, sizeof(username)-6);
	cp = rindex(pwd->pw_shell, '/');
	if (cp)
		cp++;
	else
		cp = pwd->pw_shell;

	execl(pwd->pw_shell, cp, "-c", cmdbuf, 0);
	perror(pwd->pw_shell);
	exit(1);
}

/*VARARGS1*/
error(fmt, a1, a2, a3)
	char *fmt;
	int a1, a2, a3;
{
	char buf[BUFSIZ];

	buf[0] = 1;
	(void) sprintf(buf+1, fmt, a1, a2, a3);
	(void) write(2, buf, strlen(buf));
}

getstr(buf, cnt, err)
	char *buf;
	int cnt;
	char *err;
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		*buf++ = c;
		if (--cnt == 0) {
			error("%s too long\n", err);
			exit(1);
		}
	} while (c != 0);
}

/*
 * local_net_read() reads from the file descriptor "fd" to the buffer
 * "buf", until either 1) "len" bytes have been read or 2) cannot
 * read anymore from "fd".  It returns the number of bytes read
 * or a read() error.  (The calling interface is identical to
 * read(2).)
 *
 * XXX must not use non-blocking I/O
 */

int
local_net_read(fd, buf, len)
int fd;
register char *buf;
register int len;
{
    int cc, len2 = 0;

    do {
	cc = read(fd, buf, len);
	if (cc < 0)
	    return(cc);		 /* errno is already set */
	else if (cc == 0) {
	    return(len2);
	} else {
	    buf += cc;
	    len2 += cc;
	    len -= cc;
	}
    } while (len > 0);
    return(len2);
}
