/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/rsamd2_sign_aux.c,v $
 *
 *
 *  MODULE NAME:    rsamd2_sign_aux.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "sign_aux.h"

#include "bigrsacode.h"
#include "bigsignverify.h"
#include "BigRSA.h"
#include "objid.h"

#ifdef DEBUG
#undef DEBUG
#endif

#define MAX_SIG 2*DigitLim*sizeof(BigNumDigit)

static char temp[MAX_SIG];

typedef int (*IFX)();
struct type_SPHINX_AlgorithmIdentifier *create_alg_id();

/*
 * Returns an expanded macro structure including data, signature and
 * algorithm identifier.
 */

int rsamd2_sign_aux (data,encode_fn,key,x_out)
IFX encode_fn;
struct type_Sign_SignedData **x_out;
RSAKeyStorage *key;
PE data;
{
    int status=0, new_len, sig_len;
    unsigned char *asn1_new_x=NULL;
    struct type_Sign_SignedData *x;

    if((status = ber_encode(data,encode_fn,PS_LEN_LONG,&asn1_new_x,&new_len)) == NOTOK) {
#ifdef DEBUG
printf("%s: Error converting to string. \n", __FILE__);
#endif
      goto finished;
    }
    
#ifdef DEBUG
printf("\n%s: Signing encoded data.\n", __FILE__);
dumphex(asn1_new_x,new_len);
fflush(stdout);
#endif

    *temp=0;
    if (status=RSASign(asn1_new_x,new_len,key,temp+1,&sig_len));
    else {    
#ifdef DEBUG
printf("\n%s: Error signing structure.\n", __FILE__);
fflush(stdout);
#endif
        goto finished;
    }

    if (x = (struct type_Sign_SignedData *) malloc (sizeof(struct type_Sign_SignedData)));
    else {
#ifdef DEBUG
printf("\n%s: Error allocating storage for signed data.\n", __FILE__);
fflush(stdout);
#endif
        status = 0;
        goto finished;
    }
    x->toBeSigned = data ;    
    x->signature = str2prim(temp,1+sig_len, PE_CLASS_UNIV, PE_PRIM_BITS);
    if (x->signature == NULLPE) {
#ifdef DEBUG
printf("\n%s: Error allocating BITSTRING PE.\n", __FILE__);
fflush(stdout);
#endif
        status = 0;
        goto finished;
    }
    x->signature = prim2bit(x->signature);
    if (x->algorithm = create_alg_id(OIW_MD2_WITH_RSA_OID,NULL)) {
            *x_out = x;
            status = 1;
    }
    else {
#ifdef DEBUG
printf("\n%s: Error creating algorithm identifier\n");
fflush(stdout);
#endif
        status = 0;
    }
        

finished:
    if(asn1_new_x) free(asn1_new_x);
    if (!status && x) {
        if (x->algorithm) free_SPHINX_AlgorithmIdentifier(x->algorithm);
        if (x->signature) pe_free(x->signature);
        free (x);
    }
#ifdef DEBUG
printf("\n%s: Status = %d\n", __FILE__, status);
#endif
    return(status);
}


