/* $Id: graphwin.c,v 1.14 90/05/06 14:00:32 pturner Exp Locker: pturner $
 *
 * graphops - operations on graphs
 *
 * TODO: need to fix the user interface for this one
 *
 */

#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "defines.h"
#include "setdef.h"
#include "objdefs.h"
#include "globals.h"

extern int nsets;

#define define_select_graph_panel(panel,x,y,panelname,panel_item) \
				panel_item=panel_create_item( panel,\
				PANEL_CYCLE,\
				PANEL_ITEM_X,x,\
				PANEL_ITEM_Y,y,\
				PANEL_LABEL_STRING,panelname,\
	 			PANEL_CHOICE_STRINGS,\
			"Graph 0", "Graph 1", "Graph 2", "Graph 3", "Graph 4", "Graph 5",\
			"Graph 6", "Graph 7", "Graph 8", "Graph 9",\
			0, 0 );

#define define_select_graph_panel2(panel,x,y,panelname,panel_item) \
				panel_item=panel_create_item( panel,\
				PANEL_CYCLE,\
				PANEL_ITEM_X,x,\
				PANEL_ITEM_Y,y,\
				PANEL_LABEL_STRING,panelname,\
	 			PANEL_CHOICE_STRINGS,\
			"Graph 0", "Graph 1", "Graph 2", "Graph 3", "Graph 4", "Graph 5",\
			"Graph 6", "Graph 7", "Graph 8", "Graph 9", "Saved graphs", "Default graph",\
			0, 0 );

void define_graph_popup();

extern Pixfont *winfont;

extern Window main_frame, main_panel;
extern Frame define_world_frame;
extern Panel define_world_panel;
static Panel_item hide_graph_item;
static Panel_item unhide_graph_item;
static Panel_item load_graph_item;
static Panel_item store_graph_item;
static Panel_item graph_msg_item;

static char errbuf[100];
static int ngraphs = 0;

void drawgraph();

#define MAXGRAPH 10

extern plotstr pstr[];
extern plotstr legstr[];
extern plotarr *plots[];

/*
 * a graph
 */
typedef struct {
    int graphactive;		/* alive or dead */
    int graphhidden;		/* display or not */
    int graphlabel;		/* label graph */
    int graphtype;		/* type of graph */
    plotarr *plots[MAXPLOT];	/* sets go here */
    int nsets;			/* number of active sets for this graph */
    plotstr pstr[MAXSTR];	/* strings */
    plotstr legstr[MAXPLOT];	/* legends */
    boxtype boxes[MAXBOXES];	/* boxes */
    int nboxes;			/* number of boxes */
    linetype lines[MAXLINES];	/* lines */
    int nlines;			/* number of lines */
    int legendflag;		/* legend on or off */
    double legx, legy;		/* location of legend */
    int lgap, llen;		/* legend gap and length of legend in
				 * characters */
    int legloctype;
    int defline, defcolor;	/* default graph line and color */
    double defchar;		/* default charsize */
    int curfont;
    double errbarper;		/* length of error bar */
    double xg1, xg2, yg1, yg2;	/* world coordinates */
    double xv1, xv2, yv1, yv2;	/* viewpoint coordinates */
    double xt1, xt2, yt1, yt2;	/* xmajor, xminor, ymajor, yminor tic marks */
    char xlabel[128];		/* x-axis label */
    char ylabel[128];		/* y-axis label */
    char title[128];		/* graph title */
    char stitle[128];		/* graph subtitle */
    int xform;			/* format for x-axis labels */
    int yform;			/* format for y-axis labels */
    int xticsintflag;		/* major tic marks on integer divisions */
    int yticsintflag;		/* not used in grtool */
    int boxflag;		/* boxflag=TRUE => closed box, =FALSE => half
				 * open */
    int boxon;			/* toggle box on or off */
    int boxcol;
    int boxlin;
    int xticflag;		/* toggle ticmark display */
    int yticflag;
    int fformx;			/* decimal or exponential ticmark labels .. */
    int fformy;			/* default to decimal */
    int xticlflag;		/* toggle ticmark labels on or off */
    int yticlflag;
    int xgridflag;		/* toggle ticmarks as grid lines */
    int ygridflag;
    int xgcol, xglin;		/* grid colors and linestyle */
    int ygcol, yglin;
    int xticslog;		/* logarithmic ticmarks */
    int yticslog;
    int logtransflag;
    int xticinoutflag;		/* tics inward by default */
    int yticinoutflag;
    int xticopflag;		/* tics on opposite side */
    int yticopflag;
    int xtopflag;
    int ytopflag;
    int xabsflag;		/* tic labels absolute value */
    int yabsflag;
    int xticlskip;
    int yticlskip;
    int xticangle;
    int yticangle;
    int xticnum;
    int yticnum;
    double xticsize;
    double yticsize;
    int xzflag;			/* toggle the lines x=0 or y=0 */
    int yzflag;
    int xztflag;		/* toggle ticmarks for the lines x=0, y=0 */
    int yztflag;
} graph;

graph graphs[MAXGRAPH + 2];

plotarr *allocplot();

plotallocxy(plots, i, len)
    plotarr *plots;
    int i, len;
{
    if (plots->x == NULL) {
	if ((plots->x = (double *) calloc(len, sizeof(double))) == NULL) {
	    fprintf(stderr, "Insufficient memory to allocate for plots\n");
	    exit(1);
	}
    }
    if (plots->y == NULL) {
	if ((plots->y = (double *) calloc(len, sizeof(double))) == NULL) {
	    fprintf(stderr, "Insufficient memory to allocate for plots\n");
	    exit(1);
	}
    }
}

copyplotarr(p1, p2)
    plotarr *p1[], *p2[];

{
    int i, j;

    for (i = 0; i < MAXPLOT; i++) {
	if (p2[i]->active) {
	    cxfree(p2[i]->x);
	    cxfree(p2[i]->y);
	}
	p2[i]->x = NULL;
	p2[i]->y = NULL;
	if (p1[i]->active) {
	    plotallocxy(p2[i], i, p1[i]->len);
	    for (j = 0; j < p1[i]->len; j++) {
		p2[i]->x[j] = p1[i]->x[j];
		p2[i]->y[j] = p1[i]->y[j];
	    }
	}
	strcpy(p2[i]->comments, p1[i]->comments);
	p2[i]->xmin = p1[i]->xmin;
	p2[i]->ymin = p1[i]->ymin;
	p2[i]->xmax = p1[i]->xmax;
	p2[i]->ymax = p1[i]->ymax;
	p2[i]->plotsym = p1[i]->plotsym;
	p2[i]->linesym = p1[i]->linesym;
	p2[i]->color = p1[i]->color;
	p2[i]->len = p1[i]->len;
	p2[i]->active = p1[i]->active;
	p2[i]->errbar = p1[i]->errbar;
	p2[i]->errbarxy = p1[i]->errbarxy;
    }
}

initplotarr(plots)
    plotarr *plots[];

{
    int i;

    for (i = 0; i < MAXPLOT; i++) {
	if ((plots[i] = allocplot()) == NULL) {
	    fprintf(stderr, "Insufficient memory to allocate for plots\n");
	    exit(1);
	}
	plots[i]->x = NULL;
	plots[i]->y = NULL;
	plots[i]->comments[0] = 0;
	plots[i]->xmin = 0.0;
	plots[i]->ymin = 0.0;
	plots[i]->xmax = 0.0;
	plots[i]->ymax = 0.0;
	plots[i]->plotsym = 0;
	plots[i]->linesym = defline;
	plots[i]->color = defcolor;
	plots[i]->len = 0;
	plots[i]->active = FALSE;
	plots[i]->errbar = -1;
	plots[i]->errbarxy = 0;
    }
}

copy_graph(g1, g2)
    int g1, g2;
{
    bcopy((char *) &graphs[g1], (char *) &graphs[g2], sizeof(graph));
    if (g1 != MAXGRAPH) {
	copyplotarr(graphs[g1].plots, graphs[g2].plots);
    }
}

initgraph(gnum)
    int gnum;
{
    copy_graph(MAXGRAPH, gnum);
    initplotarr(graphs[gnum].plots);
}

initgraphs()
{
    int i;

    for (i = 0; i < MAXGRAPH; i++) {
	initgraph(i);
    }
    initgraph(MAXGRAPH + 1);
    hide_graph(MAXGRAPH);
}

loadgraph(gnum, upd)
    int gnum, upd;
{
    int i;

    for (i = 0; i < MAXSTR; i++) {
	bcopy((char *) &graphs[gnum].pstr[i], (char *) &pstr[i], sizeof(plotstr));
    }
    for (i = 0; i < MAXBOXES; i++) {
	bcopy((char *) &graphs[gnum].boxes[i], (char *) &boxes[i], sizeof(boxtype));
    }
    nboxes = graphs[gnum].nboxes;
    for (i = 0; i < MAXLINES; i++) {
	bcopy((char *) &graphs[gnum].lines[i], (char *) &lines[i], sizeof(linetype));
    }
    nlines = graphs[gnum].nlines;
    copyplotarr(graphs[gnum].plots, plots);
    for (i = 0; i < MAXPLOT; i++) {
	bcopy((char *) &graphs[gnum].legstr[i], (char *) &legstr[i], sizeof(plotstr));
    }
    nsets = graphs[gnum].nsets;	/* number of active sets */
    defline = graphs[gnum].defline;
    defchar = graphs[gnum].defchar;
    defcolor = graphs[gnum].defcolor;
    curfont = graphs[gnum].curfont;
    legendflag = graphs[gnum].legendflag;
    legx = graphs[gnum].legx;
    legy = graphs[gnum].legy;
    lgap = graphs[gnum].lgap;
    llen = graphs[gnum].llen;
    legloctype = graphs[gnum].legloctype;
    xg1 = graphs[gnum].xg1;
    xg2 = graphs[gnum].xg2;
    yg1 = graphs[gnum].yg1;
    yg2 = graphs[gnum].yg2;	/* world coordinates */
    xv1 = graphs[gnum].xv1;
    xv2 = graphs[gnum].xv2;
    yv1 = graphs[gnum].yv1;
    yv2 = graphs[gnum].yv2;	/* viewpoint coordinates */
    xt1 = graphs[gnum].xt1;
    xt2 = graphs[gnum].xt2;
    yt1 = graphs[gnum].yt1;
    yt2 = graphs[gnum].yt2;	/* xmajor, xminor, ymajor, yminor tic marks */
    strcpy(xlabel, graphs[gnum].xlabel);	/* x-axis label */
    strcpy(ylabel, graphs[gnum].ylabel);	/* y-axis label */
    strcpy(title, graphs[gnum].title);	/* graph title */
    strcpy(stitle, graphs[gnum].stitle);	/* graph subtitle */
    xform = graphs[gnum].xform;	/* format for x-axis labels */
    yform = graphs[gnum].yform;	/* format for y-axis labels */
    xticsintflag = graphs[gnum].xticsintflag;	/* major tic marks on integer
						 * divisions */
    yticsintflag = graphs[gnum].yticsintflag;	/* not used in grtool */
    boxflag = graphs[gnum].boxflag;	/* boxflag=TRUE => closed box, =FALSE
					 * => half open */
    boxon = graphs[gnum].boxon;	/* toggle box on or off */
    boxcol = graphs[gnum].boxcol;
    boxlin = graphs[gnum].boxlin;
    xticflag = graphs[gnum].xticflag;	/* toggle ticmark display */
    yticflag = graphs[gnum].yticflag;
    fformx = graphs[gnum].fformx;	/* decimal or exponential ticmark
					 * labels .. */
    fformy = graphs[gnum].fformy;	/* default to decimal */
    xticlflag = graphs[gnum].xticlflag;	/* toggle ticmark labels on or off */
    yticlflag = graphs[gnum].yticlflag;
    xgridflag = graphs[gnum].xgridflag;	/* toggle ticmarks as grid lines */
    ygridflag = graphs[gnum].ygridflag;
    xgcol = graphs[gnum].xgcol;
    xglin = graphs[gnum].xglin;
    ygcol = graphs[gnum].ygcol;
    yglin = graphs[gnum].yglin;
    xticslog = graphs[gnum].xticslog;	/* logarithmic ticmarks */
    yticslog = graphs[gnum].yticslog;
    logtransflag = graphs[gnum].logtransflag;
    xticinoutflag = graphs[gnum].xticinoutflag;	/* tics inward by default */
    yticinoutflag = graphs[gnum].yticinoutflag;
    xabsflag = graphs[gnum].xabsflag;	/* tic labels absolute value */
    yabsflag = graphs[gnum].yabsflag;
    xticopflag = graphs[gnum].xticopflag;	/* tics opposite */
    yticopflag = graphs[gnum].yticopflag;
    xtopflag = graphs[gnum].xtopflag;	/* tic labels on top */
    ytopflag = graphs[gnum].ytopflag;
    xticlskip = graphs[gnum].xticlskip;
    yticlskip = graphs[gnum].yticlskip;
    xticangle = graphs[gnum].xticangle;
    yticangle = graphs[gnum].yticangle;
    xticnum = graphs[gnum].xticnum;
    yticnum = graphs[gnum].yticnum;
    xticsize = graphs[gnum].xticsize;
    yticsize = graphs[gnum].yticsize;
    xzflag = graphs[gnum].xzflag;	/* toggle the lines x=0 or y=0 */
    yzflag = graphs[gnum].yzflag;
    xztflag = graphs[gnum].xztflag;	/* toggle ticmarks for the lines x=0,
					 * y=0 */
    yztflag = graphs[gnum].yztflag;
    errbarper = graphs[gnum].errbarper;
    if (upd) {
	updatetics();
	updateparms();
	for (i = 0; i < maxplot; i++) {
	    update_status(i);
	}
	for (i = 0; i < maxplot; i++) {
	    updatesymbols(i);
	}
	updatelegends();
	drawgraph();
    }
}

storegraph(gnum)
    int gnum;
{
    int i;

    graphs[gnum].nsets = nsets;	/* number of active sets */
    if (gnum != MAXGRAPH) {
	copyplotarr(plots, graphs[gnum].plots);
    } else {
	initplotarr(graphs[gnum].plots);
    }
    for (i = 0; i < MAXSTR; i++) {
	bcopy((char *) &pstr[i], (char *) &graphs[gnum].pstr[i], sizeof(plotstr));
    }
    for (i = 0; i < MAXBOXES; i++) {
	bcopy((char *) &boxes[i], (char *) &graphs[gnum].boxes[i], sizeof(boxtype));
    }
    graphs[gnum].nboxes = nboxes;
    for (i = 0; i < MAXLINES; i++) {
	bcopy((char *) &lines[i], (char *) &graphs[gnum].lines[i], sizeof(linetype));
    }
    graphs[gnum].nlines = nlines;
    for (i = 0; i < maxplot; i++) {
	bcopy((char *) &legstr[i], (char *) &graphs[gnum].legstr[i], sizeof(plotstr));
    }
    graphs[gnum].defline = defline;
    graphs[gnum].defchar = defchar;
    graphs[gnum].defcolor = defcolor;
    graphs[gnum].curfont = curfont;
    graphs[gnum].legendflag = legendflag;
    graphs[gnum].legx = legx;
    graphs[gnum].legy = legy;
    graphs[gnum].lgap = lgap;
    graphs[gnum].llen = llen;
    graphs[gnum].legloctype = legloctype;
    graphs[gnum].errbarper = errbarper;
    graphs[gnum].xg1 = xg1;
    graphs[gnum].xg2 = xg2;
    graphs[gnum].yg1 = yg1;
    graphs[gnum].yg2 = yg2;	/* world coordinates */
    graphs[gnum].xv1 = xv1;
    graphs[gnum].xv2 = xv2;
    graphs[gnum].yv1 = yv1;
    graphs[gnum].yv2 = yv2;	/* viewpoint coordinates */
    graphs[gnum].xt1 = xt1;
    graphs[gnum].xt2 = xt2;
    graphs[gnum].yt1 = yt1;
    graphs[gnum].yt2 = yt2;	/* xmajor, xminor, ymajor, yminor tic marks */
    strcpy(graphs[gnum].xlabel, xlabel);	/* x-axis label */
    strcpy(graphs[gnum].ylabel, ylabel);	/* y-axis label */
    strcpy(graphs[gnum].title, title);	/* graph title */
    strcpy(graphs[gnum].stitle, stitle);	/* graph subtitle */
    graphs[gnum].xform = xform;	/* format for x-axis labels */
    graphs[gnum].yform = yform;	/* format for y-axis labels */
    graphs[gnum].xticsintflag = xticsintflag;	/* major tic marks on integer
						 * divisions */
    graphs[gnum].yticsintflag = yticsintflag;	/* not used in grtool */
    graphs[gnum].boxflag = boxflag;	/* boxflag=TRUE => closed box, =FALSE
					 * => half open */
    graphs[gnum].boxon = boxon;	/* toggle box on or off */
    graphs[gnum].boxcol = boxcol;
    graphs[gnum].boxlin = boxlin;
    graphs[gnum].xticflag = xticflag;	/* toggle ticmark display */
    graphs[gnum].yticflag = yticflag;
    graphs[gnum].fformx = fformx;	/* decimal or exponential ticmark
					 * labels .. */
    graphs[gnum].fformy = fformy;	/* default to decimal */
    graphs[gnum].xticlflag = xticlflag;	/* toggle ticmark labels on or off */
    graphs[gnum].yticlflag = yticlflag;
    graphs[gnum].xgridflag = xgridflag;	/* toggle ticmarks as grid lines */
    graphs[gnum].ygridflag = ygridflag;
    graphs[gnum].xgcol = xgcol;
    graphs[gnum].xglin = xglin;
    graphs[gnum].ygcol = ygcol;
    graphs[gnum].yglin = yglin;
    graphs[gnum].xticslog = xticslog;	/* logarithmic ticmarks */
    graphs[gnum].yticslog = yticslog;
    graphs[gnum].logtransflag = logtransflag;
    graphs[gnum].xticinoutflag = xticinoutflag;	/* tics inward by default */
    graphs[gnum].yticinoutflag = yticinoutflag;
    graphs[gnum].xabsflag = xabsflag;	/* tic labels absolute value */
    graphs[gnum].yabsflag = yabsflag;
    graphs[gnum].xticopflag = xticopflag;	/* tics opposite */
    graphs[gnum].yticopflag = yticopflag;
    graphs[gnum].xtopflag = xtopflag;	/* tic labels on top */
    graphs[gnum].ytopflag = ytopflag;
    graphs[gnum].xticlskip = xticlskip;
    graphs[gnum].yticlskip = yticlskip;
    graphs[gnum].xticangle = xticangle;
    graphs[gnum].yticangle = yticangle;
    graphs[gnum].xticnum = xticnum;
    graphs[gnum].yticnum = yticnum;
    graphs[gnum].xticsize = xticsize;
    graphs[gnum].yticsize = yticsize;
    graphs[gnum].xzflag = xzflag;	/* toggle the lines x=0 or y=0 */
    graphs[gnum].yzflag = yzflag;
    graphs[gnum].xztflag = xztflag;	/* toggle ticmarks for the lines x=0,
					 * y=0 */
    graphs[gnum].yztflag = yztflag;
}

int ishid_graph(g)
    int g;
{
    return graphs[g].graphhidden;
}

int hide_graph(g)
    int g;
{
    int i;

    if (g == MAXGRAPH + 1) {
	showdefault = FALSE;
    } else if (g == MAXGRAPH) {
	for (i = 0; i < MAXGRAPH; i++) {
	    graphs[i].graphhidden = TRUE;
	}
    } else {
	graphs[g].graphhidden = TRUE;
    }
}

int unhide_graph(g)
    int g;
{
    int i;

    if (g == MAXGRAPH + 1) {
	showdefault = TRUE;
    } else if (g == MAXGRAPH) {
	/*
	 * for (i = 0; i < MAXGRAPH; i++) { graphs[i].graphhidden = FALSE; }
	 */
    } else {
	graphs[g].graphhidden = FALSE;
    }
}

static void do_unhideg_proc()
{
    int graphno;

    graphno = (int) panel_get_value(unhide_graph_item);
    if (graphno < MAXGRAPH && !ishid_graph(graphno)) {
	sprintf(errbuf, "Graph %d displayed", graphno);
	errwin(errbuf);
	return;
    } else {
	unhide_graph(graphno);
	drawgraph();
    }
}

static void do_hideg_proc()
{
    int graphno;

    graphno = (int) panel_get_value(hide_graph_item);
    if (graphno < MAXGRAPH && ishid_graph(graphno)) {
	sprintf(errbuf, "Graph %d already hidden", graphno);
	errwin(errbuf);
	return;
    } else {
	hide_graph(graphno);
	drawgraph();
    }
}

static void do_loadg_proc()
{
    int graphno;

    graphno = (int) panel_get_value(load_graph_item);
    loadgraph(graphno, 1);
}

static void do_storeg_proc()
{
    int graphno;

    graphno = (int) panel_get_value(store_graph_item);
    storegraph(graphno);
}

set_draw_label(i, toset)
    int i, toset;
{
    graphs[i].graphlabel = toset;
}

int draw_label(i)
    int i;
{
    return graphs[i].graphlabel;
}

static void do_labelgraphs_proc()
{
    int i;

    for (i = 0; i < MAXGRAPH; i++) {
	graphs[i].graphlabel = (graphs[i].graphlabel) ? FALSE : TRUE;
    }
    labeldefault = (labeldefault) ? FALSE : TRUE;
    drawgraph();
}

void define_graphops()
{
    define_select_graph_panel2(define_world_panel, ATTR_COL(45), ATTR_ROW(2), "Show:", unhide_graph_item);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		 panel_button_image(define_world_panel, "Show", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(2),
		      PANEL_NOTIFY_PROC, do_unhideg_proc,
		      0);
    graph_msg_item = panel_create_item(define_world_panel, PANEL_MESSAGE,
				       PANEL_ITEM_X, ATTR_COL(35),
				       PANEL_ITEM_Y, ATTR_ROW(1),
				       PANEL_LABEL_STRING, "Graph ops:", 0);

    define_select_graph_panel2(define_world_panel, ATTR_COL(45), ATTR_ROW(3), "Hide:", hide_graph_item);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		 panel_button_image(define_world_panel, "Hide", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(3),
		      PANEL_NOTIFY_PROC, do_hideg_proc,
		      0);

    define_select_graph_panel(define_world_panel, ATTR_COL(45), ATTR_ROW(4), "Load:", load_graph_item);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		 panel_button_image(define_world_panel, "Load", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(4),
		      PANEL_NOTIFY_PROC, do_loadg_proc,
		      0);

    define_select_graph_panel(define_world_panel, ATTR_COL(45), ATTR_ROW(5), "Store:", store_graph_item);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		panel_button_image(define_world_panel, "Store", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(5),
		      PANEL_NOTIFY_PROC, do_storeg_proc,
		      0);

    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	 panel_button_image(define_world_panel, "Label graphs", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(35),
		      PANEL_ITEM_Y, ATTR_ROW(6),
		      PANEL_NOTIFY_PROC, do_labelgraphs_proc,
		      0);
}
