/* $Id: hplj.c,v 1.5 90/05/09 22:14:46 pturner Exp Locker: pturner $
 *
 * driver for hplj 300-150-75 dpi
 *
 * From code by Brian Utterback's rasterfil - HPLJ filter
 *
 */

#include <stdio.h>
#include <pixrect/pixrect_hs.h>
#include <pixrect/pixrect.h>
#include <pixrect/pr_line.h>
#include "externs.h"

double devtoworldx(), devtoworldy();

/*
 * Dimensions at various resolutions
 */
#define LJXMIN300 0
#define LJXMAX300 2400
#define LJYMIN300 0
#define LJYMAX300 3100
#define DXLJ300 2400
#define DYLJ300 3100

#define LJXMIN150 0
#define LJXMAX150 1200
#define LJYMIN150 0
#define LJYMAX150 1550
#define DXLJ150 1200
#define DYLJ150 1550

#define LJXMIN75 0
#define LJXMAX75 600
#define LJYMIN75 0
#define LJYMAX75 775
#define DXLJ75 600
#define DYLJ75 775

static Pixrect *mpr;
struct rasterfile ras;
static FILE *hpljout;

struct {
    int width, height, depth;
    short *bits;
} raster;

struct {
    int type, nbytes;
    char *data;
} map;

#define MINCOLOR 0
#define MAXCOLOR 9

static int hpljcolor = 1;
static int hpljdmode;
static int hpljfont = 0;
static int hpljlinestyle = 1;
static int orientflag = 0;

extern double devcharsize;
extern double charsize;
extern int ptofile;
extern char printstr[];
extern char *curprint;

/*
 * spool using these
 */
#ifndef HPLJ_PRSTR
char hplj_prstr[128] = "/usr/ucb/lpr -Plpb -h ";

#else
char hplj_prstr[128] = HPLJ_PRSTR;

#endif

static char tmpbuf[64];
static char dumpstr[128];
static char *fname;

static double hpljcharsize = 2.0;

double xconv(), yconv();

void drawhplj();

static int win_h, win_w;

static Pr_brush b = {1};
static short int mypat1[2] = {1, 0};
static short int mypat2[3] = {2, 10, 0};
static short int mypat3[3] = {10, 10, 0};
static short int mypat4[3] = {15, 15, 0};
static short int mypat5[5] = {5, 2, 15, 2, 0};
static short int mypat6[3] = {20, 20, 0};
static short int mypat7[3] = {25, 25, 0};
static short int *patterns[] = {mypat1, mypat2, mypat3, mypat4, mypat5, mypat6, mypat7};
static Pr_texture tex;

void putstrhplj(s)
    char *s;
{
}

void hpljsetmode(mode)
    int mode;
{
    int but, len;
    char segfile[128];
    colormap_t *colormap = NULL;
    int type = RT_BYTE_ENCODED;
    int copy_flag = 1;
    char *mktemp(), tbuf[128];
    Pixrect *pr;
    int i, j, lineby, l, maxbytes, numlines;
    char *dd;
    static int xwidth;

    if (!ptofile) {
	strcpy(tmpbuf, "/tmp/grtoolXXXXXX");
	fname = mktemp(tmpbuf);
    } else {
	fname = printstr;
    }
    hpljout = fopen(fname, "w");
    switch (mode) {
    case 1:
	mpr = mem_create(LJXMAX300, LJYMAX300, 1);
	win_h = LJXMAX300;
	win_w = LJYMAX300;
	orientflag = 1;
	hpljcharsize = 2.0;
	devxticl = 35;
	devyticl = 35;
	devarrowlength = 35;
	xwidth = 2400;
	break;
    case 3:
	mpr = mem_create(LJXMAX300, LJYMAX300, 1);
	win_w = LJXMAX300;
	win_h = LJYMAX300;
	orientflag = 0;
	hpljcharsize = 2.0;
	devxticl = 35;
	devyticl = 35;
	devarrowlength = 35;
	xwidth = 2400;
	break;
    case 5:
	mpr = mem_create(LJXMAX150, LJYMAX150, 1);
	win_h = LJXMAX150;
	win_w = LJYMAX150;
	orientflag = 1;
	hpljcharsize = 1.0;
	devxticl = 17;
	devyticl = 17;
	devarrowlength = 17;
	xwidth = 1200;
	break;
    case 7:
	mpr = mem_create(LJXMAX150, LJYMAX150, 1);
	win_w = LJXMAX150;
	win_h = LJYMAX150;
	orientflag = 0;
	hpljcharsize = 1.0;
	devxticl = 17;
	devyticl = 17;
	devarrowlength = 17;
	xwidth = 1200;
	break;
    case 9:
	mpr = mem_create(LJXMAX75, LJYMAX75, 1);
	win_h = LJXMAX75;
	win_w = LJYMAX75;
	orientflag = 1;
	hpljcharsize = 0.5;
	devxticl = 8;
	devyticl = 8;
	devarrowlength = 8;
	xwidth = 600;
	break;
    case 11:
	mpr = mem_create(LJXMAX75, LJYMAX75, 1);
	win_w = LJXMAX75;
	win_h = LJYMAX75;
	orientflag = 0;
	hpljcharsize = 0.5;
	devxticl = 8;
	devyticl = 8;
	devarrowlength = 8;
	xwidth = 600;
	break;
    case 2:
    case 4:
    case 6:
    case 8:
    case 10:
    case 12:
	if (hpljout != NULL) {
	    fprintf(hpljout, "\033E");
	    fprintf(hpljout, "\033*p0x0Y");
	    maxbytes = xwidth / 8;
	    numlines = maxbytes * 11;
	    fprintf(hpljout, "\033*t%dR", maxbytes);
	    fprintf(hpljout, "\033*r0A");
	    fflush(hpljout);
	    numlines = (numlines < mpr->pr_size.y) ? numlines : mpr->pr_size.y;
	    pr = mem_create(mpr->pr_size.x, 1, 1);
	    for (i = 0; i < numlines; i++) {
		pr_rop(pr, 0, 0, mpr->pr_size.x, 1, PIX_SRC, mpr, 0, i);
		fprintf(hpljout, "\033*b");
		lineby = mpr_mdlinebytes(pr);
		lineby = (lineby > maxbytes) ? maxbytes : lineby;
		dd = (char *) (mpr_d(pr)->md_image);
		j = lineby;
		while (j > 0 && !dd[j - 1]) {
		    j--;
		}
		lineby = j;
		fprintf(hpljout, "%dW", lineby);
		l = fwrite((char *) (mpr_d(pr)->md_image), sizeof(*dd),
			   lineby, hpljout);
	    }
	    fprintf(hpljout, "\033*rB");
	    pr_close(mpr);
	    pr_close(pr);
	    fclose(hpljout);
	    if (!ptofile) {
		sprintf(tbuf, " %s %s", curprint, fname);
		system(tbuf);
		if (unlink(fname)) {
		    fprintf(stderr, "Unlink failed in hplj.c\n");
		}
	    }
	} else {
	    pr_close(mpr);
	}
	orientflag = 0;
	break;
    }
}

/*
 * fix for dotted/dashed linestyles
 */
#define MAXL 1024
static int npending;
static struct pr_pos polypoints[MAXL];

static void flush_pending()
{
    int i;

    if (hpljcolor == 1 && hpljlinestyle == 1) {
	for (i = 0; i < npending - 1; i++) {
	    pr_vector(mpr, polypoints[i].x, polypoints[i].y, polypoints[i + 1].x, polypoints[i + 1].y, PIX_SET, 1);
	}
    } else {
	pr_polyline(mpr, 0, 0, npending, polypoints, POLY_DONTCLOSE, &b, &tex, PIX_SET);
    }
    npending = 0;
}

static int x1, y1;

void drawhplj(x, y, mode)
    int x, y, mode;
{
    if (mode) {
	if (!orientflag) {
	    polypoints[npending].x = x;
	    polypoints[npending].y = win_h - y;
	    npending++;
	} else {
	    polypoints[npending].x = y;
	    polypoints[npending].y = x;
	    npending++;
	}
	if (npending == MAXL) {
	    flush_pending();
	}
    } else {
	if ((x == x1 && y == y1)) {
	    return;
	} else {
	    flush_pending();
	    if (!orientflag) {
		polypoints[npending].x = x;
		polypoints[npending].y = win_h - y;
		npending++;
	    } else {
		polypoints[npending].x = y;
		polypoints[npending].y = x;
		npending++;
	    }
	}
    }
    x1 = x;
    y1 = y;
}

int xconvhplj(x)
    double x;
{
    return ((int) (win_w * xconv(x)));
}

int yconvhplj(y)
    double y;
{
    return ((int) (win_h * yconv(y)));
}

void hpljsetfont(n)
    int n;
{
    flush_pending();
    hselectfont(hpljfont = n);
}

int hpljsetcolor(c)
    int c;
{
    flush_pending();
    if (c) {
	c = c % MAXCOLOR;
    }
    b.width = c;
    hpljcolor = c;

    return c;
}

void hpljdrawtic(x, y, dir, updown)
    int x, y, dir, updown;
{
    switch (dir) {
    case 0:
	switch (updown) {
	case 0:
	    drawhplj(x, y, 0);
	    drawhplj(x, y + devxticl, 1);
	    break;
	case 1:
	    drawhplj(x, y, 0);
	    drawhplj(x, y - devxticl, 1);
	    break;
	}
	break;
    case 1:
	switch (updown) {
	case 0:
	    drawhplj(x, y, 0);
	    drawhplj(x + devyticl, y, 1);
	    break;
	case 1:
	    drawhplj(x, y, 0);
	    drawhplj(x - devyticl, y, 1);
	    break;
	}
	break;
    }
}

void dispstrhplj(x, y, rot, s)
    int x, y, rot;
    char *s;
{
    flush_pending();
    puthersh(x, y, hpljcharsize * charsize, rot, hpljcolor, vector, s);
}

int hpljsetlinestyle(style)
    int style;
{
    flush_pending();
    if (style)
	tex.pattern = patterns[style - 1];	/* Which pattern to use */
    return (hpljlinestyle = style);
}

void hpljleavegraphics()
{
    flush_pending();
    hpljsetmode(hpljdmode + 1);
}

void hpljinitgraphics(dmode)
{
    x1 = 99999;
    y1 = 99999;
    hpljdmode = dmode;
    hpljsetmode(dmode);
    devconvx = xconvhplj;
    devconvy = yconvhplj;
    vector = drawhplj;
    devwritestr = dispstrhplj;
    devsetcolor = hpljsetcolor;
    devsetfont = hpljsetfont;
    devsetline = hpljsetlinestyle;
    devdrawtic = hpljdrawtic;
    devleavegraphics = hpljleavegraphics;
    devcharsize = hpljcharsize;
    hpljsetcolor(1);
    hpljsetlinestyle(1);
}
