/**********************************************************************/
/*                                                                    */
/*                File mva.c:  Single Class Exact MVA                 */
/*                                                                    */
/*  This is the queueing network analysis program of Figure 3.5, with */
/*  "main()" revised to provide simple parameter input facilities.    */
/*  It analyzes the performance of a simple closed queueing network,  */
/*  assumed to represent a timesharing system, which has K first-in,  */
/*  first-out service centers and N terminals with a mean think time  */
/*  of Z.  (Alternatively, the network can be viewed as representing  */
/*  a batch system with a multiprogramming level of N;  in this case, */
/*  Z should be set to 0.)                                            */
/*                                                                    */
/**********************************************************************/

#include <stdio.h>

typedef double real;
#define then

#define mxK 9       /* max. no. of service centers +1    */

real D[mxK],        /* D[k] = service demand at center k */
     R[mxK],        /* R[k] = residence time at center k */
     Q[mxK],        /* Q[k] = no. customers at center k  */
     Z;             /* think time (0 for batch system)   */
int  K,             /* no. of centers (excl. terminals)  */
     N;             /* no. of customers                  */

main()
  {
    int k; char s[8]; double atof();
    while (1)
      { /* exit if [RETURN] response for K */
        printf("\nenter no. of centers (K): "); gets(s);
        if (s[0]=='\0') then break; else K=atoi(s);
        for (k=1; k<=K; k++)
          {
            printf("enter demand at center %d (D[%d]): ",k,k);
            gets(s); D[k] = atof(s);
          }
        printf("enter think time (Z):"); gets(s); Z = atof(s);
        while (1)
          { /* get N & analyze until [RETURN] response for K */
            printf("enter no. of terminals (N): ");  gets(s);
           if (s[0]=='\0') then break; else {N=atoi(s); mva();}
          }
      }
  }

mva()
  {
    int k,n; real s,X;
    for (k=1; k<=K; k++) Q[k]=0.0;
    for (n=1; n<=N; n++)
      {
        for (k=1; k<=K; k++) R[k]=D[k]*(1.0+Q[k]);
        s=Z; for (k=1; k<=K; k++) s+=R[k]; X=(real)n/s;
        for (k=1; k<=K; k++) Q[k]=X*R[k];
      }
    printf(" k     Rk      Qk     Uk\n");
    for (k=1; k<=K; k++)
      printf("%2d%9.3f%7.3f%7.3f\n",k,R[k],Q[k],X*D[k]);
    printf("\nX = %7.4f, R = %9.3f\n",X,(real)N/X-Z);
  }
