program listdir(output);
var
   d : dir;
   filename : string;

   function IsDir(name : string) : boolean;
   var
      mode : integer;
   begin
      getfilemode(name, mode);
      IsDir := (mode and dir_bit) <> 0;
   end;

begin
   opendir(d, '.');  { Open current directory }
   repeat
      readdir(d, filename);  { Get next file in directory }
      { if the next file exists and it is a directory then list it }
      if (filename <> '') and (IsDir(filename)) then
          writeln(filename);
   until filename = '';
   closedir(d) { Close directory }
end.
