.code

;  copied largely from Wikipedia article on Spin Locks - GH 21 Mar 2007

_XstSleepLock@4:
XstSleepLock frame loc
	:
	mov eax,1												; Set the EAX register to 1.
	xchg eax,[loc]									; Atomically swap the EAX register with	the lock variable.
																	; This will always store 1 to the lock, leaving
																	;	previous value in the EAX register.
	test eax,eax										; Test EAX with itself. Among other things, this will
																	;	set the processor's Zero Flag if EAX is 0.
																	; If EAX is 0, then the lock was unlocked and we just locked it.
																	; Otherwise, EAX is 1 and we didn't acquire the lock.
	jz >														; Jump back to the XCHG instruction if the Zero Flag is
	invoke _Sleep@4,0								;	not set, the lock was locked, and we need to give
	jmp <														; the timeslice to another thread.
	:
	ret															; The lock has been acquired, return to the calling function.
	endf


_XstSleepUnlock@4:
XstSleepUnlock frame loc
	xor eax,eax											; Set the EAX register to 0.
	xchg eax,[loc]		 							; Atomically swap the EAX register with
																	;	the lock variable.
	ret										 					; The lock has been released.
	endf