.code
;
; *************************
; *****  %_abs.slong  *****  ABS(x)
; *****  %_abs.xlong  *****
; *************************
;
; in:	arg0 = source number
; out:	eax = absolute value of source number
;
; destroys: nothing
;
; Generates overflow trap if source number is 0x80000000.
;
%_abs.slong:
%_abs.xlong:
	mov	eax,[esp+4]	        				;eax = source number
	or	eax,eax             				;less than zero?
	jns	> abs_ret       						;no: it's already its own absolute value
	cmp	eax,0x80000000	    				;cannot represent as positive signed number?
	je	> gen_overflow  						;cannot: so generate an overflow
	neg	eax		              				;eax = ABS(source number)
abs_ret:
	ret
;
gen_overflow:
call	%_eeeOverflow       				;Return from there
