.code
;
; *************************
; *****  %_lcase.d.s  *****  LCASE$(x$) and UCASE$(x$)
; *****  %_lcase.d.v  *****
; *****  %_ucase.d.s  *****
; *****  %_ucase.d.v  *****
; *************************
;
; in:	arg0 - > string to convert
; out:	eax -> converted string
;
; destroys: ebx, ecx, edx, esi, edi
;
; .s routines convert string at arg0
; .v routines create a new string.
;
%_lcase.d.s:
mov	ebx,addr %_uctolc   					; ebx -> table to convert to lower case
jmp	> xcase.d.s     							; branch to common routine
;
%_ucase.d.s:
mov	ebx,addr %_lctouc   					; ebx -> table to convert to upper case
;                       					; fall through
xcase.d.s:
mov	esi,[esp+4]         					; esi -> string to convert
cld
or	esi,esi             					; null pointer?
jz	> xcase_ret       						; yes: nothing to do
mov	ecx,[esi-8]         					; ecx = length of input string
mov	edi,esi             					; edi -> input string, which is also output string
xcase_d_s_loop:
jecxz	> xcase_ret       					; quit loop if reached last character
lodsb                   					; get next char
xlatb                   					; convert char
stosb                   					; store it
dec	ecx                 					; bump character counter
jmp	xcase_d_s_loop      					; do next character
xcase_ret:
mov	eax,[esp+4]
ret
;
;
%_lcase.d.v:
mov	ebx,addr %_uctolc   					; ebx -> table to convert upper to lower
jmp	> xcase.d.v     							; branch to common routine
;
%_ucase.d.v:
mov	ebx,addr %_lctouc   					; ebx -> table to convert to upper case
;;
;                       					; fall through
;;
xcase.d.v:
mov	esi,[esp+4]         					; esi -> string to convert
or	esi,esi             					; null pointer?
jz	< xcase_ret       						; yes: nothing to do
push	ebx               					; save pointer to translation table
mov	esi,[esi-8]         					; esi = length of result string
inc	esi                 					; add one for null terminator
call	%____calloc       					; esi -> result string
mov	eax,0               					; eax = system/user bit
or	eax,0x80130001      					; eax = info word for allocated string
mov	[esi-4],eax         					; store info word
pop	ebx                 					; ebx -> translation table
mov	edi,esi             					; edi -> result string
mov	edx,esi             					; save pointer so we can return it later
mov	esi,[esp+4]         					; esi -> source string
mov	ecx,[esi-8]         					; ecx = length of source string
mov	[edi-8],ecx         					; store length into result string
xcase_d_v_loop:
jecxz	> xcase_d_v_ret   					; exit loop if all characters have been copied
lodsb                   					; fetch character from source string
xlatb                   					; convert its case
stosb                   					; store character to result string
dec	ecx                 					; bump character counter
jmp	xcase_d_v_loop      					; do next character
xcase_d_v_ret:
mov	b[edi],0    									; write null terminator
mov	eax,edx             					; eax -> result string
ret


; ******************************************************
; *****  TABLE TO CONVERT LOWER CASE TO UPPER CASE  ****
; ******************************************************
;
.const
align	8
%_lctouc:
db	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07
db	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
db	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17
db	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F
db	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27
db	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F
db	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37
db	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F
db	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47
db	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F
db	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57
db	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F
db	0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47
db	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F
db	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57
db	0x58, 0x59, 0x5A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F
db	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87
db	0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F
db	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97
db	0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F
db	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7
db	0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF
db	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7
db	0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF
db	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7
db	0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF
db	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7
db	0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF
db	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7
db	0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF
db	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7
db	0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF


; *******************************************************
; *****  TABLE TO CONVERT UPPER CASE TO LOWER CASE  *****
; *******************************************************
;
.const
align	8
%_uctolc:
db	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07
db	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
db	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17
db	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F
db	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27
db	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F
db	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37
db	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F
db	0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67
db	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F
db	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77
db	0x78, 0x79, 0x7A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F
db	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67
db	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F
db	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77
db	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F
db	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87
db	0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F
db	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97
db	0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F
db	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7
db	0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF
db	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7
db	0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF
db	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7
db	0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF
db	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7
db	0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF
db	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7
db	0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF
db	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7
db	0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
