.code
;
; ****************************
; *****  %_mul.SCOMPLEX  *****  z3 = z1 * z2
; ****************************
;
; in:	eax -> z3 (result)
;	esi -> z1
;	edi -> z2
; out:	eax -> z3 (result)
;
; destroys: nothing
;
; Re(z3) = Re(z1) * Re(z2) - Im(z1) * Im(z2)
; Im(z3) = Re(z1) * Im(z2) + Im(z1) * Re(z2)
;

%_mul.SCOMPLEX:
fld	d[esi]												; calculate real part of product
fld	d[edi]
fmul
fld	d[esi+4]
fld	d[edi+4]
fmul
fsub
fstp	d[eax]
fld	d[esi]												; calculate imaginary part of product
fld	d[edi+4]
fmul
fld	d[esi+4]
fld	d[edi]
fmul
fadd
fstp	d[eax+4]
ret
