.code
; **********************************************************
; This one really needs to be broken into smaller objects!
; **********************************************************
;
; *********************************
; *****  %_cv.slong.to.sbyte  *****
; *****  %_cv.ulong.to.sbyte  *****
; *****  %_cv.xlong.to.sbyte  *****
; *********************************
;
; in:	arg0 = xlong
; out:	eax = equivalent sbyte
;
; destroys: nothing
;
%_cv.slong.to.sbyte:
%_cv.ulong.to.sbyte:
%_cv.xlong.to.sbyte:
movsx	eax,b[esp+4] 								; eax = converted sbyte
cmp	eax,[esp+4]										; any of those high-order bits changed?
je	> ret1												; no: sign-extension occurred w/o change of d
call	%_eeeOverflow								; Return from there
ret1:
ret
;
; *********************************
; *****  %_cv.slong.to.ubyte  *****
; *****  %_cv.ulong.to.ubyte  *****
; *****  %_cv.xlong.to.ubyte  *****
; *********************************
;
; in:	arg0 = xlong
; out:	eax = equivalent ubyte
;
; destroys: nothing
;
%_cv.slong.to.ubyte:
%_cv.ulong.to.ubyte:
%_cv.xlong.to.ubyte:
movzx	eax,b[esp+4] 								; eax = converted ubyte
cmp	eax,[esp+4]										; any high-order bits changed?
je	> ret2												; no: conversion occurred w/o loss of data
call	%_eeeOverflow								; Return from there
ret2:
ret
;
; **********************************
; *****  %_cv.slong.to.sshort  *****
; *****  %_cv.ulong.to.sshort  *****
; *****  %_cv.xlong.to.sshort  *****
; **********************************
;
; in:	arg0 = xlong
; out:	eax = equivalent sshort
;
; destroys: nothing
;
%_cv.slong.to.sshort:
%_cv.ulong.to.sshort:
%_cv.xlong.to.sshort:
movsx	eax,w[esp+4] 								; eax = converted sshort
cmp	eax,[esp+4]										; any high-order bits changed?
je	> ret3												; no: conversion occurred w/o loss of data
call	%_eeeOverflow								; Return from there
ret3:
ret
;
; **********************************
; *****  %_cv.slong.to.ushort  *****
; *****  %_cv.ulong.to.ushort  *****
; *****  %_cv.xlong.to.ushort  *****
; **********************************
;
; in:	arg0 = xlong
; out:	eax = equivalent ushort
;
; destroys: nothing
;
%_cv.slong.to.ushort:
%_cv.ulong.to.ushort:
%_cv.xlong.to.ushort:
movzx	eax,w[esp+4] 								; eax = converted ushort
cmp	eax,[esp+4]										; any high-order bits changed?
je	> ret4												; no: conversion occurred w/o loss of data
call	%_eeeOverflow								; Return from there
ret4:
ret
;
;
; *********************************
; *****  %_cv.slong.to.slong  *****
; *****  %_cv.slong.to.ulong  *****
; *****  %_cv.slong.to.xlong  *****
; *****  %_cv.slong.to.subaddr  ***
; *****  %_cv.slong.to.goaddr  ****
; *****  %_cv.slong.to.funcaddr  **
; *****  %_cv.ulong.to.slong  *****
; *****  %_cv.ulong.to.ulong  *****
; *****  %_cv.ulong.to.xlong  *****
; *****  %_cv.ulong.to.subaddr  ***
; *****  %_cv.ulong.to.goaddr  ****
; *****  %_cv.ulong.to.funcaddr  **
; *****  %_cv.xlong.to.slong  *****
; *****  %_cv.xlong.to.ulong  *****
; *****  %_cv.xlong.to.xlong  *****
; *****  %_cv.xlong.to.subaddr  ***
; *****  %_cv.xlong.to.goaddr  ****
; *****  %_cv.xlong.to.funcaddr  **
; *********************************
;
; in:	arg0 = xlong
; out:	eax = converted value, which is always the same as arg0
;
; destroys: nothing
;
%_cv.slong.to.slong:
%_cv.slong.to.ulong:
%_cv.slong.to.xlong:
%_cv.slong.to.subaddr:
%_cv.slong.to.goaddr:
%_cv.slong.to.funcaddr:
%_cv.ulong.to.slong:
%_cv.ulong.to.ulong:
%_cv.ulong.to.xlong:
%_cv.ulong.to.subaddr:
%_cv.ulong.to.goaddr:
%_cv.ulong.to.funcaddr:
%_cv.xlong.to.slong:
%_cv.xlong.to.ulong:
%_cv.xlong.to.xlong:
%_cv.xlong.to.subaddr:
%_cv.xlong.to.goaddr:
%_cv.xlong.to.funcaddr:
mov	eax,[esp+4]
ret
;
; *********************************
; *****  %_cv.slong.to.giant  *****
; *****  %_cv.xlong.to.giant  *****
; *********************************
;
; in:	arg0 = xlong
; out:	edx:eax = equivalent giant
;
; destroys: nothing
;
%_cv.slong.to.giant:
%_cv.xlong.to.giant:
mov	eax,[esp+4]
cdq
ret
;
; *********************************
; *****  %_cv.ulong.to.giant  *****
; *********************************
;
; in:	arg0 = ulong
; out:	edx:eax = equivalent giant
;
; destroys: nothing
;
%_cv.ulong.to.giant:
mov	eax,[esp+4]
xor	edx,edx
ret
;
; **********************************
; *****  %_cv.slong.to.single  *****
; *****  %_cv.slong.to.double  *****
; *****  %_cv.slong.to.longdouble  *****
; *****  %_cv.xlong.to.single  *****
; *****  %_cv.xlong.to.double  *****
; *****  %_cv.xlong.to.longdouble  *****
; **********************************
;
; in:	arg0 = xlong
; out:	st(0) = equivalent floating-point number
;
; destroys: nothing
;
%_cv.slong.to.single:
%_cv.slong.to.double:
%_cv.slong.to.longdouble:
%_cv.xlong.to.single:
%_cv.xlong.to.double:
%_cv.xlong.to.longdouble:
fild	d[esp+4]
ret
;
; **********************************
; *****  %_cv.ulong.to.single  *****  xxxxxxxxxx
; *****  %_cv.ulong.to.double  *****
; *****  %_cv.ulong.to.longdouble  *****
; **********************************
;
; in:	arg0 = ulong
; out:	st(0) = equivalent floating-point number
;
; destroys: nothing
;
%_cv.ulong.to.single:
%_cv.ulong.to.double:
%_cv.ulong.to.longdouble:
push	0
push	[esp+8]
fild	Q[esp]
add	esp,8
ret
;
; *********************************
; *****  %_cv.giant.to.sbyte  *****
; *********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	eax = equivalent sbyte
;
; destroys: edx
;
%_cv.giant.to.sbyte:
movsx	eax,b[esp+4] 								; eax = converted lower eight bits
cmp	eax,[esp+4]										; no change in remaining bits of lsdword?
jne	> bad1												; there was a change: blow up
cdq																; sign-extend result into edx
cmp	edx,[esp+8]										; no change in bits of msdword
jne	> bad1												; there was a change: blow up
ret
;
bad1:
;	xor	eax,eax											; return a zero (is this a good idea?)
call	%_eeeOverflow								; Return from there
;
;
; *********************************
; *****  %_cv.giant.to.ubyte  *****
; *********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	eax = equivalent ubyte
;
; destroys: nothing
;
%_cv.giant.to.ubyte:
cmp	d[esp+8],0										;	high 32 better be all zero
jne	bad1													;	nope: blow up
movzx	eax,b[esp+4] 								;	extract lowest eight bits from low 32
cmp	eax,[esp+4]										;	remaining bits changed?
jne	bad1													;	yes: data was lost in conversion
ret
;
; **********************************
; *****  %_cv.giant.to.sshort  *****
; **********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	eax = equivalent sshort
;
; destroys: edx
;
%_cv.giant.to.sshort:
movsx	eax,w[esp+4] 								;	sign-extend lowest 16 bits of low 32
cmp	eax,[esp+4]										;	any of the remaining bits changed?
jne	bad1													;	yes: data was lost in conversion
cdq																;	sign-extend result into edx
cmp	edx,[esp+8]										;	any bits changed in high 32?
jne	bad1													;	yes: data was lost in conversion
ret
;
; **********************************
; *****  %_cv.giant.to.ushort  *****
; **********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	eax = equivalent ushort
;
; destroys: nothing
;
%_cv.giant.to.ushort:
cmp	d[esp+8],0										;	high 32 bits had better be zero
jne	bad1													;	nope: impossible to convert
movzx	eax,w[esp+4] 								;	extract lowest 8 bits of low 32
cmp	eax,[esp+4]										;	any of the remaining bits changed?
jne	bad1													;	yes: data was lost in conversion
ret
;
; *********************************
; *****  %_cv.giant.to.slong  *****
; *****  %_cv.giant.to.xlong  *****
; *********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	eax = equivalent slong or xlong
;
; destroys: edx
;
%_cv.giant.to.slong:
%_cv.giant.to.xlong:
mov	eax,[esp+4]										; get low 32 bits
cdq																; sign-extend result into edx
cmp	edx,[esp+8]										; high 32 bits the same?
jne	bad1													; no: data was lost in conversion
ret
;
; *********************************
; *****  %_cv.giant.to.ulong  *****
; *********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	eax = equivalent ulong
;
; destroys: nothing
;
%_cv.giant.to.ulong:
cmp	d[esp+8],0										; high 32 bits better all be zero
jne	bad1													; nope: impossible to convert
mov	eax,[esp+4]										; result is low 32 bits of giant
ret
;
; *********************************
; *****  %_cv.giant.to.giant  *****
; *********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	edx:eax = arg1:arg0
;
; destroys: nothing
;
%_cv.giant.to.giant:
mov	eax,[esp+4]										; eax = low 32 bits of giant
mov	edx,[esp+8]										; edx = high 32 bits of giant
ret
;
;
; **********************************
; *****  %_cv.giant.to.single  *****
; *****  %_cv.giant.to.double  *****
; *****  %_cv.giant.to.longdouble  *****
; **********************************
;
; in:	arg1 = high 32 bits of giant
;	arg0 = low 32 bits of giant
; out:	st(0) = equivalent floating-point number
;
; destroys: nothing
;
%_cv.giant.to.single:
%_cv.giant.to.double:
%_cv.giant.to.longdouble:
fild	Q[esp+4]
ret
;
;
; **********************************
; *****  %_cv.single.to.sbyte  *****
; **********************************
;
; in:	arg0 = single
; out:	eax = equivalent sbyte
;
; destroys: esi
;
%_cv.single.to.sbyte:
fld	d[esp+4]											; st(0) = input single
mov	esi,ADDR workdword						; shorten next three instructions
fistp	d[esi]											; convert input single to an integer
fwait
movsx	eax,b[esi] 									; sign-extend low eight bits
cmp	eax,[esi]											; any of the other bits changed?
jne	> bad2												; yes: data was lost in conversion
ret
bad2:
;	xor	eax,eax											; return a zero (is this a good idea?)
call	%_eeeOverflow								; Return from there
;
;
; **********************************
; *****  %_cv.single.to.ubyte  *****
; **********************************
;
; in:	arg0 = single
; out:	eax = equivalent ubyte
;
; destroys: esi
;
%_cv.single.to.ubyte:
fld	d[esp+4]											; st(0) = input single
mov	esi,ADDR workdword
fistp	d[esi]											; convert input single to integer
fwait
movzx	eax,b[esi] 									; extract lowest 8 bits
cmp	eax,[esi]											; no change in other bits?
jne	bad2													; other bits changed: error
ret
;
;
; ***********************************
; *****  %_cv.single.to.sshort  *****
; ***********************************
;
; in:	arg0 = single
; out:	eax = equivalent sshort
;
; destroys: esi
;
%_cv.single.to.sshort:
fld	d[esp+4]											; st(0) = input single
mov	esi,ADDR workdword						; shorten next three instructions
fistp	d[esi]											; convert input single to an integer
fwait
movsx	eax,w[esi] 									; sign-extend low 16 bits
cmp	eax,[esi]											; any of the other bits changed?
jne	bad2													; yes: data was lost in conversion
ret
;
;
; ***********************************
; *****  %_cv.single.to.ushort  *****
; ***********************************
;
; in:	arg0 = single
; out:	eax = equivalent ushort
;
; destroys: esi
;
%_cv.single.to.ushort:
fld	d[esp+4]											; st(0) = input single
mov	esi,ADDR workdword
fistp	d[esi]											; convert input single to integer
fwait
movzx	eax,w[esi] 									; extract lowest 16 bits
cmp	eax,[esi]											; no change in other bits?
jne	bad2													; other bits changed: error
ret
;
;
; **********************************
; *****  %_cv.single.to.slong  *****
; *****  %_cv.single.to.xlong  *****
; **********************************
;
; in:	arg0 = single
; out:	eax = equivalent slong or xlong
;
; destroys: nothing
;
%_cv.single.to.slong:
%_cv.single.to.xlong:
fld	d[esp+4]											; st(0) = input single
fistp	d[workdword]								; convert it to integer
fwait
mov	eax,[workdword]
ret																; no overflow possible (?)
;
;
; **********************************
; *****  %_cv.single.to.ulong  *****
; **********************************
;
; in:	arg0 = single
; out:	eax = equivalent ulong
;
; destroys: esi
;
%_cv.single.to.ulong:
fld	d[esp+4]											; st(0) = input single
mov	esi,ADDR workdword
fistp	d[esi]											; convert it to integer
fwait
mov	eax,[esi]
or	eax,eax												; it's not negative, is it?
js	bad2													; 'fraid so
ret
;
;
; **********************************
; *****  %_cv.single.to.giant  *****
; **********************************
;
; in:	arg0 = single
; out:	edx:eax = equivalent giant
;
; destroys: nothing
;
%_cv.single.to.giant:
fld	d[esp+4]											; st(0) = input single
fistp	Q[workqword] 								; convert it to integer
fwait
mov	eax,[workqword]								; eax = low 32 bits of result
mov	edx,[workqword+4] 						; edx = high 32 bits of result
ret
;
; ***************************************
; *****  %_cv.single.to.single      *****
; *****  %_cv.single.to.double      *****
; *****  %_cv.single.to.longdouble  *****
; ***************************************
;
; in:	arg0 = single
; out:	st(0) = equivalent floating-point number
;
; destroys: nothing
;
%_cv.single.to.single:
%_cv.single.to.double:
%_cv.single.to.longdouble:
fld	d[esp+4]											; st(0) = input single
ret
;
;
; **********************************
; *****  %_cv.double.to.sbyte  *****
; **********************************
;
; in:	arg1:arg0 = double
; out:	eax = equivalent sbyte
;
; destroys: esi
;
%_cv.double.to.sbyte:
fld	Q[esp+4] 											; st(0) = input double
mov	esi,ADDR workdword						; shorten next three instructions
fistp	d[esi]											; convert input double to an integer
fwait
movsx	eax,b[esi] 									; sign-extend low eight bits
cmp	eax,[esi]											; any of the other bits changed?
jne	> bad3												; yes: data was lost in conversion
ret
bad3:
;	xor	eax,eax											; return zero (is this a good idea?)
call	%_eeeOverflow								; Return from there
;
;
; **********************************
; *****  %_cv.double.to.ubyte  *****
; **********************************
;
; in:	arg1:arg0 = double
; out:	eax = equivalent ubyte
;
; destroys: esi
;
%_cv.double.to.ubyte:
fld	Q[esp+4] 											; st(0) = input double
mov	esi,ADDR workdword
fistp	d[esi]								      ; convert input double to integer
fwait
movzx	eax,b[esi] 									; extract lowest 8 bits
cmp	eax,[esi]											; no change in other bits?
jne	bad3													; other bits changed: error
ret
;
;
; ***********************************
; *****  %_cv.double.to.sshort  *****
; ***********************************
;
; in:	arg1:arg0 = double
; out:	eax = equivalent sshort
;
; destroys: esi
;
%_cv.double.to.sshort:
fld	Q[esp+4] 											;	st(0) = input double
mov	esi,ADDR workdword						; shorten next three instructions
fistp	d[esi]											; convert input double to an integer
fwait
movsx	eax,w[esi] 									; sign-extend low 16 bits
cmp	eax,[esi]											; any of the other bits changed?
jne	bad3													; yes: data was lost in conversion
ret
;
;
; ***********************************
; *****  %_cv.double.to.ushort  *****
; ***********************************
;
; in:	arg1:arg0 = double
; out:	eax = equivalent ushort
;
; destroys: esi
;
%_cv.double.to.ushort:
fld	Q[esp+4] 											; st(0) = input double
mov	esi,ADDR workdword
fistp	d[esi]											; convert input double to integer
fwait
movzx	eax,w[esi] 									; extract lowest 16 bits
cmp	eax,[esi]											; no change in other bits?
jne	bad3													; other bits changed: error
ret
;
;
; **********************************
; *****  %_cv.double.to.slong  *****
; *****  %_cv.double.to.xlong  *****
; **********************************
;
; in:	arg1:arg0 = double
; out:	eax = equivalent slong or xlong
;
; destroys: nothing
;
%_cv.double.to.slong:
%_cv.double.to.xlong:
fld	Q[esp+4] 											; st(0) = input double
fistp	d[workdword]								; convert it to integer
fwait
mov	eax,[workdword]
ret																; no overflow possible (?)
;
;
; **********************************
; *****  %_cv.double.to.ulong  *****
; **********************************
;
; in:	arg1:arg0 = double
; out:	eax = equivalent ulong
;
; destroys: esi
;
%_cv.double.to.ulong:
fld	Q[esp+4] 											; st(0) = input double
mov	esi,ADDR workdword
fistp	d[esi]											; convert it to integer
fwait
mov	eax,[esi]
or	eax,eax												; it's not negative, is it?
js	bad3													; 'fraid so
ret
;
;
; **********************************
; *****  %_cv.double.to.giant  *****
; **********************************
;
; in:	arg1:arg0 = double
; out:	edx:eax = equivalent giant
;
; destroys: nothing
;
%_cv.double.to.giant:
fld	Q[esp+4] 											; st(0) = input double
fistp	Q[workqword] 								; convert it to integer
fwait
mov	eax,[workqword]								; eax = low 32 bits of result
mov	edx,[workqword+4] 			      ; edx = high 32 bits of result
ret
;
;
; ***************************************
; *****  %_cv.double.to.single      *****
; *****  %_cv.double.to.double      *****
; *****  %_cv.double.to.longdouble  *****
; ***************************************
;
; in:	arg1:arg0 = double
; out:	st(0) = equivalent floating-point number
;
; destroys: nothing
;
%_cv.double.to.single:
%_cv.double.to.double:
%_cv.double.to.longdouble:
fld	Q[esp+4] 											; st(0) = input double
ret
;
;
; **************************************
; *****  %_cv.longdouble.to.sbyte  *****
; **************************************
;
; in:	arg1:arg0 = longdouble
; out:	eax = equivalent sbyte
;
; destroys: esi
;
%_cv.longdouble.to.sbyte:
fld	T[esp+4] 											; st(0) = input longdouble
mov	esi,ADDR workdword						; shorten next three instructions
fistp	d[esi]											; convert input longdouble to an integer
fwait
movsx	eax,b[esi] 									; sign-extend low eight bits
cmp	eax,[esi]											; any of the other bits changed?
jne	bad3													; yes: data was lost in conversion
ret
;
;
; **************************************
; *****  %_cv.longdouble.to.ubyte  *****
; **************************************
;
; in:	arg1:arg0 = longdouble
; out:	eax = equivalent ubyte
;
; destroys: esi
;
%_cv.longdouble.to.ubyte:
fld	T[esp+4] 											; st(0) = input longdouble
mov	esi,ADDR workdword
fistp	d[esi]											; convert input longdouble to integer
fwait
movzx	eax,b[esi] 									; extract lowest 8 bits
cmp	eax,[esi]											; no change in other bits?
jne	bad3													; other bits changed: error
ret
;
;
; ***************************************
; *****  %_cv.longdouble.to.sshort  *****
; ***************************************
;
; in:	arg1:arg0 = longdouble
; out:	eax = equivalent sshort
;
; destroys: esi
;
%_cv.longdouble.to.sshort:
fld	T[esp+4] 											; st(0) = input longdouble
mov	esi,ADDR workdword						; shorten next three instructions
fistp	d[esi]											; convert input longdouble to an integer
fwait
movsx	eax,w[esi] 									; sign-extend low 16 bits
cmp	eax,[esi]											; any of the other bits changed?
jne	bad3													; yes: data was lost in conversion
ret
;
;
; ***************************************
; *****  %_cv.longdouble.to.ushort  *****
; ***************************************
;
; in:	arg1:arg0 = longdouble
; out:	eax = equivalent ushort
;
; destroys: esi
;
%_cv.longdouble.to.ushort:
fld	T[esp+4] 											; st(0) = input longdouble
mov	esi,ADDR workdword
fistp	d[esi]											; convert input longdouble to integer
fwait
movzx	eax,w[esi] 									; extract lowest 16 bits
cmp	eax,[esi]											; no change in other bits?
jne	bad3													; other bits changed: error
ret
;
;
; **************************************
; *****  %_cv.longdouble.to.slong  *****
; *****  %_cv.longdouble.to.xlong  *****
; **************************************
;
; in:	arg1:arg0 = longdouble
; out:	eax = equivalent slong or xlong
;
; destroys: nothing
;
%_cv.longdouble.to.slong:
%_cv.longdouble.to.xlong:
fld	T[esp+4] 											; st(0) = input longdouble
fistp	d[workdword]								; convert it to integer
fwait
mov	eax,[workdword]
ret																; no overflow possible (?)
;
;
; **************************************
; *****  %_cv.longdouble.to.ulong  *****
; **************************************
;
; in:	arg1:arg0 = longdouble
; out:	eax = equivalent ulong
;
; destroys: esi
;
%_cv.longdouble.to.ulong:
fld	T[esp+4] 											; st(0) = input double
mov	esi,ADDR workdword
fistp	d[esi]											; convert it to integer
fwait
mov	eax,[esi]
or	eax,eax												; it's not negative, is it?
js	bad3													; 'fraid so
ret
;
;
; **************************************
; *****  %_cv.longdouble.to.giant  *****
; **************************************
;
; in:	arg1:arg0 = longdouble
; out:	edx:eax = equivalent giant
;
; destroys: nothing
;
%_cv.longdouble.to.giant:
fld	T[esp+4] 											; st(0) = input double
fistp	Q[workqword] 								; convert it to integer
fwait
mov	eax,[workqword]								; eax = low 32 bits of result
mov	edx,[workqword+4] 						; edx = high 32 bits of result
ret
;
;
; *******************************************
; *****  %_cv.longdouble.to.single      *****
; *****  %_cv.longdouble.to.double      *****
; *****  %_cv.longdouble.to.longdouble  *****
; *******************************************
;
; in:	arg1:arg0 = longdouble
; out:	st(0) = equivalent floating-point number
;
; destroys: nothing
;
%_cv.longdouble.to.single:
%_cv.longdouble.to.double:
%_cv.longdouble.to.longdouble:
fld	T[esp+4] 											; st(0) = input double
ret
;
;
; **************************
; *****  ns.convert.x  *****  generic string-to-number conversion routine
; **************************  internal entry point
;
; in:	arg0 -> string to convert
;	ebx -> string to free on exit, if any
;	ecx -> table of pointers to conversion routines
; out:	result is in eax, edx:eax, or st(0), depending on its type
;
; destroys: eax, ebx, ecx, edx, esi, edi (except for registers that
;					  contain return values)
; local variables:
;	[ebp-4] -> string to free on exit, if any
;	[ebp-8] -> table of pointers to conversion routines
;
; The tables to the pointers to conversion routines are documented
; later in this source file.
;
ns.convert.x:
push	ebp													; ditto
mov	ebp,esp												; ditto
sub	esp,8													; room for two local variables
;
mov	[ebp-4],ebx										; save pointer to string to free on exit
mov	[ebp-8],ecx										; save pointer to table of conversion routines
;
push	0														; arg 6
push	0														; arg 5
push	0														; arg 4
push	0														; arg 3
push	0														; arg 2
push	[ebp+8]											; arg 1 = numeric string
;;
call	_XstStringToNumber@24				; convert string to some numeric type
mov	ebx,[esp-12]									; ebx = valueType
mov	ecx,[esp-8]										; ecx = lo 32 bits of value$$
mov	edx,[esp-4]										; edx = hi 32 bits of value$$
mov	esi,[ebp-4]										; esi -> string to free on exit, if any
call	%____free
;;
xor	eax,eax												; eax = index into pointer table for SLONG
cmp	ebx,6													; valueType == $$SLONG ???
je	> ns_nn_convert 							; yes: convert it
inc	eax														; eax = index into pointer table for XLONG
cmp	ebx,8													; valueType == $$XLONG ???
je	> ns_nn_convert 							; yes: convert it
;;
or	ebx,ebx												; valueType == 0 ???  (invalid number)
je	> ns_nn_zero 									; yes: return zero as XLONG
;;
inc	eax														; eax = index into pointer table for GIANT
cmp	ebx,12												; valueType == $$GIANT ???
je	> ns_nn_convert 							; yes: convert it
inc	eax														; eax = index into pointer table for SINGLE
cmp	ebx,13												; valueType == $$SINGLE ???
je	> ns_nn_convert 							; yes: convert it
inc	eax														; eax = index into pointer table for DOUBLE
cmp	ebx,14												; valueType == $$DOUBLE ???
je	> ns_nn_convert 							; yes: convert it
;
; error:  return 0		; something very screwy here
;
xor	ecx,ecx												; set value$$ to zero
xor	edx,edx
push	edx													; pass edx:ecx to numeric-to-numeric conversion
push	ecx													; routine
mov	ebx,[ebp-8]										; ebx -> table of pointers to conversion routines
call	[ebx+eax*4]									; call nn conversion routine
; result is now wherever it's supposed to be
mov	esp,ebp
pop	ebp
jmp	%_InvalidFunctionCall					; return directly from there
; LOOSE END
ns_nn_zero:
xor	ecx,ecx												; set value$$ to zero
xor	edx,edx
ns_nn_convert:
push	edx													; pass edx:ecx to numeric-to-numeric conversion	xxx del
push	ecx													; routine					xxx del
mov	ebx,[ebp-8]										; ebx -> table of pointers to conversion routines xx del
call	[ebx+eax*4]									; call nn conversion routine			xxx del
;result is now wherever it's supposed to be	xxx del
mov	esp,ebp												;						xxx del
pop	ebp														;						xxx del
ret																;						xxx del
;
;	jmp, not call, for error handling
;	arg1 = edx	;assumes arg1 is available!!!
;	arg0 = ecx
;	Presumes calling routine creates 64 byte stack
;	  (eg	sub	esp,64
;		call	%cv.string.to.xlong.s
;		add	esp,64)
;
mov	ebx,[ebp-8]										; ebx -> table of pointers to conversion routines xx add
mov	esp,ebp												;						xxx add
pop	ebp														;						xxx add
pop	esi														; save return address				xxx add
mov	[esp+4],edx										; pass edx:ecx to numeric-to-numeric conversion	xxx add
mov	[esp],ecx											;  routine					xxx add
push	esi													; restore return address				xxx add
jmp	[ebx+eax*4]										; jmp to nn conversion routine			xxx add
;				;result is now wherever it's supposed to be	xxx add
;
; **************************************************
; *****  string-to-number conversion routines  *****
; **************************************************
;
; in:	arg0 -> string
; out:	result is in eax, edx:eax, or st(0), depending on its type
;
; destroys: eax, ebx, ecx, edx, esi, edi (except for registers that
;					  contain return values)
;
; All string-to-number conversion routines load up parameters for
; ns.convert.x and then branch to it.
;
%_cv.string.to.sbyte.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_sbyte
jmp	ns.convert.x
;
%_cv.string.to.sbyte.v:
xor	ebx,ebx
mov	ecx,ADDR to_sbyte
jmp	ns.convert.x
;
%_cv.string.to.ubyte.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_ubyte
jmp	ns.convert.x
;
%_cv.string.to.ubyte.v:
xor	ebx,ebx
mov	ecx,ADDR to_ubyte
jmp	ns.convert.x
;
%_cv.string.to.sshort.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_sshort
jmp	ns.convert.x
;
%_cv.string.to.sshort.v:
xor	ebx,ebx
mov	ecx,ADDR to_sshort
jmp	ns.convert.x
;
%_cv.string.to.ushort.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_ushort
jmp	ns.convert.x
;
%_cv.string.to.ushort.v:
xor	ebx,ebx
mov	ecx,ADDR to_ushort
jmp	ns.convert.x
;
%_cv.string.to.slong.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_slong
jmp	ns.convert.x
;
%_cv.string.to.slong.v:
xor	ebx,ebx
mov	ecx,ADDR to_slong
jmp	ns.convert.x
;
%_cv.string.to.ulong.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_ulong
jmp	ns.convert.x
;
%_cv.string.to.ulong.v:
xor	ebx,ebx
mov	ecx,ADDR to_ulong
jmp	ns.convert.x
;
%_cv.string.to.xlong.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_xlong
jmp	ns.convert.x
;
%_cv.string.to.xlong.v:
xor	ebx,ebx
mov	ecx,ADDR to_xlong
jmp	ns.convert.x
;
%_cv.string.to.giant.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_giant
jmp	ns.convert.x
;
%_cv.string.to.giant.v:
xor	ebx,ebx
mov	ecx,ADDR to_giant
jmp	ns.convert.x
;
%_cv.string.to.single.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_single
jmp	ns.convert.x
;
%_cv.string.to.single.v:
xor	ebx,ebx
mov	ecx,ADDR to_single
jmp	ns.convert.x
;
%_cv.string.to.double.s:
mov	ebx,[esp+4]
mov	ecx,ADDR to_double
jmp	ns.convert.x
;
%_cv.string.to.double.v:
xor	ebx,ebx
mov	ecx,ADDR to_double
jmp	ns.convert.x
;
;
%_cv.string.to.longdouble.s:
mov	ebx,[esp+4]
push	ebp
mov	ebp,esp
sub	esp,4
mov	[ebp-4],ebx										; save pointer to string to free on exit
push	0
push	0
push	0
push	0
push	0
push	0
push	[ebp+8]											; string
call	_XstStringToLongDouble@28
fld	T[esp-12]											; long double value
mov	esi,[ebp-4]										; esi -> string to free on exit, if any
call	%____free
mov	esp,ebp
pop	ebp
ret
;
;
%_cv.string.to.longdouble.v:
xor	ebx,ebx
push	ebp
mov	ebp,esp
sub	esp,4
mov	[ebp-4],ebx										; save pointer to string to free on exit
push	0
push	0
push	0
push	0
push	0
push	0
push	[ebp+8]											; string
call	_XstStringToLongDouble@28
fld	T[esp-12]											; long double value
mov	esi,[ebp-4]										; esi -> string to free on exit, if any
call	%____free
mov	esp,ebp
pop	ebp
ret
;
;
; *******************************************************
; *****  TABLES OF POINTERS TO CONVERSION ROUTINES  *****
; *******************************************************
;
; Each table contains five pointers to conversion routines that convert a
; number to a single type T.  The five pointers, in the order in which
; they appear in each table, are to conversion routines to convert:
;
;	from SLONG to T
;	from XLONG to T
;	from GIANT to T
;	from SINGLE to T
;	from DOUBLE to T
;
.const
align	8
to_sbyte:
dd	%_cv.slong.to.sbyte
dd	%_cv.xlong.to.sbyte
dd	%_cv.giant.to.sbyte
dd	%_cv.single.to.sbyte
dd	%_cv.double.to.sbyte
to_ubyte:
dd	%_cv.slong.to.ubyte
dd	%_cv.xlong.to.ubyte
dd	%_cv.giant.to.ubyte
dd	%_cv.single.to.ubyte
dd	%_cv.double.to.ubyte
to_sshort:
dd	%_cv.slong.to.sshort
dd	%_cv.xlong.to.sshort
dd	%_cv.giant.to.sshort
dd	%_cv.single.to.sshort
dd	%_cv.double.to.sshort
to_ushort:
dd	%_cv.slong.to.ushort
dd	%_cv.xlong.to.ushort
dd	%_cv.giant.to.ushort
dd	%_cv.single.to.ushort
dd	%_cv.double.to.ushort
to_slong:
dd	%_cv.slong.to.slong
dd	%_cv.xlong.to.slong
dd	%_cv.giant.to.slong
dd	%_cv.single.to.slong
dd	%_cv.double.to.slong
to_ulong:
dd	%_cv.slong.to.ulong
dd	%_cv.xlong.to.ulong
dd	%_cv.giant.to.ulong
dd	%_cv.single.to.ulong
dd	%_cv.double.to.ulong
to_xlong:
dd	%_cv.slong.to.xlong
dd	%_cv.xlong.to.xlong
dd	%_cv.giant.to.xlong
dd	%_cv.single.to.xlong
dd	%_cv.double.to.xlong
to_giant:
dd	%_cv.slong.to.giant
dd	%_cv.xlong.to.giant
dd	%_cv.giant.to.giant
dd	%_cv.single.to.giant
dd	%_cv.double.to.giant
to_single:
dd	%_cv.slong.to.single
dd	%_cv.xlong.to.single
dd	%_cv.giant.to.single
dd	%_cv.single.to.single
dd	%_cv.double.to.single
to_double:
dd	%_cv.slong.to.double
dd	%_cv.xlong.to.double
dd	%_cv.giant.to.double
dd	%_cv.single.to.double
dd	%_cv.double.to.double
;
;
;
.data
align	8
workdword:
dd	0xBADBEEF
;
align	8
workqword:
dd	0x98765432, 0xFEDCBA98
