/*
 * Decompiled with CFR 0.152.
 */
package filter;

import freejava.Mindenes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class FileChooserPreviewer
extends JComponent
implements PropertyChangeListener {
    private ImageIcon icon = null;
    private String text = null;
    private File f = null;
    private boolean megmutat = true;
    private int szelesseg = 140;

    public FileChooserPreviewer(JFileChooser jFileChooser) {
        this.enableEvents(2064L);
        this.setPreferredSize(new Dimension(this.szelesseg, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 500 && mouseEvent.getModifiers() == 16) {
            this.megmutat = !this.megmutat;
            this.repaint();
        }
    }

    public void load() {
        this.text = null;
        if (this.f != null) {
            ImageIcon imageIcon = new ImageIcon(this.f.getPath());
            this.icon = imageIcon.getIconWidth() > this.szelesseg - 10 ? new ImageIcon(imageIcon.getImage().getScaledInstance(this.szelesseg - 10, -1, 1)) : imageIcon;
            String string = this.f.getPath().toUpperCase();
            if (this.icon == null || this.icon.getIconHeight() == -1) {
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.f));
                    int n = bufferedInputStream.available();
                    if (n > 900) {
                        n = 900;
                    }
                    byte[] byArray = new byte[n];
                    bufferedInputStream.read(byArray, 0, byArray.length);
                    bufferedInputStream.close();
                    this.text = Mindenes.stringKonvertalas(new String(byArray, 0, byArray.length), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "SelectedFileChangedProperty") {
            this.f = (File)propertyChangeEvent.getNewValue();
            if (this.isShowing()) {
                if (this.megmutat) {
                    this.load();
                }
                this.repaint();
            }
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (!this.megmutat) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, this.getWidth(), this.getHeight());
            graphics.drawLine(0, this.getHeight(), this.getWidth(), 0);
            return;
        }
        if (this.icon == null) {
            this.load();
        } else {
            n2 = this.getWidth() / 2 - this.icon.getIconWidth() / 2;
            n = this.getHeight() / 2 - this.icon.getIconHeight() / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 5) {
                n2 = 5;
            }
            this.icon.paintIcon(this, graphics, n2, n);
        }
        if ((this.icon == null || this.icon.getIconHeight() == -1) && this.text != null) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, 0, this.getHeight());
            int n3 = this.getHeight();
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n", false);
            for (n = n2 = ((Component)this).getFontMetrics(this.getFont()).getHeight(); n < n3 && stringTokenizer.hasMoreTokens(); n += n2) {
                graphics.drawString(stringTokenizer.nextToken(), 4, n);
            }
        }
    }

    public void setSize(Dimension dimension) {
        if (dimension.width > 140) {
            this.szelesseg = dimension.width;
        }
        super.setSize(dimension);
        if (this.icon != null) {
            this.load();
        }
    }
}

