/************************************************************/
// This package has been developed by Wasif Safi
// In December, 2000. All are welcome to change the package 
// and use it as their individual needs.
/************************************************************/
// This is source-code for the Java Class that represents 
// individual HTML tags, and is the building block to 
// generate HTML files.
/************************************************************/
// The best use of these classes are through Servlets.
/************************************************************/
// Another advantage of using these classes is that
// since the source-code accompanies this package,
// these class-library for HTMl generation is extend-able
// One can add some more HTML Tags to support them and
// use them instantly from their programs.
/************************************************************/

package wasifsafi.html;

import java.util.*;
import java.util.jar.*;

public class component
{
	// Data members
	protected String tag;
	private Attributes parameters = new Attributes();
	private String content;

	private ArrayList children = new ArrayList();

	// Contructor & Destructor
	public component(String tag)
	{
		this.tag = tag;
		this.content = "";
	}

	public component(String tag, String content)
	{
		this.tag = tag.toString();
		this.content = content;
	}

	// Accessors & Mutators
	public void addParam(String paramName, String paramValue)
	{
		parameters.putValue(paramName, paramValue);
	}

	// Helper methods
	public boolean addChild(component child)
	{
		return children.add(child);
	}

	// Override the Object class methods
	public String toString()
	{
		StringBuffer htmlText = new StringBuffer();
		htmlText.append("<").append(tag);

		Iterator keySet = parameters.keySet().iterator();
		while( keySet.hasNext() )
		{
			String paramKey = keySet.next().toString();
			htmlText.append(" ").append(paramKey);
			htmlText.append("=\"").append(parameters.getValue(paramKey)).append("\"");
		}

		htmlText.append(">\n");

		htmlText.append(content).append("\n");

		Iterator childElement = children.iterator();
		while( childElement.hasNext() )
		{
			htmlText.append( childElement.next().toString() );
		}

		htmlText.append("</").append(tag).append(">\n");

		return htmlText.toString();
	}
}
