<?php

class Session {

    function get($aKey) {
        if (!session_id()) session_start();
        $res = array_key_exists($aKey,  $_SESSION) ? $_SESSION[$aKey] : null;
	  return $res;
    }
    
    function is_set($aKey) {
    	if (!session_id()) session_start();
    	return array_key_exists($aKey,  $_SESSION);
    }

    function set($aKey, $aValue) {
        if (!session_id()) session_start();
        if ($aValue !== null) $_SESSION[$aKey] = $aValue;
        else Session::remove($_SESSION[$aKey]);
    }

    function remove($aKey) {
        if (!session_id()) session_start();
        unset($_SESSION[$aKey]);
    }

    function removeall() {
        if (!session_id()) session_start();
        $_SESSION = array();
    }

    function destroy() {
        if (!session_id()) session_start();
        session_destroy();
    }
}

?>