/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.HashMap;
import org.w3c.dom.Node;
import unity.annotation.CommonMethods;
import unity.annotation.SourceJoin;
import unity.annotation.SourceKey;

public class AnnotatedSourceJoin
extends SourceJoin {
    private int joinType;

    public AnnotatedSourceJoin() {
        this(null, null, "", 0);
    }

    public AnnotatedSourceJoin(SourceKey from, SourceKey to, String join, int type) {
        super(from, to, join);
        this.joinType = type;
        this.joinName = "";
        this.fromKeyName = "";
        this.toTableName = "";
        this.fromTableName = "";
        this.toKeyName = "";
    }

    public void setType(int type) {
        this.joinType = type;
    }

    public int getType() {
        return this.joinType;
    }

    public String getTypeName() {
        if (this.joinType == 0) {
            return "Undefined";
        }
        if (this.joinType == 1) {
            return "1-1";
        }
        if (this.joinType == 2) {
            return "1-N";
        }
        if (this.joinType == 3) {
            return "N-1";
        }
        return "M-N";
    }

    public String toString() {
        return super.toString();
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toXML());
        buf.append("      <joinType>" + this.joinType + "</joinType>");
        return buf.toString();
    }

    public void importXML(Node x, HashMap fields) {
        Node child = x.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("joinName")) {
                this.joinName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("fromKeyName")) {
                this.fromKeyName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("joinType")) {
                this.joinType = CommonMethods.getIntName(child);
            } else if (child.getNodeName().equals("toTableName")) {
                this.toTableName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("fromTableName")) {
                this.fromTableName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("toKeyName")) {
                this.toKeyName = CommonMethods.getName(child);
            }
            child = child.getNextSibling();
        }
    }
}

