/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Arrays;
import unity.io.FileManager;
import unity.operators.Operator;
import unity.predicates.EquiJoinPredicate;
import unity.predicates.SortComparator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class NestedLoopJoin
extends Operator {
    private EquiJoinPredicate pred;
    private Tuple tupleLeft;
    private Tuple tupleRight;
    private Tuple[] bufferLeft;
    private int bufferCapacity;
    private int bufferCount;
    private int locationLeftInput;
    private SortComparator sorter;
    private boolean onePass;
    private boolean firstPass;
    private BufferedOutputStream outFile;
    private String rightFileName;
    private BufferedInputStream inFile;

    public NestedLoopJoin(Operator[] in, EquiJoinPredicate p, int bufferSize) {
        super(in, 0, 0);
        this.pred = p;
        this.bufferCapacity = bufferSize;
        Relation out = new Relation(this.input[0].getOutputRelation());
        out.mergeRelation(this.input[1].getOutputRelation());
        this.setOutputRelation(out);
    }

    public void init() throws IOException {
        this.input[0].init();
        this.input[1].init();
        this.locationLeftInput = 0;
        this.bufferLeft = new Tuple[this.bufferCapacity];
        if (this.pred != null) {
            boolean[] sa = new boolean[this.pred.getNumAttr()];
            Arrays.fill(sa, true);
            this.sorter = new SortComparator(this.pred.getRelation1Locs(), sa);
        }
        this.tupleRight = this.input[1].next();
        if (this.tupleRight != null) {
            this.onePass = this.fillLeftBuffer();
            if (!this.onePass) {
                this.rightFileName = FileManager.createTempFileName("nlj_rightfile");
                this.outFile = FileManager.openOutputFile(this.rightFileName);
            }
            this.firstPass = true;
            if (this.pred == null) {
                this.locationLeftInput = 0;
            } else {
                this.findLoc(this.tupleRight);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Tuple next() throws IOException {
        ** GOTO lbl38
        {
            if (this.onePass) {
                this.tupleRight = this.input[1].next();
                if (this.tupleRight == null) {
                    return null;
                }
            } else {
                resetRight = false;
                if (this.firstPass) {
                    this.tupleRight.write(this.outFile);
                    this.tupleRight = this.input[1].next();
                    if (this.tupleRight == null) {
                        this.input[1].close();
                        FileManager.closeFile(this.outFile);
                        resetRight = true;
                        this.firstPass = false;
                        this.tupleRight = new Tuple(this.input[1].getOutputRelation());
                    }
                } else if (!this.tupleRight.read(this.inFile)) {
                    FileManager.closeFile(this.inFile);
                    resetRight = true;
                }
                if (resetRight) {
                    this.inFile = FileManager.openInputFile(this.rightFileName);
                    this.fillLeftBuffer();
                    if (this.bufferCount == 0) {
                        return null;
                    }
                    this.tupleRight.read(this.inFile);
                }
            }
            this.locationLeftInput = this.pred == null ? 0 : this.findLoc(this.tupleRight);
            do {
                if (this.locationLeftInput == this.bufferCount) continue block0;
                this.tupleLeft = this.bufferLeft[this.locationLeftInput];
                ++this.locationLeftInput;
                if (this.pred == null || this.pred.isEqual(this.tupleLeft, this.tupleRight)) {
                    return this.outputJoinTuple(this.tupleLeft, this.tupleRight);
                }
                if (this.pred == null) continue;
                this.locationLeftInput = this.bufferCount;
lbl38:
                // 3 sources

            } while (this.tupleRight != null);
        }
        return null;
    }

    private int findLoc(Tuple tupleRight) throws IOException {
        int mid = 0;
        boolean found = false;
        int first = 0;
        int last = this.bufferCount - 1;
        int loc = -1;
        while (!found && first <= last) {
            mid = (first + last) / 2;
            if (this.pred.isEqual(this.bufferLeft[mid], tupleRight)) {
                found = true;
                continue;
            }
            if (this.pred.isGreaterThan(this.bufferLeft[mid], tupleRight)) {
                last = mid - 1;
                continue;
            }
            first = mid + 1;
        }
        if (found) {
            loc = mid;
        }
        while (loc > 0 && this.pred.isEqual(this.bufferLeft[loc], tupleRight)) {
            --loc;
        }
        if (loc > 0) {
            ++loc;
        }
        if (!found) {
            return this.bufferCount;
        }
        return loc;
    }

    public void close() throws IOException {
        super.close();
    }

    private Tuple outputJoinTuple(Tuple left, Tuple right) {
        Tuple t = new Tuple(left, right, this.getOutputRelation());
        this.incrementTuplesOutput();
        return t;
    }

    private boolean fillLeftBuffer() throws IOException {
        boolean retVal = false;
        this.bufferCount = 0;
        while (this.bufferCount < this.bufferCapacity) {
            Tuple t = this.input[0].next();
            if (t == null) {
                retVal = true;
                break;
            }
            this.bufferLeft[this.bufferCount++] = t;
        }
        if (this.pred != null) {
            Arrays.sort(this.bufferLeft, 0, this.bufferCount, this.sorter);
        }
        return retVal;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("NESTED LOOP JOIN: ");
        if (this.pred != null) {
            sb.append(this.pred.toString(this.input[0].getOutputRelation(), this.input[1].getOutputRelation()));
        } else {
            sb.append("CROSS-PRODUCT");
        }
        sb.append("   (BufferSizeInTuples=" + this.bufferCapacity + ")");
        return sb.toString();
    }
}

