/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class PlsqlTTCDataSet
extends TTCDataSet {
    private PlsqlTTCColumn[] columns;
    private byte[] userIOVector;
    private byte[] realIOVector;

    protected PlsqlTTCDataSet(PlsqlTTCColumn[] plsqlTTCColumnArray, byte[] byArray) {
        super(plsqlTTCColumnArray, plsqlTTCColumnArray.length == 0 ? 0 : 1);
        this.columns = plsqlTTCColumnArray != null ? plsqlTTCColumnArray : new PlsqlTTCColumn[]{};
        this.userIOVector = byArray;
    }

    protected void marshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n2 = 0;
        while (n2 < this.realIOVector.length) {
            if ((this.realIOVector[n2] & 0x20) != 0) {
                this.columns[n2].marshal();
            }
            ++n2;
        }
        this.marshaledRows = 1;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n2 = 0;
        while (n2 < this.realIOVector.length) {
            if ((this.realIOVector[n2] & 0x10) != 0) {
                this.columns[n2].unmarshal();
            }
            ++n2;
        }
        this.unmarshaledRows = 1;
        return false;
    }

    protected boolean next() {
        return this.realIOVector != null;
    }

    protected void setIOVector(byte[] byArray) {
        this.realIOVector = byArray;
    }

    protected void print(int n2, int n3, int n4) {
        int n5;
        OracleLog.print(this, n2, n3, n4, " \n   ---- Enter: PlsqlTTCDataSet.print --- ");
        super.print(n2, n3, n4);
        OracleLog.print(this, n2, n3, n4, "\n      +++ userIOVector info +++++++ ");
        if (this.userIOVector == null) {
            OracleLog.print(this, n2, n3, n4, " User IOVector is NULL ");
        } else {
            OracleLog.print(this, n2, n3, n4, "      userIOVector.length = " + this.userIOVector.length);
            n5 = 0;
            while (n5 < this.userIOVector.length) {
                OracleLog.print(this, n2, n3, n4, "      userIOVector[" + n5 + "] = " + this.userIOVector[n5]);
                ++n5;
            }
        }
        OracleLog.print(this, n2, n3, n4, "      +++ End of userIOVector Info +++++++");
        OracleLog.print(this, n2, n3, n4, "\n      +++ realIOVector info +++++++");
        if (this.realIOVector == null) {
            OracleLog.print(this, n2, n3, n4, " Real IOVector is NULL ");
        } else {
            OracleLog.print(this, n2, n3, n4, "      realIOVector.length = " + this.realIOVector.length);
            n5 = 0;
            while (n5 < this.realIOVector.length) {
                OracleLog.print(this, n2, n3, n4, "       realIOVector[" + n5 + "] = " + this.realIOVector[n5]);
                ++n5;
            }
        }
        OracleLog.print(this, n2, n3, n4, "      +++ End of realIOVector Info +++++++ ");
        OracleLog.print(this, n2, n3, n4, "    ---- Exit: PlsqlTTCDataSet.print --- \n");
    }
}

