/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DefaultButton
implements Icon,
Border,
UIResource,
Serializable {
    public transient Image topleft;
    public transient Image topright;
    public transient Image bottomleft;
    public transient Image bottomright;
    public transient Image top;
    public transient Image right;
    public transient Image bottom;
    public transient Image left;
    public transient Image center;
    protected int topHeight;
    protected int bottomHeight;
    protected int leftWidth;
    protected int rightWidth;
    protected int imageWidth;
    protected int imageHeight;
    protected int top_fill = 1;
    protected int right_fill = 1;
    protected int bottom_fill = 1;
    protected int left_fill = 1;
    protected int center_fill = 1;
    protected boolean tile;
    protected Insets insets;

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, Component component) {
        if (SkinUtils.DEBUG) {
            System.out.println("Painting (" + n + "," + n2 + "," + n3 + "x" + n4 + ") for " + component);
        }
        ImageUtils.paint(component, graphics, this.center, n + this.leftWidth, n2 + this.topHeight, n3 - this.leftWidth - this.rightWidth, n4 - this.topHeight - this.bottomHeight, false, this.center_fill);
        this.paintBorder(component, graphics, n, n2, n3, n4);
        if (SkinUtils.DEBUG) {
            graphics.setColor(Color.black);
            graphics.drawRect(n + this.leftWidth, n2 + this.topHeight, n3 - this.leftWidth - this.rightWidth, n4 - this.topHeight - this.bottomHeight);
            graphics.drawLine(n + this.leftWidth, n2, n + this.leftWidth, n2 + n4);
            graphics.drawLine(n + n3 - this.rightWidth, n2, n + n3 - this.rightWidth, n2 + n4);
            graphics.drawLine(n, n2 + this.topHeight, n + n3, n2 + this.topHeight);
            graphics.drawLine(n, n2 + n4 - this.bottomHeight, n + n3, n2 + n4 - this.bottomHeight);
        }
    }

    public DefaultButton() {
    }

    public DefaultButton(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        this(image, n, n2, n3, n4, n5, n6, false);
    }

    public DefaultButton(Image image, Image image2, Image image3, Image image4, Image image5, Image image6, Image image7, Image image8) {
        this.top = image;
        this.bottom = image2;
        this.left = image3;
        this.right = image4;
        this.topleft = image5;
        this.bottomleft = image7;
        this.topright = image6;
        this.bottomright = image8;
        this.topHeight = image != null ? image.getHeight(null) : (this.topleft != null ? this.topleft.getHeight(null) : 0);
        this.rightWidth = image4 != null ? image4.getWidth(null) : 0;
        this.bottomHeight = image2 != null ? image2.getHeight(null) : 0;
        this.leftWidth = image3 != null ? image3.getWidth(null) : 0;
        this.insets = new Insets(image != null ? this.topHeight : 0, this.leftWidth, this.bottomHeight, this.rightWidth);
    }

    public DefaultButton(Image image, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.topHeight = n3;
        this.rightWidth = n4;
        this.bottomHeight = n5;
        this.leftWidth = n6;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.tile = bl;
        this.insets = new Insets(n3, n6, n5, n4);
        this.topleft = ImageUtils.grab(image, 0, 0, n6, n3);
        this.topright = ImageUtils.grab(image, n - n4, 0, n4, n3);
        this.bottomleft = ImageUtils.grab(image, 0, n2 - n5, n6, n5);
        this.bottomright = ImageUtils.grab(image, n - n4, n2 - n5, n4, n5);
        this.top = ImageUtils.grab(image, n6, 0, n - n6 - n4, n3);
        if (n4 > 0) {
            this.right = ImageUtils.grab(image, n - n4, n3, n4, n2 - n3 - n5);
        }
        if (n5 > 0) {
            this.bottom = ImageUtils.grab(image, n6, n2 - n5, n - n6 - n4, n5);
        }
        if (n6 > 0) {
            this.left = ImageUtils.grab(image, 0, n3, n6, n2 - n3 - n5);
        }
        this.center = ImageUtils.grab(image, n6, n3, n - n6 - n4, n2 - n3 - n5);
    }

    public void setCenterFill(int n) {
        this.center_fill = n;
    }

    public DefaultButton getDisabled() {
        DefaultButton defaultButton = new DefaultButton();
        defaultButton.topleft = ImageUtils.getDisabledImage(this.topleft);
        defaultButton.topright = ImageUtils.getDisabledImage(this.topright);
        defaultButton.bottomleft = ImageUtils.getDisabledImage(this.bottomleft);
        defaultButton.bottomright = ImageUtils.getDisabledImage(this.bottomright);
        defaultButton.top = ImageUtils.getDisabledImage(this.top);
        defaultButton.right = ImageUtils.getDisabledImage(this.right);
        defaultButton.bottom = ImageUtils.getDisabledImage(this.bottom);
        defaultButton.left = ImageUtils.getDisabledImage(this.left);
        defaultButton.center = ImageUtils.getDisabledImage(this.center);
        defaultButton.topHeight = this.topHeight;
        defaultButton.bottomHeight = this.bottomHeight;
        defaultButton.leftWidth = this.leftWidth;
        defaultButton.rightWidth = this.rightWidth;
        defaultButton.imageWidth = this.imageWidth;
        defaultButton.imageHeight = this.imageHeight;
        defaultButton.top_fill = this.top_fill;
        defaultButton.right_fill = this.right_fill;
        defaultButton.bottom_fill = this.bottom_fill;
        defaultButton.left_fill = this.left_fill;
        defaultButton.center_fill = this.center_fill;
        defaultButton.tile = this.tile;
        defaultButton.insets = this.insets;
        return defaultButton;
    }

    public DefaultButton getTopToBottom() {
        DefaultButton defaultButton = new DefaultButton();
        defaultButton.top = ImageUtils.flipHorizontally(this.bottom);
        defaultButton.topHeight = this.bottomHeight;
        defaultButton.top_fill = this.bottom_fill;
        defaultButton.topleft = ImageUtils.flipHorizontally(this.bottomleft);
        defaultButton.bottomleft = ImageUtils.flipHorizontally(this.topleft);
        defaultButton.topright = ImageUtils.flipHorizontally(this.bottomright);
        defaultButton.bottomright = ImageUtils.flipHorizontally(this.topright);
        defaultButton.bottom = ImageUtils.flipHorizontally(this.top);
        defaultButton.bottomHeight = this.topHeight;
        defaultButton.bottom_fill = this.top_fill;
        defaultButton.left = ImageUtils.flipHorizontally(this.left);
        defaultButton.leftWidth = this.leftWidth;
        defaultButton.left_fill = this.left_fill;
        defaultButton.right = ImageUtils.flipHorizontally(this.right);
        defaultButton.rightWidth = this.rightWidth;
        defaultButton.right_fill = this.right_fill;
        defaultButton.center = ImageUtils.flipHorizontally(this.center);
        defaultButton.center_fill = this.center_fill;
        defaultButton.imageWidth = this.imageWidth;
        defaultButton.imageHeight = this.imageHeight;
        defaultButton.tile = this.tile;
        defaultButton.insets = new Insets(this.insets.bottom, this.insets.left, this.insets.top, this.insets.right);
        return defaultButton;
    }

    public DefaultButton rotateCounterClockWise() {
        DefaultButton defaultButton = new DefaultButton();
        defaultButton.top = ImageUtils.rotateLeft(this.right);
        defaultButton.topHeight = this.rightWidth;
        defaultButton.top_fill = this.right_fill;
        defaultButton.topleft = ImageUtils.rotateLeft(this.topright);
        defaultButton.bottomleft = ImageUtils.rotateLeft(this.topleft);
        defaultButton.topright = ImageUtils.rotateLeft(this.bottomright);
        defaultButton.bottomright = ImageUtils.rotateLeft(this.bottomleft);
        defaultButton.bottom = ImageUtils.rotateLeft(this.left);
        defaultButton.bottomHeight = this.leftWidth;
        defaultButton.bottom_fill = this.left_fill;
        defaultButton.left = ImageUtils.rotateLeft(this.top);
        defaultButton.leftWidth = this.topHeight;
        defaultButton.left_fill = this.top_fill;
        defaultButton.right = ImageUtils.rotateLeft(this.bottom);
        defaultButton.rightWidth = this.bottomHeight;
        defaultButton.right_fill = this.bottom_fill;
        defaultButton.center = ImageUtils.rotateLeft(this.center);
        defaultButton.center_fill = this.center_fill;
        defaultButton.imageWidth = this.imageHeight;
        defaultButton.imageHeight = this.imageWidth;
        defaultButton.tile = this.tile;
        defaultButton.insets = new Insets(this.insets.left, this.insets.top, this.insets.right, this.insets.bottom);
        return defaultButton;
    }

    public DefaultButton rotateClockWise() {
        DefaultButton defaultButton = new DefaultButton();
        defaultButton.center = ImageUtils.rotateRight(this.center);
        defaultButton.center_fill = this.center_fill;
        defaultButton.top = ImageUtils.rotateRight(this.left);
        defaultButton.topHeight = this.leftWidth;
        defaultButton.top_fill = this.left_fill;
        defaultButton.right = ImageUtils.rotateRight(this.top);
        defaultButton.rightWidth = this.topHeight;
        defaultButton.right_fill = this.top_fill;
        defaultButton.bottom = ImageUtils.rotateRight(this.right);
        defaultButton.bottomHeight = this.rightWidth;
        defaultButton.bottom_fill = this.right_fill;
        defaultButton.left = ImageUtils.rotateRight(this.bottom);
        defaultButton.leftWidth = this.bottomHeight;
        defaultButton.left_fill = this.bottom_fill;
        defaultButton.topleft = ImageUtils.rotateRight(this.bottomleft);
        defaultButton.topright = ImageUtils.rotateRight(this.topleft);
        defaultButton.bottomleft = ImageUtils.rotateRight(this.bottomright);
        defaultButton.bottomright = ImageUtils.rotateRight(this.topright);
        defaultButton.imageWidth = this.imageHeight;
        defaultButton.imageHeight = this.imageWidth;
        defaultButton.tile = this.tile;
        defaultButton.insets = new Insets(this.leftWidth, this.bottomHeight, this.rightWidth, this.topHeight);
        return defaultButton;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String toString() {
        return "DefaultButton(" + this.getWidth() + "x" + this.getHeight() + ",center_fill=" + this.center_fill + ")";
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.center != null) {
            graphics.drawImage(this.center, n, n2, component);
        }
    }

    public void paint(Graphics graphics, Component component) {
        this.paint(graphics, 0, 0, component);
    }

    public void paint(Graphics graphics, int n, int n2, Component component) {
        this.paint(graphics, n, n2, ((JComponent)component).getWidth(), ((JComponent)component).getHeight(), component);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.top != null) {
            ImageUtils.paint(component, graphics, this.top, n + (this.topleft != null ? this.leftWidth : 0), n2, n3 - (this.topleft != null ? this.leftWidth : 0) - (this.topright != null ? this.rightWidth : 0), this.topHeight, false, this.top_fill);
        }
        if (this.right != null) {
            ImageUtils.paint(component, graphics, this.right, n + n3 - this.rightWidth, n2 + this.topHeight, this.rightWidth, n4 - this.topHeight - this.bottomHeight, false, this.right_fill);
        }
        if (this.bottom != null) {
            ImageUtils.paint(component, graphics, this.bottom, n + (this.topleft != null ? this.leftWidth : 0), n2 + n4 - this.bottomHeight, n3 - (this.topleft != null ? this.leftWidth : 0) - (this.topright != null ? this.rightWidth : 0), this.bottomHeight, false, this.bottom_fill);
        }
        if (this.left != null) {
            ImageUtils.paint(component, graphics, this.left, n, n2 + this.topHeight, this.leftWidth, n4 - this.topHeight - this.bottomHeight, false, this.left_fill);
        }
        if (this.topleft != null) {
            ImageUtils.paint(component, graphics, this.topleft, n, n2, 0, 0, false, 0);
        }
        if (this.topright != null) {
            ImageUtils.paint(component, graphics, this.topright, n + n3 - this.topright.getWidth(null), n2, 0, 0, false, 0);
        }
        if (this.bottomleft != null) {
            ImageUtils.paint(component, graphics, this.bottomleft, n, n2 + n4 - this.bottomleft.getHeight(null), 0, 0, false, 0);
        }
        if (this.bottomright != null) {
            ImageUtils.paint(component, graphics, this.bottomright, n + n3 - this.bottomright.getWidth(null), n2 + n4 - this.bottomright.getHeight(null), 0, 0, false, 0);
        }
    }

    public void paintWindow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Component component) {
        ImageUtils.paintWindow(component, graphics, this.center, this.leftWidth, this.topHeight, n - this.leftWidth - this.rightWidth, n2 - this.topHeight - this.bottomHeight, n3, n4, n5, n6, false, this.center_fill);
        this.paintBorder(component, graphics, 0, 0, n, n2);
    }
}

